/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.conductor.common.metadata.tasks;

import java.util.Objects;

public class TaskExecLog {
    private String log;
    private String taskId;
    private long createdTime;

    public TaskExecLog(String log) {
        this.log = log;
        this.createdTime = System.currentTimeMillis();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TaskExecLog that = (TaskExecLog)o;
        return this.createdTime == that.createdTime && Objects.equals(this.log, that.log) && Objects.equals(this.taskId, that.taskId);
    }

    public int hashCode() {
        return Objects.hash(this.log, this.taskId, this.createdTime);
    }

    public static TaskExecLogBuilder builder() {
        return new TaskExecLogBuilder();
    }

    public String getLog() {
        return this.log;
    }

    public String getTaskId() {
        return this.taskId;
    }

    public long getCreatedTime() {
        return this.createdTime;
    }

    public void setLog(String log) {
        this.log = log;
    }

    public void setTaskId(String taskId) {
        this.taskId = taskId;
    }

    public void setCreatedTime(long createdTime) {
        this.createdTime = createdTime;
    }

    public String toString() {
        return "TaskExecLog(log=" + this.getLog() + ", taskId=" + this.getTaskId() + ", createdTime=" + this.getCreatedTime() + ")";
    }

    public TaskExecLog() {
    }

    private TaskExecLog(String log, String taskId, long createdTime) {
        this.log = log;
        this.taskId = taskId;
        this.createdTime = createdTime;
    }

    public static class TaskExecLogBuilder {
        private String log;
        private String taskId;
        private long createdTime;

        TaskExecLogBuilder() {
        }

        public TaskExecLogBuilder log(String log) {
            this.log = log;
            return this;
        }

        public TaskExecLogBuilder taskId(String taskId) {
            this.taskId = taskId;
            return this;
        }

        public TaskExecLogBuilder createdTime(long createdTime) {
            this.createdTime = createdTime;
            return this;
        }

        public TaskExecLog build() {
            return new TaskExecLog(this.log, this.taskId, this.createdTime);
        }

        public String toString() {
            return "TaskExecLog.TaskExecLogBuilder(log=" + this.log + ", taskId=" + this.taskId + ", createdTime=" + this.createdTime + ")";
        }
    }
}

