/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.conductor.common.metadata.workflow;

import com.netflix.conductor.common.metadata.workflow.IdempotencyStrategy;
import com.netflix.conductor.common.metadata.workflow.WorkflowDef;
import com.netflix.conductor.common.utils.TaskUtils;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;

public class SubWorkflowParams {
    private String name;
    private Integer version;
    private Map<String, String> taskToDomain;
    private Object workflowDefinition;
    private String idempotencyKey;
    private IdempotencyStrategy idempotencyStrategy;
    private Object priority;

    public String getName() {
        if (this.workflowDefinition != null && this.workflowDefinition instanceof WorkflowDef) {
            return ((WorkflowDef)this.workflowDefinition).getName();
        }
        return this.name;
    }

    public Integer getVersion() {
        if (this.workflowDefinition != null && this.workflowDefinition instanceof WorkflowDef) {
            return ((WorkflowDef)this.workflowDefinition).getVersion();
        }
        return this.version;
    }

    public Object getWorkflowDefinition() {
        return this.workflowDefinition;
    }

    @Deprecated
    public void setWorkflowDef(WorkflowDef workflowDef) {
        this.setWorkflowDefinition(workflowDef);
    }

    @Deprecated
    public WorkflowDef getWorkflowDef() {
        return (WorkflowDef)this.workflowDefinition;
    }

    public void setWorkflowDefinition(Object workflowDef) {
        if (workflowDef == null) {
            this.workflowDefinition = null;
        } else if (workflowDef instanceof WorkflowDef) {
            this.workflowDefinition = workflowDef;
        } else if (workflowDef instanceof String) {
            if (!((String)workflowDef).startsWith("${") || !((String)workflowDef).endsWith("}")) {
                throw new IllegalArgumentException("workflowDefinition is a string, but not a valid DSL string");
            }
            this.workflowDefinition = workflowDef;
        } else if (workflowDef instanceof LinkedHashMap) {
            this.workflowDefinition = TaskUtils.convertToWorkflowDef(workflowDef);
        } else {
            throw new IllegalArgumentException("workflowDefinition must be either null, or WorkflowDef, or a valid DSL string");
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SubWorkflowParams that = (SubWorkflowParams)o;
        return Objects.equals(this.getName(), that.getName()) && Objects.equals(this.getVersion(), that.getVersion()) && Objects.equals(this.getTaskToDomain(), that.getTaskToDomain()) && Objects.equals(this.getWorkflowDefinition(), that.getWorkflowDefinition());
    }

    public static SubWorkflowParamsBuilder builder() {
        return new SubWorkflowParamsBuilder();
    }

    public Map<String, String> getTaskToDomain() {
        return this.taskToDomain;
    }

    public String getIdempotencyKey() {
        return this.idempotencyKey;
    }

    public IdempotencyStrategy getIdempotencyStrategy() {
        return this.idempotencyStrategy;
    }

    public Object getPriority() {
        return this.priority;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setVersion(Integer version) {
        this.version = version;
    }

    public void setTaskToDomain(Map<String, String> taskToDomain) {
        this.taskToDomain = taskToDomain;
    }

    public void setIdempotencyKey(String idempotencyKey) {
        this.idempotencyKey = idempotencyKey;
    }

    public void setIdempotencyStrategy(IdempotencyStrategy idempotencyStrategy) {
        this.idempotencyStrategy = idempotencyStrategy;
    }

    public void setPriority(Object priority) {
        this.priority = priority;
    }

    public String toString() {
        return "SubWorkflowParams(name=" + this.getName() + ", version=" + this.getVersion() + ", taskToDomain=" + String.valueOf(this.getTaskToDomain()) + ", workflowDefinition=" + String.valueOf(this.getWorkflowDefinition()) + ", idempotencyKey=" + this.getIdempotencyKey() + ", idempotencyStrategy=" + String.valueOf((Object)this.getIdempotencyStrategy()) + ", priority=" + String.valueOf(this.getPriority()) + ")";
    }

    public SubWorkflowParams() {
    }

    private SubWorkflowParams(String name, Integer version, Map<String, String> taskToDomain, Object workflowDefinition, String idempotencyKey, IdempotencyStrategy idempotencyStrategy, Object priority) {
        this.name = name;
        this.version = version;
        this.taskToDomain = taskToDomain;
        this.workflowDefinition = workflowDefinition;
        this.idempotencyKey = idempotencyKey;
        this.idempotencyStrategy = idempotencyStrategy;
        this.priority = priority;
    }

    public static class SubWorkflowParamsBuilder {
        private String name;
        private Integer version;
        private Map<String, String> taskToDomain;
        private Object workflowDefinition;
        private String idempotencyKey;
        private IdempotencyStrategy idempotencyStrategy;
        private Object priority;

        SubWorkflowParamsBuilder() {
        }

        public SubWorkflowParamsBuilder name(String name) {
            this.name = name;
            return this;
        }

        public SubWorkflowParamsBuilder version(Integer version) {
            this.version = version;
            return this;
        }

        public SubWorkflowParamsBuilder taskToDomain(Map<String, String> taskToDomain) {
            this.taskToDomain = taskToDomain;
            return this;
        }

        public SubWorkflowParamsBuilder workflowDefinition(Object workflowDefinition) {
            this.workflowDefinition = workflowDefinition;
            return this;
        }

        public SubWorkflowParamsBuilder idempotencyKey(String idempotencyKey) {
            this.idempotencyKey = idempotencyKey;
            return this;
        }

        public SubWorkflowParamsBuilder idempotencyStrategy(IdempotencyStrategy idempotencyStrategy) {
            this.idempotencyStrategy = idempotencyStrategy;
            return this;
        }

        public SubWorkflowParamsBuilder priority(Object priority) {
            this.priority = priority;
            return this;
        }

        public SubWorkflowParams build() {
            return new SubWorkflowParams(this.name, this.version, this.taskToDomain, this.workflowDefinition, this.idempotencyKey, this.idempotencyStrategy, this.priority);
        }

        public String toString() {
            return "SubWorkflowParams.SubWorkflowParamsBuilder(name=" + this.name + ", version=" + this.version + ", taskToDomain=" + String.valueOf(this.taskToDomain) + ", workflowDefinition=" + String.valueOf(this.workflowDefinition) + ", idempotencyKey=" + this.idempotencyKey + ", idempotencyStrategy=" + String.valueOf((Object)this.idempotencyStrategy) + ", priority=" + String.valueOf(this.priority) + ")";
        }
    }
}

