/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.conductor.client.events.taskrunner;

import com.netflix.conductor.client.events.taskrunner.TaskRunnerEvent;
import java.time.Duration;

public final class TaskExecutionFailure
extends TaskRunnerEvent {
    public final String taskId;
    public final String workerId;
    private final Duration duration;
    private final Throwable cause;

    public TaskExecutionFailure(String taskType, String taskId, String workerId, Throwable cause, long durationInMillis) {
        super(taskType);
        this.cause = cause;
        this.taskId = taskId;
        this.workerId = workerId;
        this.duration = Duration.ofMillis(durationInMillis);
    }

    public String getTaskId() {
        return this.taskId;
    }

    public String getWorkerId() {
        return this.workerId;
    }

    public Duration getDuration() {
        return this.duration;
    }

    public Throwable getCause() {
        return this.cause;
    }

    @Override
    public String toString() {
        return "TaskExecutionFailure(taskId=" + this.getTaskId() + ", workerId=" + this.getWorkerId() + ", duration=" + String.valueOf(this.getDuration()) + ", cause=" + String.valueOf(this.getCause()) + ")";
    }
}

