/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.conductor.client.http;

import com.fasterxml.jackson.core.type.TypeReference;
import com.netflix.conductor.client.exception.ConductorClientException;
import com.netflix.conductor.client.http.ConductorClient;
import com.netflix.conductor.client.http.ConductorClientRequest;
import com.netflix.conductor.client.http.ConductorClientResponse;
import com.netflix.conductor.common.run.ExternalStorageLocation;
import com.netflix.conductor.common.utils.ExternalPayloadStorage;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class PayloadStorage
implements ExternalPayloadStorage {
    private static final Logger log = LoggerFactory.getLogger(PayloadStorage.class);
    private static final int BUFFER_SIZE = 32768;
    private final ConductorClient client;

    PayloadStorage(ConductorClient client) {
        this.client = client;
    }

    @Override
    public ExternalStorageLocation getLocation(ExternalPayloadStorage.Operation operation, ExternalPayloadStorage.PayloadType payloadType, String path) {
        ConductorClientRequest request = ConductorClientRequest.builder().method(ConductorClientRequest.Method.GET).path("/{resource}/externalstoragelocation").addPathParam("resource", this.getResource(operation, payloadType)).addQueryParam("path", path).addQueryParam("operation", operation.toString()).addQueryParam("payloadType", payloadType.toString()).build();
        ConductorClientResponse<ExternalStorageLocation> resp = this.client.execute(request, new TypeReference<ExternalStorageLocation>(){});
        return resp.getData();
    }

    @NotNull
    private String getResource(ExternalPayloadStorage.Operation operation, ExternalPayloadStorage.PayloadType payloadType) {
        switch (payloadType) {
            case WORKFLOW_INPUT: 
            case WORKFLOW_OUTPUT: {
                return "workflow";
            }
            case TASK_INPUT: 
            case TASK_OUTPUT: {
                return "tasks";
            }
        }
        throw new ConductorClientException(String.format("Invalid payload type: %s for operation: %s", new Object[]{payloadType, operation}));
    }

    @Override
    public void upload(String uri, InputStream payload, long payloadSize) {
        HttpURLConnection connection = null;
        try {
            URL url = new URI(uri).toURL();
            connection = (HttpURLConnection)url.openConnection();
            connection.setDoOutput(true);
            connection.setRequestMethod("PUT");
            try (BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(connection.getOutputStream());){
                int bytesRead;
                byte[] buffer = new byte[32768];
                long totalBytes = 0L;
                while ((bytesRead = payload.read(buffer)) != -1) {
                    bufferedOutputStream.write(buffer, 0, bytesRead);
                    totalBytes += (long)bytesRead;
                }
                bufferedOutputStream.flush();
                int responseCode = connection.getResponseCode();
                if (!this.isSuccessful(responseCode)) {
                    String errorMsg = String.format("Unable to upload. Response code: %d", responseCode);
                    log.error(errorMsg);
                    throw new ConductorClientException(errorMsg);
                }
                log.debug("Uploaded {} bytes to uri: {}, with HTTP response code: {}", new Object[]{totalBytes, uri, responseCode});
            }
        }
        catch (MalformedURLException | URISyntaxException e) {
            String errorMsg = String.format("Invalid path specified: %s", uri);
            log.error(errorMsg, (Throwable)e);
            throw new ConductorClientException(e);
        }
        catch (IOException e) {
            String errorMsg = String.format("Error uploading to path: %s", uri);
            log.error(errorMsg, (Throwable)e);
            throw new ConductorClientException(e);
        }
        finally {
            if (connection != null) {
                connection.disconnect();
            }
            try {
                if (payload != null) {
                    payload.close();
                }
            }
            catch (IOException e) {
                log.warn("Unable to close input stream when uploading to uri: {}", (Object)uri);
            }
        }
    }

    @Override
    public InputStream download(String uri) {
        try {
            URL url = new URI(uri).toURL();
            HttpURLConnection connection = (HttpURLConnection)url.openConnection();
            connection.setDoOutput(false);
            int responseCode = connection.getResponseCode();
            if (responseCode == 200) {
                log.debug("Download completed with HTTP response code: {}", (Object)connection.getResponseCode());
                return new BufferedInputStream(connection.getInputStream());
            }
            String errorMsg = String.format("Unable to download. Response code: %d", responseCode);
            log.error(errorMsg);
            throw new ConductorClientException(errorMsg);
        }
        catch (MalformedURLException | URISyntaxException e) {
            String errorMsg = String.format("Invalid uri specified: %s", uri);
            log.error(errorMsg, (Throwable)e);
            throw new ConductorClientException(e);
        }
        catch (IOException e) {
            String errorMsg = String.format("Error downloading from uri: %s", uri);
            log.error(errorMsg, (Throwable)e);
            throw new ConductorClientException(e);
        }
    }

    private boolean isSuccessful(int responseCode) {
        return responseCode >= 200 && responseCode < 300;
    }
}

