/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.conductor.common.metadata.tasks;

import com.netflix.conductor.common.metadata.Auditable;
import com.netflix.conductor.common.metadata.SchemaDef;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class TaskDef
extends Auditable {
    public static final int ONE_HOUR = 3600;
    private String name;
    private String description;
    private int retryCount = 3;
    private long timeoutSeconds;
    private List<String> inputKeys = new ArrayList<String>();
    private List<String> outputKeys = new ArrayList<String>();
    private TimeoutPolicy timeoutPolicy = TimeoutPolicy.TIME_OUT_WF;
    private RetryLogic retryLogic = RetryLogic.FIXED;
    private int retryDelaySeconds = 60;
    private long responseTimeoutSeconds = 3600L;
    private Integer concurrentExecLimit;
    private Map<String, Object> inputTemplate = new HashMap<String, Object>();
    private Integer rateLimitPerFrequency;
    private Integer rateLimitFrequencyInSeconds;
    private String isolationGroupId;
    private String executionNameSpace;
    private String ownerEmail;
    private Integer pollTimeoutSeconds;
    private Integer backoffScaleFactor = 1;
    private String baseType;
    private SchemaDef inputSchema;
    private SchemaDef outputSchema;
    private boolean enforceSchema;

    public TaskDef() {
    }

    public TaskDef(String name) {
        this.name = name;
    }

    public TaskDef(String name, String description) {
        this.name = name;
        this.description = description;
    }

    public TaskDef(String name, String description, int retryCount, long timeoutSeconds) {
        this.name = name;
        this.description = description;
        this.retryCount = retryCount;
        this.timeoutSeconds = timeoutSeconds;
    }

    public TaskDef(String name, String description, String ownerEmail, int retryCount, long timeoutSeconds, long responseTimeoutSeconds) {
        this.name = name;
        this.description = description;
        this.ownerEmail = ownerEmail;
        this.retryCount = retryCount;
        this.timeoutSeconds = timeoutSeconds;
        this.responseTimeoutSeconds = responseTimeoutSeconds;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public int getRetryCount() {
        return this.retryCount;
    }

    public void setRetryCount(int retryCount) {
        this.retryCount = retryCount;
    }

    public long getTimeoutSeconds() {
        return this.timeoutSeconds;
    }

    public void setTimeoutSeconds(long timeoutSeconds) {
        this.timeoutSeconds = timeoutSeconds;
    }

    public List<String> getInputKeys() {
        return this.inputKeys;
    }

    public void setInputKeys(List<String> inputKeys) {
        this.inputKeys = inputKeys;
    }

    public List<String> getOutputKeys() {
        return this.outputKeys;
    }

    public void setOutputKeys(List<String> outputKeys) {
        this.outputKeys = outputKeys;
    }

    public TimeoutPolicy getTimeoutPolicy() {
        return this.timeoutPolicy;
    }

    public void setTimeoutPolicy(TimeoutPolicy timeoutPolicy) {
        this.timeoutPolicy = timeoutPolicy;
    }

    public RetryLogic getRetryLogic() {
        return this.retryLogic;
    }

    public void setRetryLogic(RetryLogic retryLogic) {
        this.retryLogic = retryLogic;
    }

    public int getRetryDelaySeconds() {
        return this.retryDelaySeconds;
    }

    public long getResponseTimeoutSeconds() {
        return this.responseTimeoutSeconds;
    }

    public void setResponseTimeoutSeconds(long responseTimeoutSeconds) {
        this.responseTimeoutSeconds = responseTimeoutSeconds;
    }

    public void setRetryDelaySeconds(int retryDelaySeconds) {
        this.retryDelaySeconds = retryDelaySeconds;
    }

    public Map<String, Object> getInputTemplate() {
        return this.inputTemplate;
    }

    public Integer getRateLimitPerFrequency() {
        return this.rateLimitPerFrequency == null ? 0 : this.rateLimitPerFrequency;
    }

    public void setRateLimitPerFrequency(Integer rateLimitPerFrequency) {
        this.rateLimitPerFrequency = rateLimitPerFrequency;
    }

    public Integer getRateLimitFrequencyInSeconds() {
        return this.rateLimitFrequencyInSeconds == null ? 1 : this.rateLimitFrequencyInSeconds;
    }

    public void setRateLimitFrequencyInSeconds(Integer rateLimitFrequencyInSeconds) {
        this.rateLimitFrequencyInSeconds = rateLimitFrequencyInSeconds;
    }

    public void setConcurrentExecLimit(Integer concurrentExecLimit) {
        this.concurrentExecLimit = concurrentExecLimit;
    }

    public Integer getConcurrentExecLimit() {
        return this.concurrentExecLimit;
    }

    public int concurrencyLimit() {
        return this.concurrentExecLimit == null ? 0 : this.concurrentExecLimit;
    }

    public void setInputTemplate(Map<String, Object> inputTemplate) {
        this.inputTemplate = inputTemplate;
    }

    public String getIsolationGroupId() {
        return this.isolationGroupId;
    }

    public void setIsolationGroupId(String isolationGroupId) {
        this.isolationGroupId = isolationGroupId;
    }

    public String getExecutionNameSpace() {
        return this.executionNameSpace;
    }

    public void setExecutionNameSpace(String executionNameSpace) {
        this.executionNameSpace = executionNameSpace;
    }

    public String getOwnerEmail() {
        return this.ownerEmail;
    }

    public void setOwnerEmail(String ownerEmail) {
        this.ownerEmail = ownerEmail;
    }

    public void setPollTimeoutSeconds(Integer pollTimeoutSeconds) {
        this.pollTimeoutSeconds = pollTimeoutSeconds;
    }

    public Integer getPollTimeoutSeconds() {
        return this.pollTimeoutSeconds;
    }

    public void setBackoffScaleFactor(Integer backoffScaleFactor) {
        this.backoffScaleFactor = backoffScaleFactor;
    }

    public Integer getBackoffScaleFactor() {
        return this.backoffScaleFactor;
    }

    public String getBaseType() {
        return this.baseType;
    }

    public void setBaseType(String baseType) {
        this.baseType = baseType;
    }

    public SchemaDef getInputSchema() {
        return this.inputSchema;
    }

    public void setInputSchema(SchemaDef inputSchema) {
        this.inputSchema = inputSchema;
    }

    public SchemaDef getOutputSchema() {
        return this.outputSchema;
    }

    public void setOutputSchema(SchemaDef outputSchema) {
        this.outputSchema = outputSchema;
    }

    public boolean isEnforceSchema() {
        return this.enforceSchema;
    }

    public void setEnforceSchema(boolean enforceSchema) {
        this.enforceSchema = enforceSchema;
    }

    public String toString() {
        return this.name;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TaskDef taskDef = (TaskDef)o;
        return this.getRetryCount() == taskDef.getRetryCount() && this.getTimeoutSeconds() == taskDef.getTimeoutSeconds() && this.getRetryDelaySeconds() == taskDef.getRetryDelaySeconds() && this.getBackoffScaleFactor() == taskDef.getBackoffScaleFactor() && this.getResponseTimeoutSeconds() == taskDef.getResponseTimeoutSeconds() && Objects.equals(this.getName(), taskDef.getName()) && Objects.equals(this.getDescription(), taskDef.getDescription()) && Objects.equals(this.getInputKeys(), taskDef.getInputKeys()) && Objects.equals(this.getOutputKeys(), taskDef.getOutputKeys()) && this.getTimeoutPolicy() == taskDef.getTimeoutPolicy() && this.getRetryLogic() == taskDef.getRetryLogic() && Objects.equals(this.getConcurrentExecLimit(), taskDef.getConcurrentExecLimit()) && Objects.equals(this.getRateLimitPerFrequency(), taskDef.getRateLimitPerFrequency()) && Objects.equals(this.getInputTemplate(), taskDef.getInputTemplate()) && Objects.equals(this.getIsolationGroupId(), taskDef.getIsolationGroupId()) && Objects.equals(this.getExecutionNameSpace(), taskDef.getExecutionNameSpace()) && Objects.equals(this.getOwnerEmail(), taskDef.getOwnerEmail()) && Objects.equals(this.getBaseType(), taskDef.getBaseType()) && Objects.equals(this.getInputSchema(), taskDef.getInputSchema()) && Objects.equals(this.getOutputSchema(), taskDef.getOutputSchema());
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.getName(), this.getDescription(), this.getRetryCount(), this.getTimeoutSeconds(), this.getInputKeys(), this.getOutputKeys(), this.getTimeoutPolicy(), this.getRetryLogic(), this.getRetryDelaySeconds(), this.getBackoffScaleFactor(), this.getResponseTimeoutSeconds(), this.getConcurrentExecLimit(), this.getRateLimitPerFrequency(), this.getInputTemplate(), this.getIsolationGroupId(), this.getExecutionNameSpace(), this.getOwnerEmail(), this.getBaseType(), this.getInputSchema(), this.getOutputSchema()});
    }

    public static enum TimeoutPolicy {
        RETRY,
        TIME_OUT_WF,
        ALERT_ONLY;

    }

    public static enum RetryLogic {
        FIXED,
        EXPONENTIAL_BACKOFF,
        LINEAR_BACKOFF;

    }
}

