/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.conductor.common.metadata.workflow;

import com.netflix.conductor.common.metadata.workflow.IdempotencyStrategy;
import com.netflix.conductor.common.metadata.workflow.WorkflowDef;
import com.netflix.conductor.common.utils.TaskUtils;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;

public class SubWorkflowParams {
    private String name;
    private Integer version;
    private Map<String, String> taskToDomain;
    private Object workflowDefinition;
    private String idempotencyKey;
    private IdempotencyStrategy idempotencyStrategy;
    private Object priority;

    public String getIdempotencyKey() {
        return this.idempotencyKey;
    }

    public void setIdempotencyKey(String idempotencyKey) {
        this.idempotencyKey = idempotencyKey;
    }

    public IdempotencyStrategy getIdempotencyStrategy() {
        return this.idempotencyStrategy;
    }

    public void setIdempotencyStrategy(IdempotencyStrategy idempotencyStrategy) {
        this.idempotencyStrategy = idempotencyStrategy;
    }

    public String getName() {
        if (this.workflowDefinition != null && this.workflowDefinition instanceof WorkflowDef) {
            return ((WorkflowDef)this.workflowDefinition).getName();
        }
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Integer getVersion() {
        if (this.workflowDefinition != null && this.workflowDefinition instanceof WorkflowDef) {
            return ((WorkflowDef)this.workflowDefinition).getVersion();
        }
        return this.version;
    }

    public void setVersion(Integer version) {
        this.version = version;
    }

    public Map<String, String> getTaskToDomain() {
        return this.taskToDomain;
    }

    public void setTaskToDomain(Map<String, String> taskToDomain) {
        this.taskToDomain = taskToDomain;
    }

    public Object getWorkflowDefinition() {
        return this.workflowDefinition;
    }

    @Deprecated
    public void setWorkflowDef(WorkflowDef workflowDef) {
        this.setWorkflowDefinition(workflowDef);
    }

    @Deprecated
    public WorkflowDef getWorkflowDef() {
        return (WorkflowDef)this.workflowDefinition;
    }

    public void setWorkflowDefinition(Object workflowDef) {
        if (workflowDef == null) {
            this.workflowDefinition = null;
        } else if (workflowDef instanceof WorkflowDef) {
            this.workflowDefinition = workflowDef;
        } else if (workflowDef instanceof String) {
            if (!((String)workflowDef).startsWith("${") || !((String)workflowDef).endsWith("}")) {
                throw new IllegalArgumentException("workflowDefinition is a string, but not a valid DSL string");
            }
            this.workflowDefinition = workflowDef;
        } else if (workflowDef instanceof LinkedHashMap) {
            this.workflowDefinition = TaskUtils.convertToWorkflowDef(workflowDef);
        } else {
            throw new IllegalArgumentException("workflowDefinition must be either null, or WorkflowDef, or a valid DSL string");
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SubWorkflowParams that = (SubWorkflowParams)o;
        return Objects.equals(this.getName(), that.getName()) && Objects.equals(this.getVersion(), that.getVersion()) && Objects.equals(this.getTaskToDomain(), that.getTaskToDomain()) && Objects.equals(this.getWorkflowDefinition(), that.getWorkflowDefinition());
    }

    public Object getPriority() {
        return this.priority;
    }

    public void setPriority(Object priority) {
        this.priority = priority;
    }
}

