/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.conductor.common.metadata.workflow;

import com.netflix.conductor.common.metadata.Auditable;
import com.netflix.conductor.common.metadata.SchemaDef;
import com.netflix.conductor.common.metadata.tasks.TaskType;
import com.netflix.conductor.common.metadata.workflow.RateLimitConfig;
import com.netflix.conductor.common.metadata.workflow.WorkflowTask;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class WorkflowDef
extends Auditable {
    private String name;
    private String description;
    private int version = 1;
    private List<WorkflowTask> tasks = new LinkedList<WorkflowTask>();
    private List<String> inputParameters = new LinkedList<String>();
    private Map<String, Object> outputParameters = new HashMap<String, Object>();
    private String failureWorkflow;
    private int schemaVersion = 2;
    private boolean restartable = true;
    private boolean workflowStatusListenerEnabled = false;
    private String ownerEmail;
    private TimeoutPolicy timeoutPolicy = TimeoutPolicy.ALERT_ONLY;
    private long timeoutSeconds;
    private Map<String, Object> variables = new HashMap<String, Object>();
    private Map<String, Object> inputTemplate = new HashMap<String, Object>();
    private String workflowStatusListenerSink;
    private RateLimitConfig rateLimitConfig;
    private SchemaDef inputSchema;
    private SchemaDef outputSchema;
    private boolean enforceSchema = true;

    public boolean isEnforceSchema() {
        return this.enforceSchema;
    }

    public void setEnforceSchema(boolean enforceSchema) {
        this.enforceSchema = enforceSchema;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public List<WorkflowTask> getTasks() {
        return this.tasks;
    }

    public void setTasks(List<WorkflowTask> tasks) {
        this.tasks = tasks;
    }

    public List<String> getInputParameters() {
        return this.inputParameters;
    }

    public void setInputParameters(List<String> inputParameters) {
        this.inputParameters = inputParameters;
    }

    public Map<String, Object> getOutputParameters() {
        return this.outputParameters;
    }

    public void setOutputParameters(Map<String, Object> outputParameters) {
        this.outputParameters = outputParameters;
    }

    public int getVersion() {
        return this.version;
    }

    public String getFailureWorkflow() {
        return this.failureWorkflow;
    }

    public void setFailureWorkflow(String failureWorkflow) {
        this.failureWorkflow = failureWorkflow;
    }

    public void setVersion(int version) {
        this.version = version;
    }

    public boolean isRestartable() {
        return this.restartable;
    }

    public void setRestartable(boolean restartable) {
        this.restartable = restartable;
    }

    public int getSchemaVersion() {
        return this.schemaVersion;
    }

    public void setSchemaVersion(int schemaVersion) {
        this.schemaVersion = schemaVersion;
    }

    public boolean isWorkflowStatusListenerEnabled() {
        return this.workflowStatusListenerEnabled;
    }

    public void setWorkflowStatusListenerEnabled(boolean workflowStatusListenerEnabled) {
        this.workflowStatusListenerEnabled = workflowStatusListenerEnabled;
    }

    public String getOwnerEmail() {
        return this.ownerEmail;
    }

    public void setOwnerEmail(String ownerEmail) {
        this.ownerEmail = ownerEmail;
    }

    public TimeoutPolicy getTimeoutPolicy() {
        return this.timeoutPolicy;
    }

    public void setTimeoutPolicy(TimeoutPolicy timeoutPolicy) {
        this.timeoutPolicy = timeoutPolicy;
    }

    public long getTimeoutSeconds() {
        return this.timeoutSeconds;
    }

    public void setTimeoutSeconds(long timeoutSeconds) {
        this.timeoutSeconds = timeoutSeconds;
    }

    public Map<String, Object> getVariables() {
        return this.variables;
    }

    public void setVariables(Map<String, Object> variables) {
        this.variables = variables;
    }

    public Map<String, Object> getInputTemplate() {
        return this.inputTemplate;
    }

    public void setInputTemplate(Map<String, Object> inputTemplate) {
        this.inputTemplate = inputTemplate;
    }

    public String key() {
        return WorkflowDef.getKey(this.name, this.version);
    }

    public static String getKey(String name, int version) {
        return name + "." + version;
    }

    public String getWorkflowStatusListenerSink() {
        return this.workflowStatusListenerSink;
    }

    public void setWorkflowStatusListenerSink(String workflowStatusListenerSink) {
        this.workflowStatusListenerSink = workflowStatusListenerSink;
    }

    public RateLimitConfig getRateLimitConfig() {
        return this.rateLimitConfig;
    }

    public void setRateLimitConfig(RateLimitConfig rateLimitConfig) {
        this.rateLimitConfig = rateLimitConfig;
    }

    public SchemaDef getInputSchema() {
        return this.inputSchema;
    }

    public void setInputSchema(SchemaDef inputSchema) {
        this.inputSchema = inputSchema;
    }

    public SchemaDef getOutputSchema() {
        return this.outputSchema;
    }

    public void setOutputSchema(SchemaDef outputSchema) {
        this.outputSchema = outputSchema;
    }

    public boolean containsType(String taskType) {
        return this.collectTasks().stream().anyMatch(t -> t.getType().equals(taskType));
    }

    public WorkflowTask getNextTask(String taskReferenceName) {
        WorkflowTask task;
        WorkflowTask workflowTask = this.getTaskByRefName(taskReferenceName);
        if (workflowTask != null && TaskType.TERMINATE.name().equals(workflowTask.getType())) {
            return null;
        }
        Iterator<WorkflowTask> iterator = this.tasks.iterator();
        while (iterator.hasNext() && !(task = iterator.next()).getTaskReferenceName().equals(taskReferenceName)) {
            WorkflowTask nextTask = task.next(taskReferenceName, null);
            if (nextTask != null) {
                return nextTask;
            }
            if (TaskType.DO_WHILE.name().equals(task.getType()) && !task.getTaskReferenceName().equals(taskReferenceName) && task.has(taskReferenceName)) {
                return null;
            }
            if (!task.has(taskReferenceName)) continue;
            break;
        }
        if (iterator.hasNext()) {
            return iterator.next();
        }
        return null;
    }

    public WorkflowTask getTaskByRefName(String taskReferenceName) {
        return this.collectTasks().stream().filter(workflowTask -> workflowTask.getTaskReferenceName().equals(taskReferenceName)).findFirst().orElse(null);
    }

    public List<WorkflowTask> collectTasks() {
        LinkedList<WorkflowTask> tasks = new LinkedList<WorkflowTask>();
        for (WorkflowTask workflowTask : this.tasks) {
            tasks.addAll(workflowTask.collectTasks());
        }
        return tasks;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WorkflowDef that = (WorkflowDef)o;
        return this.version == that.version && Objects.equals(this.name, that.name);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.version);
    }

    public String toString() {
        return "WorkflowDef{name='" + this.name + "', description='" + this.description + "', version=" + this.version + ", tasks=" + String.valueOf(this.tasks) + ", inputParameters=" + String.valueOf(this.inputParameters) + ", outputParameters=" + String.valueOf(this.outputParameters) + ", failureWorkflow='" + this.failureWorkflow + "', schemaVersion=" + this.schemaVersion + ", restartable=" + this.restartable + ", workflowStatusListenerEnabled=" + this.workflowStatusListenerEnabled + ", ownerEmail='" + this.ownerEmail + "', timeoutPolicy=" + String.valueOf((Object)this.timeoutPolicy) + ", timeoutSeconds=" + this.timeoutSeconds + ", variables=" + String.valueOf(this.variables) + ", inputTemplate=" + String.valueOf(this.inputTemplate) + ", workflowStatusListenerSink='" + this.workflowStatusListenerSink + "', rateLimitConfig=" + String.valueOf(this.rateLimitConfig) + ", inputSchema=" + String.valueOf(this.inputSchema) + ", outputSchema=" + String.valueOf(this.outputSchema) + ", enforceSchema=" + this.enforceSchema + "}";
    }

    public static enum TimeoutPolicy {
        TIME_OUT_WF,
        ALERT_ONLY;

    }
}

