/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.conductor.common.utils;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.netflix.conductor.common.config.ObjectMapperProvider;
import com.netflix.conductor.common.metadata.workflow.WorkflowDef;

public class TaskUtils {
    private static final ObjectMapper objectMapper;
    private static final String LOOP_TASK_DELIMITER = "__";

    public static String appendIteration(String name, int iteration) {
        return name + LOOP_TASK_DELIMITER + iteration;
    }

    public static String getLoopOverTaskRefNameSuffix(int iteration) {
        return LOOP_TASK_DELIMITER + iteration;
    }

    public static String removeIterationFromTaskRefName(String referenceTaskName) {
        String[] tokens = referenceTaskName.split(LOOP_TASK_DELIMITER);
        return tokens.length > 0 ? tokens[0] : referenceTaskName;
    }

    public static WorkflowDef convertToWorkflowDef(Object workflowDef) {
        return (WorkflowDef)objectMapper.convertValue(workflowDef, (TypeReference)new TypeReference<WorkflowDef>(){});
    }

    static {
        ObjectMapperProvider provider = new ObjectMapperProvider();
        objectMapper = provider.getObjectMapper();
    }
}

