/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.beans.factory.aot;

import java.util.Arrays;
import org.springframework.core.ResolvableType;
import org.springframework.javapoet.CodeBlock;
import org.springframework.util.ClassUtils;

final class ResolvableTypeCodeGenerator {
    private ResolvableTypeCodeGenerator() {
    }

    public static CodeBlock generateCode(ResolvableType resolvableType) {
        return ResolvableTypeCodeGenerator.generateCode(resolvableType, false);
    }

    private static CodeBlock generateCode(ResolvableType resolvableType, boolean allowClassResult) {
        if (ResolvableType.NONE.equals(resolvableType)) {
            return CodeBlock.of("$T.NONE", ResolvableType.class);
        }
        Class<?> type = ClassUtils.getUserClass(resolvableType.toClass());
        if (resolvableType.hasGenerics() && !resolvableType.hasUnresolvableGenerics()) {
            return ResolvableTypeCodeGenerator.generateCodeWithGenerics(resolvableType, type);
        }
        if (allowClassResult) {
            return CodeBlock.of("$T.class", type);
        }
        return CodeBlock.of("$T.forClass($T.class)", ResolvableType.class, type);
    }

    private static CodeBlock generateCodeWithGenerics(ResolvableType target, Class<?> type) {
        ResolvableType[] generics = target.getGenerics();
        boolean hasNoNestedGenerics = Arrays.stream(generics).noneMatch(ResolvableType::hasGenerics);
        CodeBlock.Builder code = CodeBlock.builder();
        code.add("$T.forClassWithGenerics($T.class", ResolvableType.class, type);
        for (ResolvableType generic : generics) {
            code.add(", $L", ResolvableTypeCodeGenerator.generateCode(generic, hasNoNestedGenerics));
        }
        code.add(")", new Object[0]);
        return code.build();
    }
}

