/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.conductor.es7.dao.query.parser;

import com.netflix.conductor.es7.dao.query.parser.FilterProvider;
import com.netflix.conductor.es7.dao.query.parser.internal.AbstractNode;
import com.netflix.conductor.es7.dao.query.parser.internal.ComparisonOp;
import com.netflix.conductor.es7.dao.query.parser.internal.ConstValue;
import com.netflix.conductor.es7.dao.query.parser.internal.ListConst;
import com.netflix.conductor.es7.dao.query.parser.internal.Name;
import com.netflix.conductor.es7.dao.query.parser.internal.ParserException;
import com.netflix.conductor.es7.dao.query.parser.internal.Range;
import java.io.InputStream;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;

public class NameValue
extends AbstractNode
implements FilterProvider {
    private Name name;
    private ComparisonOp op;
    private ConstValue value;
    private Range range;
    private ListConst valueList;

    public NameValue(InputStream is) throws ParserException {
        super(is);
    }

    @Override
    protected void _parse() throws Exception {
        this.name = new Name(this.is);
        this.op = new ComparisonOp(this.is);
        if (this.op.getOperator().equals(ComparisonOp.Operators.BETWEEN.value())) {
            this.range = new Range(this.is);
        }
        if (this.op.getOperator().equals(ComparisonOp.Operators.IN.value())) {
            this.valueList = new ListConst(this.is);
        } else {
            this.value = new ConstValue(this.is);
        }
    }

    public String toString() {
        return String.valueOf(this.name) + String.valueOf(this.op) + String.valueOf(this.value);
    }

    public Name getName() {
        return this.name;
    }

    public ComparisonOp getOp() {
        return this.op;
    }

    public ConstValue getValue() {
        return this.value;
    }

    @Override
    public QueryBuilder getFilterBuilder() {
        if (this.op.getOperator().equals(ComparisonOp.Operators.EQUALS.value())) {
            return QueryBuilders.queryStringQuery((String)(this.name.getName() + ":" + this.value.getValue().toString()));
        }
        if (this.op.getOperator().equals(ComparisonOp.Operators.BETWEEN.value())) {
            return QueryBuilders.rangeQuery((String)this.name.getName()).from((Object)this.range.getLow()).to((Object)this.range.getHigh());
        }
        if (this.op.getOperator().equals(ComparisonOp.Operators.IN.value())) {
            return QueryBuilders.termsQuery((String)this.name.getName(), this.valueList.getList());
        }
        if (this.op.getOperator().equals(ComparisonOp.Operators.NOT_EQUALS.value())) {
            return QueryBuilders.queryStringQuery((String)("NOT " + this.name.getName() + ":" + this.value.getValue().toString()));
        }
        if (this.op.getOperator().equals(ComparisonOp.Operators.GREATER_THAN.value())) {
            return QueryBuilders.rangeQuery((String)this.name.getName()).from(this.value.getValue()).includeLower(false).includeUpper(false);
        }
        if (this.op.getOperator().equals(ComparisonOp.Operators.IS.value())) {
            if (this.value.getSysConstant().equals((Object)ConstValue.SystemConsts.NULL)) {
                return QueryBuilders.boolQuery().mustNot((QueryBuilder)QueryBuilders.boolQuery().must((QueryBuilder)QueryBuilders.matchAllQuery()).mustNot((QueryBuilder)QueryBuilders.existsQuery((String)this.name.getName())));
            }
            if (this.value.getSysConstant().equals((Object)ConstValue.SystemConsts.NOT_NULL)) {
                return QueryBuilders.boolQuery().mustNot((QueryBuilder)QueryBuilders.boolQuery().must((QueryBuilder)QueryBuilders.matchAllQuery()).must((QueryBuilder)QueryBuilders.existsQuery((String)this.name.getName())));
            }
        } else {
            if (this.op.getOperator().equals(ComparisonOp.Operators.LESS_THAN.value())) {
                return QueryBuilders.rangeQuery((String)this.name.getName()).to(this.value.getValue()).includeLower(false).includeUpper(false);
            }
            if (this.op.getOperator().equals(ComparisonOp.Operators.STARTS_WITH.value())) {
                return QueryBuilders.prefixQuery((String)this.name.getName(), (String)this.value.getUnquotedValue());
            }
        }
        throw new IllegalStateException("Incorrect/unsupported operators");
    }
}

