/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.conductor.tasks.http.providers;

import com.netflix.conductor.tasks.http.HttpTask;
import com.netflix.conductor.tasks.http.providers.RestTemplateProvider;
import java.time.Duration;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import org.apache.hc.core5.http.io.SocketConfig;
import org.apache.hc.core5.util.Timeout;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.web.client.RestTemplateBuilder;
import org.springframework.boot.web.client.RestTemplateCustomizer;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.http.client.HttpComponentsClientHttpRequestFactory;
import org.springframework.lang.NonNull;
import org.springframework.stereotype.Component;
import org.springframework.web.client.RestTemplate;

@Component
public class DefaultRestTemplateProvider
implements RestTemplateProvider {
    private final ThreadLocal<RestTemplateBuilder> threadLocalRestTemplateBuilder = ThreadLocal.withInitial(() -> new RestTemplateBuilder(new RestTemplateCustomizer[0]));
    private final int defaultReadTimeout;
    private final int defaultConnectTimeout;

    @Autowired
    public DefaultRestTemplateProvider(@Value(value="${conductor.tasks.http.readTimeout:150ms}") Duration readTimeout, @Value(value="${conductor.tasks.http.connectTimeout:100ms}") Duration connectTimeout) {
        this.defaultReadTimeout = (int)readTimeout.toMillis();
        this.defaultConnectTimeout = (int)connectTimeout.toMillis();
    }

    @Override
    @NonNull
    public RestTemplate getRestTemplate(@NonNull HttpTask.Input input) {
        Duration timeout = Duration.ofMillis(Optional.ofNullable(input.getReadTimeOut()).orElse(this.defaultReadTimeout).intValue());
        this.threadLocalRestTemplateBuilder.get().setReadTimeout(timeout);
        RestTemplate restTemplate = this.threadLocalRestTemplateBuilder.get().setReadTimeout(timeout).build();
        HttpComponentsClientHttpRequestFactory requestFactory = new HttpComponentsClientHttpRequestFactory();
        SocketConfig.Builder builder = SocketConfig.custom();
        builder.setSoTimeout(Timeout.of((long)Optional.ofNullable(input.getReadTimeOut()).orElse(this.defaultReadTimeout).intValue(), (TimeUnit)TimeUnit.MILLISECONDS));
        requestFactory.setConnectTimeout(Optional.ofNullable(input.getConnectionTimeOut()).orElse(this.defaultConnectTimeout).intValue());
        restTemplate.setRequestFactory((ClientHttpRequestFactory)requestFactory);
        return restTemplate;
    }
}

