/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.conductor.sdk.testing;

import com.google.common.util.concurrent.Uninterruptibles;
import com.netflix.conductor.sdk.healthcheck.HealthCheckClient;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocalServerRunner {
    private static final Logger LOGGER = LoggerFactory.getLogger(LocalServerRunner.class);
    private final HealthCheckClient healthCheck;
    private Process serverProcess;
    private final ScheduledExecutorService healthCheckExecutor = Executors.newSingleThreadScheduledExecutor();
    private final CountDownLatch serverProcessLatch = new CountDownLatch(1);
    private final int port;
    private final String conductorVersion;
    private final String serverURL;
    private static Map<Integer, LocalServerRunner> serverInstances = new HashMap<Integer, LocalServerRunner>();

    public LocalServerRunner(int port, String conductorVersion) {
        this.port = port;
        this.conductorVersion = conductorVersion;
        this.serverURL = "http://localhost:" + port + "/";
        this.healthCheck = new HealthCheckClient(this.serverURL + "health");
    }

    public String getServerAPIUrl() {
        return this.serverURL + "api/";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startLocalServer() {
        Map<Integer, LocalServerRunner> map = serverInstances;
        synchronized (map) {
            if (serverInstances.get(this.port) != null) {
                throw new IllegalStateException("Another server has already been started at port " + this.port);
            }
            serverInstances.put(this.port, this);
        }
        try {
            String downloadURL = "https://repo1.maven.org/maven2/com/netflix/conductor/conductor-server/" + this.conductorVersion + "/conductor-server-" + this.conductorVersion + "-boot.jar";
            String repositoryURL = Optional.ofNullable(System.getProperty("repositoryURL")).orElse(downloadURL);
            LOGGER.info("Running conductor with version {} from repo url {}", (Object)this.conductorVersion, (Object)repositoryURL);
            Runtime.getRuntime().addShutdownHook(new Thread(this::shutdown));
            this.installAndStartServer(repositoryURL, this.port);
            this.healthCheckExecutor.scheduleAtFixedRate(() -> {
                try {
                    boolean isRunning;
                    if (this.serverProcessLatch.getCount() > 0L && (isRunning = this.healthCheck.isServerRunning())) {
                        this.serverProcessLatch.countDown();
                    }
                }
                catch (Exception e) {
                    LOGGER.warn("Caught an exception while polling for server running status {}", (Object)e.getMessage());
                }
            }, 100L, 100L, TimeUnit.MILLISECONDS);
            Uninterruptibles.awaitUninterruptibly((CountDownLatch)this.serverProcessLatch, (long)1L, (TimeUnit)TimeUnit.MINUTES);
            if (this.serverProcessLatch.getCount() > 0L) {
                throw new RuntimeException("Server not healthy");
            }
            this.healthCheckExecutor.shutdownNow();
        }
        catch (IOException e) {
            throw new Error(e);
        }
    }

    public void shutdown() {
        if (this.serverProcess != null) {
            this.serverProcess.destroyForcibly();
            serverInstances.remove(this.port);
        }
    }

    private synchronized void installAndStartServer(String repositoryURL, int localServerPort) throws IOException {
        if (this.serverProcess != null) {
            return;
        }
        String configFile = LocalServerRunner.class.getResource("/test-server.properties").getFile();
        String tempDir = System.getProperty("java.io.tmpdir");
        Path serverFile = Paths.get(tempDir, "conductor-server.jar");
        if (!Files.exists(serverFile, new LinkOption[0])) {
            Files.copy(new URL(repositoryURL).openStream(), serverFile, new CopyOption[0]);
        }
        String command = "java -Dserver.port=" + localServerPort + " -DCONDUCTOR_CONFIG_FILE=" + configFile + " -jar " + serverFile;
        LOGGER.info("Running command {}", (Object)command);
        this.serverProcess = Runtime.getRuntime().exec(command);
        BufferedReader error = new BufferedReader(new InputStreamReader(this.serverProcess.getErrorStream()));
        BufferedReader op = new BufferedReader(new InputStreamReader(this.serverProcess.getInputStream()));
        Executors.newSingleThreadScheduledExecutor().execute(() -> {
            String line = null;
            while (true) {
                try {
                    line = error.readLine();
                    if (line == null) {
                        break;
                    }
                }
                catch (IOException e) {
                    LOGGER.error("Exception reading input stream:", (Throwable)e);
                }
                LOGGER.error("Server error stream - {}", (Object)line);
            }
        });
        Executors.newSingleThreadScheduledExecutor().execute(() -> {
            String line = null;
            while (true) {
                try {
                    line = op.readLine();
                    if (line == null) {
                        break;
                    }
                }
                catch (IOException e) {
                    LOGGER.error("Exception reading input stream:", (Throwable)e);
                }
                LOGGER.trace("Server input stream - {}", (Object)line);
            }
        });
    }
}

