/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.conductor.sdk.testing;

import com.netflix.conductor.client.http.TaskClient;
import com.netflix.conductor.sdk.testing.LocalServerRunner;
import com.netflix.conductor.sdk.workflow.executor.WorkflowExecutor;
import com.netflix.conductor.sdk.workflow.executor.task.AnnotatedWorkerExecutor;

public class WorkflowTestRunner {
    private LocalServerRunner localServerRunner;
    private final AnnotatedWorkerExecutor annotatedWorkerExecutor;
    private final WorkflowExecutor workflowExecutor;

    public WorkflowTestRunner(String serverApiUrl) {
        TaskClient taskClient = new TaskClient();
        taskClient.setRootURI(serverApiUrl);
        this.annotatedWorkerExecutor = new AnnotatedWorkerExecutor(taskClient);
        this.workflowExecutor = new WorkflowExecutor(serverApiUrl);
    }

    public WorkflowTestRunner(int port, String conductorVersion) {
        this.localServerRunner = new LocalServerRunner(port, conductorVersion);
        TaskClient taskClient = new TaskClient();
        taskClient.setRootURI(this.localServerRunner.getServerAPIUrl());
        this.annotatedWorkerExecutor = new AnnotatedWorkerExecutor(taskClient);
        this.workflowExecutor = new WorkflowExecutor(this.localServerRunner.getServerAPIUrl());
    }

    public WorkflowExecutor getWorkflowExecutor() {
        return this.workflowExecutor;
    }

    public void init(String basePackages) {
        if (this.localServerRunner != null) {
            this.localServerRunner.startLocalServer();
        }
        this.annotatedWorkerExecutor.initWorkers(basePackages);
    }

    public void shutdown() {
        this.localServerRunner.shutdown();
        this.annotatedWorkerExecutor.shutdown();
        this.workflowExecutor.shutdown();
    }
}

