/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.conductor.sdk.workflow.def.tasks;

import com.netflix.conductor.common.metadata.tasks.TaskType;
import com.netflix.conductor.common.metadata.workflow.WorkflowTask;
import com.netflix.conductor.sdk.workflow.def.tasks.Join;
import com.netflix.conductor.sdk.workflow.def.tasks.Task;
import com.netflix.conductor.sdk.workflow.def.tasks.TaskRegistry;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class ForkJoin
extends Task<ForkJoin> {
    private Join join;
    private Task[][] forkedTasks;

    public ForkJoin(String taskReferenceName, Task<?>[] ... forkedTasks) {
        super(taskReferenceName, TaskType.FORK_JOIN);
        this.forkedTasks = forkedTasks;
    }

    ForkJoin(WorkflowTask workflowTask) {
        super(workflowTask);
        int size = workflowTask.getForkTasks().size();
        this.forkedTasks = new Task[size][];
        int i = 0;
        for (List forkTasks : workflowTask.getForkTasks()) {
            Task[] tasks = new Task[forkTasks.size()];
            for (int j = 0; j < forkTasks.size(); ++j) {
                Task<?> task;
                WorkflowTask forkWorkflowTask = (WorkflowTask)forkTasks.get(j);
                tasks[j] = task = TaskRegistry.getTask(forkWorkflowTask);
            }
            this.forkedTasks[i++] = tasks;
        }
    }

    public ForkJoin joinOn(String ... joinOn) {
        this.join = new Join(this.getTaskReferenceName() + "_join", joinOn);
        return this;
    }

    @Override
    protected List<WorkflowTask> getChildrenTasks() {
        WorkflowTask fork = this.toWorkflowTask();
        WorkflowTask joinWorkflowTask = null;
        if (this.join != null) {
            List<WorkflowTask> joinTasks = this.join.getWorkflowDefTasks();
            joinWorkflowTask = joinTasks.get(0);
        } else {
            joinWorkflowTask = new WorkflowTask();
            joinWorkflowTask.setWorkflowTaskType(TaskType.JOIN);
            joinWorkflowTask.setTaskReferenceName(this.getTaskReferenceName() + "_join");
            joinWorkflowTask.setName(joinWorkflowTask.getTaskReferenceName());
            joinWorkflowTask.setJoinOn(fork.getJoinOn());
        }
        return Arrays.asList(joinWorkflowTask);
    }

    @Override
    public void updateWorkflowTask(WorkflowTask fork) {
        ArrayList<String> joinOnTaskRefNames = new ArrayList<String>();
        ArrayList forkTasks = new ArrayList();
        for (Task[] forkedTaskList : this.forkedTasks) {
            ArrayList<WorkflowTask> forkedWorkflowTasks = new ArrayList<WorkflowTask>();
            for (Task baseWorkflowTask : forkedTaskList) {
                forkedWorkflowTasks.addAll(baseWorkflowTask.getWorkflowDefTasks());
            }
            forkTasks.add(forkedWorkflowTasks);
            joinOnTaskRefNames.add(((WorkflowTask)forkedWorkflowTasks.get(forkedWorkflowTasks.size() - 1)).getTaskReferenceName());
        }
        if (this.join != null) {
            fork.setJoinOn(List.of(this.join.getJoinOn()));
        } else {
            fork.setJoinOn(joinOnTaskRefNames);
        }
        fork.setForkTasks(forkTasks);
    }

    public Task[][] getForkedTasks() {
        return this.forkedTasks;
    }
}

