/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.conductor.sdk.workflow.def.tasks;

import com.google.common.base.Strings;
import com.netflix.conductor.common.metadata.tasks.TaskType;
import com.netflix.conductor.common.metadata.workflow.WorkflowTask;
import com.netflix.conductor.sdk.workflow.def.ValidationError;
import com.netflix.conductor.sdk.workflow.def.tasks.Task;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import javax.script.Bindings;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Javascript
extends Task<Javascript> {
    private static final Logger LOGGER = LoggerFactory.getLogger(Javascript.class);
    private static final String EXPRESSION_PARAMETER = "expression";
    private static final String EVALUATOR_TYPE_PARAMETER = "evaluatorType";
    private static final String ENGINE = "nashorn";

    public Javascript(String taskReferenceName, String script) {
        super(taskReferenceName, TaskType.INLINE);
        if (Strings.isNullOrEmpty((String)script)) {
            throw new AssertionError((Object)"Null/Empty script");
        }
        super.input(EVALUATOR_TYPE_PARAMETER, "javascript");
        super.input(EXPRESSION_PARAMETER, script);
    }

    public Javascript(String taskReferenceName, InputStream stream) {
        super(taskReferenceName, TaskType.INLINE);
        if (stream == null) {
            throw new AssertionError((Object)"Stream is empty");
        }
        super.input(EVALUATOR_TYPE_PARAMETER, "javascript");
        try {
            String script = new String(stream.readAllBytes());
            super.input(EXPRESSION_PARAMETER, script);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    Javascript(WorkflowTask workflowTask) {
        super(workflowTask);
    }

    public String getExpression() {
        return (String)this.getInput().get(EXPRESSION_PARAMETER);
    }

    public Javascript validate() {
        ScriptEngine scriptEngine = new ScriptEngineManager().getEngineByName("Nashorn");
        if (scriptEngine == null) {
            LOGGER.error("missing nashorn engine.  Ensure you are running supported JVM");
            return this;
        }
        try {
            Bindings bindings = scriptEngine.createBindings();
            bindings.put("$", (Object)new HashMap());
            scriptEngine.eval(this.getExpression(), bindings);
        }
        catch (ScriptException e) {
            String message = e.getMessage();
            throw new ValidationError(message);
        }
        return this;
    }

    public Object test(Map<String, Object> input) {
        ScriptEngine scriptEngine = new ScriptEngineManager().getEngineByName("Nashorn");
        if (scriptEngine == null) {
            LOGGER.error("missing nashorn engine.  Ensure you are running supported JVM");
            return this;
        }
        try {
            Bindings bindings = scriptEngine.createBindings();
            bindings.put("$", (Object)input);
            return scriptEngine.eval(this.getExpression(), bindings);
        }
        catch (ScriptException e) {
            String message = e.getMessage();
            throw new ValidationError(message);
        }
    }
}

