/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.conductor.sdk.workflow.def.tasks;

import com.netflix.conductor.common.metadata.tasks.TaskType;
import com.netflix.conductor.common.metadata.workflow.WorkflowTask;
import com.netflix.conductor.sdk.workflow.def.tasks.Task;
import java.time.Duration;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;

public class Wait
extends Task<Wait> {
    public static final String DURATION_INPUT = "duration";
    public static final String UNTIL_INPUT = "until";
    public static final DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm z");

    public Wait(String taskReferenceName) {
        super(taskReferenceName, TaskType.WAIT);
    }

    public Wait(String taskReferenceName, Duration waitFor) {
        super(taskReferenceName, TaskType.WAIT);
        long seconds = waitFor.getSeconds();
        this.input(DURATION_INPUT, seconds + "s");
    }

    public Wait(String taskReferenceName, ZonedDateTime waitUntil) {
        super(taskReferenceName, TaskType.WAIT);
        String formattedDateTime = waitUntil.format(dateTimeFormatter);
        this.input(UNTIL_INPUT, formattedDateTime);
    }

    Wait(WorkflowTask workflowTask) {
        super(workflowTask);
    }
}

