/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.conductor.sdk.workflow.executor;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.netflix.conductor.client.http.MetadataClient;
import com.netflix.conductor.client.http.TaskClient;
import com.netflix.conductor.client.http.WorkflowClient;
import com.netflix.conductor.common.metadata.tasks.TaskDef;
import com.netflix.conductor.common.metadata.tasks.TaskType;
import com.netflix.conductor.common.metadata.workflow.StartWorkflowRequest;
import com.netflix.conductor.common.metadata.workflow.WorkflowDef;
import com.netflix.conductor.common.run.Workflow;
import com.netflix.conductor.sdk.workflow.def.ConductorWorkflow;
import com.netflix.conductor.sdk.workflow.def.tasks.DoWhile;
import com.netflix.conductor.sdk.workflow.def.tasks.Dynamic;
import com.netflix.conductor.sdk.workflow.def.tasks.DynamicFork;
import com.netflix.conductor.sdk.workflow.def.tasks.Event;
import com.netflix.conductor.sdk.workflow.def.tasks.ForkJoin;
import com.netflix.conductor.sdk.workflow.def.tasks.Http;
import com.netflix.conductor.sdk.workflow.def.tasks.JQ;
import com.netflix.conductor.sdk.workflow.def.tasks.Javascript;
import com.netflix.conductor.sdk.workflow.def.tasks.Join;
import com.netflix.conductor.sdk.workflow.def.tasks.SetVariable;
import com.netflix.conductor.sdk.workflow.def.tasks.SimpleTask;
import com.netflix.conductor.sdk.workflow.def.tasks.SubWorkflow;
import com.netflix.conductor.sdk.workflow.def.tasks.Switch;
import com.netflix.conductor.sdk.workflow.def.tasks.TaskRegistry;
import com.netflix.conductor.sdk.workflow.def.tasks.Terminate;
import com.netflix.conductor.sdk.workflow.def.tasks.Wait;
import com.netflix.conductor.sdk.workflow.executor.task.AnnotatedWorkerExecutor;
import com.netflix.conductor.sdk.workflow.utils.ObjectMapperProvider;
import com.sun.jersey.api.client.ClientHandler;
import com.sun.jersey.api.client.config.ClientConfig;
import com.sun.jersey.api.client.config.DefaultClientConfig;
import com.sun.jersey.api.client.filter.ClientFilter;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WorkflowExecutor {
    private static final Logger LOGGER = LoggerFactory.getLogger(WorkflowExecutor.class);
    private final TypeReference<List<TaskDef>> listOfTaskDefs = new TypeReference<List<TaskDef>>(){};
    private Map<String, CompletableFuture<Workflow>> runningWorkflowFutures = new ConcurrentHashMap<String, CompletableFuture<Workflow>>();
    private final ObjectMapper objectMapper = new ObjectMapperProvider().getObjectMapper();
    private final TaskClient taskClient;
    private final WorkflowClient workflowClient;
    private final MetadataClient metadataClient;
    private final AnnotatedWorkerExecutor annotatedWorkerExecutor;
    private final ScheduledExecutorService scheduledWorkflowMonitor = Executors.newSingleThreadScheduledExecutor();

    public static void initTaskImplementations() {
        TaskRegistry.register(TaskType.DO_WHILE.name(), DoWhile.class);
        TaskRegistry.register(TaskType.DYNAMIC.name(), Dynamic.class);
        TaskRegistry.register(TaskType.FORK_JOIN_DYNAMIC.name(), DynamicFork.class);
        TaskRegistry.register(TaskType.FORK_JOIN.name(), ForkJoin.class);
        TaskRegistry.register(TaskType.HTTP.name(), Http.class);
        TaskRegistry.register(TaskType.INLINE.name(), Javascript.class);
        TaskRegistry.register(TaskType.JOIN.name(), Join.class);
        TaskRegistry.register(TaskType.JSON_JQ_TRANSFORM.name(), JQ.class);
        TaskRegistry.register(TaskType.SET_VARIABLE.name(), SetVariable.class);
        TaskRegistry.register(TaskType.SIMPLE.name(), SimpleTask.class);
        TaskRegistry.register(TaskType.SUB_WORKFLOW.name(), SubWorkflow.class);
        TaskRegistry.register(TaskType.SWITCH.name(), Switch.class);
        TaskRegistry.register(TaskType.TERMINATE.name(), Terminate.class);
        TaskRegistry.register(TaskType.WAIT.name(), Wait.class);
        TaskRegistry.register(TaskType.EVENT.name(), Event.class);
    }

    public WorkflowExecutor(String apiServerURL) {
        this(apiServerURL, 100, new ClientFilter[0]);
    }

    public WorkflowExecutor(String apiServerURL, int pollingInterval, ClientFilter ... clientFilter) {
        this.taskClient = new TaskClient((ClientConfig)new DefaultClientConfig(), (ClientHandler)null, clientFilter);
        this.taskClient.setRootURI(apiServerURL);
        this.workflowClient = new WorkflowClient((ClientConfig)new DefaultClientConfig(), (ClientHandler)null, clientFilter);
        this.workflowClient.setRootURI(apiServerURL);
        this.metadataClient = new MetadataClient((ClientConfig)new DefaultClientConfig(), (ClientHandler)null, clientFilter);
        this.metadataClient.setRootURI(apiServerURL);
        this.annotatedWorkerExecutor = new AnnotatedWorkerExecutor(this.taskClient, pollingInterval);
        this.scheduledWorkflowMonitor.scheduleAtFixedRate(() -> {
            for (Map.Entry<String, CompletableFuture<Workflow>> entry : this.runningWorkflowFutures.entrySet()) {
                String workflowId = entry.getKey();
                CompletableFuture<Workflow> future = entry.getValue();
                Workflow workflow = this.workflowClient.getWorkflow(workflowId, true);
                if (!workflow.getStatus().isTerminal()) continue;
                future.complete(workflow);
                this.runningWorkflowFutures.remove(workflowId);
            }
        }, 100L, 100L, TimeUnit.MILLISECONDS);
    }

    public WorkflowExecutor(TaskClient taskClient, WorkflowClient workflowClient, MetadataClient metadataClient, int pollingInterval) {
        this.taskClient = taskClient;
        this.workflowClient = workflowClient;
        this.metadataClient = metadataClient;
        this.annotatedWorkerExecutor = new AnnotatedWorkerExecutor(taskClient, pollingInterval);
        this.scheduledWorkflowMonitor.scheduleAtFixedRate(() -> {
            for (Map.Entry<String, CompletableFuture<Workflow>> entry : this.runningWorkflowFutures.entrySet()) {
                String workflowId = entry.getKey();
                CompletableFuture<Workflow> future = entry.getValue();
                Workflow workflow = workflowClient.getWorkflow(workflowId, true);
                if (!workflow.getStatus().isTerminal()) continue;
                future.complete(workflow);
                this.runningWorkflowFutures.remove(workflowId);
            }
        }, 100L, 100L, TimeUnit.MILLISECONDS);
    }

    public void initWorkers(String packagesToScan) {
        this.annotatedWorkerExecutor.initWorkers(packagesToScan);
    }

    public CompletableFuture<Workflow> executeWorkflow(String name, Integer version, Object input) {
        CompletableFuture<Workflow> future = new CompletableFuture<Workflow>();
        Map inputMap = (Map)this.objectMapper.convertValue(input, Map.class);
        StartWorkflowRequest request = new StartWorkflowRequest();
        request.setInput(inputMap);
        request.setName(name);
        request.setVersion(version);
        String workflowId = this.workflowClient.startWorkflow(request);
        this.runningWorkflowFutures.put(workflowId, future);
        return future;
    }

    public CompletableFuture<Workflow> executeWorkflow(ConductorWorkflow conductorWorkflow, Object input) {
        CompletableFuture<Workflow> future = new CompletableFuture<Workflow>();
        Map inputMap = (Map)this.objectMapper.convertValue(input, Map.class);
        StartWorkflowRequest request = new StartWorkflowRequest();
        request.setInput(inputMap);
        request.setName(conductorWorkflow.getName());
        request.setVersion(Integer.valueOf(conductorWorkflow.getVersion()));
        request.setWorkflowDef(conductorWorkflow.toWorkflowDef());
        String workflowId = this.workflowClient.startWorkflow(request);
        this.runningWorkflowFutures.put(workflowId, future);
        return future;
    }

    public void loadTaskDefs(String resourcePath) throws IOException {
        InputStream resource = WorkflowExecutor.class.getResourceAsStream(resourcePath);
        if (resource != null) {
            List taskDefs = (List)this.objectMapper.readValue(resource, this.listOfTaskDefs);
            this.loadMetadata(taskDefs);
        }
    }

    public void loadWorkflowDefs(String resourcePath) throws IOException {
        InputStream resource = WorkflowExecutor.class.getResourceAsStream(resourcePath);
        if (resource != null) {
            WorkflowDef workflowDef = (WorkflowDef)this.objectMapper.readValue(resource, WorkflowDef.class);
            this.loadMetadata(workflowDef);
        }
    }

    public void loadMetadata(WorkflowDef workflowDef) {
        this.metadataClient.registerWorkflowDef(workflowDef);
    }

    public void loadMetadata(List<TaskDef> taskDefs) {
        this.metadataClient.registerTaskDefs(taskDefs);
    }

    public void shutdown() {
        this.scheduledWorkflowMonitor.shutdown();
        this.annotatedWorkerExecutor.shutdown();
    }

    public boolean registerWorkflow(WorkflowDef workflowDef, boolean overwrite) {
        try {
            if (overwrite) {
                this.metadataClient.updateWorkflowDefs(Arrays.asList(workflowDef));
            } else {
                this.metadataClient.registerWorkflowDef(workflowDef);
            }
            return true;
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return false;
        }
    }

    public MetadataClient getMetadataClient() {
        return this.metadataClient;
    }

    public TaskClient getTaskClient() {
        return this.taskClient;
    }

    public WorkflowClient getWorkflowClient() {
        return this.workflowClient;
    }

    static {
        WorkflowExecutor.initTaskImplementations();
    }
}

