/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.conductor.sdk.workflow.executor.task;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.netflix.conductor.client.worker.Worker;
import com.netflix.conductor.common.metadata.tasks.TaskResult;
import com.netflix.conductor.common.metadata.workflow.WorkflowTask;
import com.netflix.conductor.sdk.workflow.def.tasks.DynamicForkInput;
import com.netflix.conductor.sdk.workflow.def.tasks.Task;
import com.netflix.conductor.sdk.workflow.executor.task.NonRetryableException;
import com.netflix.conductor.sdk.workflow.executor.task.TaskContext;
import com.netflix.conductor.sdk.workflow.task.InputParam;
import com.netflix.conductor.sdk.workflow.task.OutputParam;
import com.netflix.conductor.sdk.workflow.utils.ObjectMapperProvider;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class AnnotatedWorker
implements Worker {
    private String name;
    private Method workerMethod;
    private Object obj;
    private ObjectMapper om = new ObjectMapperProvider().getObjectMapper();
    private int pollingInterval = 100;
    private Set<TaskResult.Status> failedStatuses = Set.of(TaskResult.Status.FAILED, TaskResult.Status.FAILED_WITH_TERMINAL_ERROR);

    public AnnotatedWorker(String name, Method workerMethod, Object obj) {
        this.name = name;
        this.workerMethod = workerMethod;
        this.obj = obj;
        this.om.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
    }

    public String getTaskDefName() {
        return this.name;
    }

    public TaskResult execute(com.netflix.conductor.common.metadata.tasks.Task task) {
        TaskResult result = null;
        try {
            TaskContext context = TaskContext.set(task);
            Object[] parameters = this.getInvocationParameters(task);
            Object invocationResult = this.workerMethod.invoke(this.obj, parameters);
            result = this.setValue(invocationResult, context.getTaskResult());
            if (!this.failedStatuses.contains(result.getStatus()) && result.getCallbackAfterSeconds() > 0L) {
                result.setStatus(TaskResult.Status.IN_PROGRESS);
            }
        }
        catch (InvocationTargetException invocationTargetException) {
            StackTraceElement stackTraceElement;
            String className;
            if (result == null) {
                result = new TaskResult(task);
            }
            Throwable e = invocationTargetException.getCause();
            e.printStackTrace();
            if (e instanceof NonRetryableException) {
                result.setStatus(TaskResult.Status.FAILED_WITH_TERMINAL_ERROR);
            } else {
                result.setStatus(TaskResult.Status.FAILED);
            }
            result.setReasonForIncompletion(e.getMessage());
            StringBuilder stackTrace = new StringBuilder();
            StackTraceElement[] stackTraceElementArray = e.getStackTrace();
            int n = stackTraceElementArray.length;
            for (int i = 0; i < n && !(className = (stackTraceElement = stackTraceElementArray[i]).getClassName()).startsWith("jdk.") && !className.startsWith(AnnotatedWorker.class.getName()); ++i) {
                stackTrace.append(stackTraceElement);
                stackTrace.append("\n");
            }
            result.log(stackTrace.toString());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return result;
    }

    private Object[] getInvocationParameters(com.netflix.conductor.common.metadata.tasks.Task task) {
        Class<?>[] parameterTypes = this.workerMethod.getParameterTypes();
        Parameter[] parameters = this.workerMethod.getParameters();
        if (parameterTypes.length == 1 && parameterTypes[0].equals(com.netflix.conductor.common.metadata.tasks.Task.class)) {
            return new Object[]{task};
        }
        if (parameterTypes.length == 1 && parameterTypes[0].equals(Map.class)) {
            return new Object[]{task.getInputData()};
        }
        return this.getParameters(task, parameterTypes, parameters);
    }

    private Object[] getParameters(com.netflix.conductor.common.metadata.tasks.Task task, Class<?>[] parameterTypes, Parameter[] parameters) {
        Annotation[][] parameterAnnotations = this.workerMethod.getParameterAnnotations();
        Object[] values = new Object[parameterTypes.length];
        for (int i = 0; i < parameterTypes.length; ++i) {
            Annotation[] paramAnnotation = parameterAnnotations[i];
            if (paramAnnotation != null && paramAnnotation.length > 0) {
                Type type = parameters[i].getParameterizedType();
                Class<?> parameterType = parameterTypes[i];
                values[i] = this.getInputValue(task, parameterType, type, paramAnnotation);
                continue;
            }
            values[i] = this.om.convertValue((Object)task.getInputData(), parameterTypes[i]);
        }
        return values;
    }

    private Object getInputValue(com.netflix.conductor.common.metadata.tasks.Task task, Class<?> parameterType, Type type, Annotation[] paramAnnotation) {
        InputParam ip = AnnotatedWorker.findInputParamAnnotation(paramAnnotation);
        if (ip == null) {
            return this.om.convertValue((Object)task.getInputData(), parameterType);
        }
        String name = ip.value();
        Object value = task.getInputData().get(name);
        if (value == null) {
            return null;
        }
        if (List.class.isAssignableFrom(parameterType)) {
            List list = (List)this.om.convertValue(value, List.class);
            if (type instanceof ParameterizedType) {
                ParameterizedType parameterizedType = (ParameterizedType)type;
                Class typeOfParameter = (Class)parameterizedType.getActualTypeArguments()[0];
                ArrayList<Object> parameterizedList = new ArrayList<Object>();
                for (Object item : list) {
                    parameterizedList.add(this.om.convertValue(item, typeOfParameter));
                }
                return parameterizedList;
            }
            return list;
        }
        return this.om.convertValue(value, parameterType);
    }

    private static InputParam findInputParamAnnotation(Annotation[] paramAnnotation) {
        return Arrays.stream(paramAnnotation).filter(ann -> ann.annotationType().equals(InputParam.class)).findFirst().orElse(null);
    }

    private TaskResult setValue(Object invocationResult, TaskResult result) {
        if (invocationResult == null) {
            result.setStatus(TaskResult.Status.COMPLETED);
            return result;
        }
        OutputParam opAnnotation = this.workerMethod.getAnnotatedReturnType().getAnnotation(OutputParam.class);
        if (opAnnotation != null) {
            String name = opAnnotation.value();
            result.getOutputData().put(name, invocationResult);
            result.setStatus(TaskResult.Status.COMPLETED);
            return result;
        }
        if (invocationResult instanceof TaskResult) {
            return (TaskResult)invocationResult;
        }
        if (invocationResult instanceof Map) {
            Map resultAsMap = (Map)invocationResult;
            result.getOutputData().putAll(resultAsMap);
            result.setStatus(TaskResult.Status.COMPLETED);
            return result;
        }
        if (invocationResult instanceof String || invocationResult instanceof Number || invocationResult instanceof Boolean) {
            result.getOutputData().put("result", invocationResult);
            result.setStatus(TaskResult.Status.COMPLETED);
            return result;
        }
        if (invocationResult instanceof List) {
            List resultAsList = (List)this.om.convertValue(invocationResult, List.class);
            result.getOutputData().put("result", resultAsList);
            result.setStatus(TaskResult.Status.COMPLETED);
            return result;
        }
        if (invocationResult instanceof DynamicForkInput) {
            DynamicForkInput forkInput = (DynamicForkInput)invocationResult;
            List<Task<?>> tasks = forkInput.getTasks();
            ArrayList<WorkflowTask> workflowTasks = new ArrayList<WorkflowTask>();
            for (Task<?> sdkTask : tasks) {
                workflowTasks.addAll(sdkTask.getWorkflowDefTasks());
            }
            result.getOutputData().put("forkedTasks", workflowTasks);
            result.getOutputData().put("forkedTasksInputs", forkInput.getInputs());
            result.setStatus(TaskResult.Status.COMPLETED);
            return result;
        }
        Map resultAsMap = (Map)this.om.convertValue(invocationResult, Map.class);
        result.getOutputData().putAll(resultAsMap);
        result.setStatus(TaskResult.Status.COMPLETED);
        return result;
    }

    public void setPollingInterval(int pollingInterval) {
        System.out.println("Setting the polling interval for " + this.getTaskDefName() + ", to " + pollingInterval);
        this.pollingInterval = pollingInterval;
    }

    public int getPollingInterval() {
        System.out.println("Sending the polling interval to " + this.pollingInterval);
        return this.pollingInterval;
    }
}

