/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.conductor.sdk.workflow.executor.task;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Strings;
import com.google.common.reflect.ClassPath;
import com.netflix.conductor.client.automator.TaskRunnerConfigurer;
import com.netflix.conductor.client.http.TaskClient;
import com.netflix.conductor.client.worker.Worker;
import com.netflix.conductor.sdk.workflow.executor.task.AnnotatedWorker;
import com.netflix.conductor.sdk.workflow.executor.task.WorkerConfiguration;
import com.netflix.conductor.sdk.workflow.task.WorkerTask;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AnnotatedWorkerExecutor {
    private static final Logger LOGGER = LoggerFactory.getLogger(AnnotatedWorkerExecutor.class);
    private TaskClient taskClient;
    private TaskRunnerConfigurer taskRunner;
    private List<Worker> executors = new ArrayList<Worker>();
    private Map<String, Method> workerExecutors = new HashMap<String, Method>();
    private Map<String, Integer> workerToThreadCount = new HashMap<String, Integer>();
    private Map<String, Integer> workerToPollingInterval = new HashMap<String, Integer>();
    private Map<String, String> workerDomains = new HashMap<String, String>();
    private Map<String, Object> workerClassObjs = new HashMap<String, Object>();
    private static Set<String> scannedPackages = new HashSet<String>();
    private WorkerConfiguration workerConfiguration;

    public AnnotatedWorkerExecutor(TaskClient taskClient) {
        this.taskClient = taskClient;
        this.workerConfiguration = new WorkerConfiguration();
    }

    public AnnotatedWorkerExecutor(TaskClient taskClient, int pollingIntervalInMillis) {
        this.taskClient = taskClient;
        this.workerConfiguration = new WorkerConfiguration(pollingIntervalInMillis);
    }

    public AnnotatedWorkerExecutor(TaskClient taskClient, WorkerConfiguration workerConfiguration) {
        this.taskClient = taskClient;
        this.workerConfiguration = workerConfiguration;
    }

    public synchronized void initWorkers(String basePackage) {
        this.scanWorkers(basePackage);
        this.startPolling();
    }

    public void shutdown() {
        if (this.taskRunner != null) {
            this.taskRunner.shutdown();
        }
    }

    private void scanWorkers(String basePackage) {
        try {
            if (scannedPackages.contains(basePackage)) {
                LOGGER.info("Package {} already scanned and will skip", (Object)basePackage);
                return;
            }
            scannedPackages.add(basePackage);
            ArrayList packagesToScan = new ArrayList();
            if (basePackage != null) {
                String[] packages = basePackage.split(",");
                Collections.addAll(packagesToScan, packages);
            }
            LOGGER.info("packages to scan {}", packagesToScan);
            long s = System.currentTimeMillis();
            ClassPath.from((ClassLoader)AnnotatedWorkerExecutor.class.getClassLoader()).getAllClasses().forEach(classMeta -> {
                String name = classMeta.getName();
                if (!this.includePackage(packagesToScan, name)) {
                    return;
                }
                try {
                    Class clazz = classMeta.load();
                    Object obj = clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
                    this.addBean(obj);
                }
                catch (Throwable t) {
                    LOGGER.trace("Caught exception while loading and scanning class {}", (Object)t.getMessage());
                }
            });
            LOGGER.info("Took {} ms to scan all the classes, loading {} tasks", (Object)(System.currentTimeMillis() - s), (Object)this.workerExecutors.size());
        }
        catch (Exception e) {
            LOGGER.error("Error while scanning for workers: ", (Throwable)e);
        }
    }

    private boolean includePackage(List<String> packagesToScan, String name) {
        for (String scanPkg : packagesToScan) {
            if (!name.startsWith(scanPkg)) continue;
            return true;
        }
        return false;
    }

    public void addBean(Object bean) {
        Class<?> clazz = bean.getClass();
        for (Method method : clazz.getMethods()) {
            WorkerTask annotation = method.getAnnotation(WorkerTask.class);
            if (annotation == null) continue;
            this.addMethod(annotation, method, bean);
        }
    }

    private void addMethod(WorkerTask annotation, Method method, Object bean) {
        String name = annotation.value();
        int threadCount = this.workerConfiguration.getThreadCount(name);
        if (threadCount == 0) {
            threadCount = annotation.threadCount();
        }
        this.workerToThreadCount.put(name, threadCount);
        int pollingInterval = this.workerConfiguration.getPollingInterval(name);
        if (pollingInterval == 0) {
            pollingInterval = annotation.pollingInterval();
        }
        this.workerToPollingInterval.put(name, pollingInterval);
        String domain = this.workerConfiguration.getDomain(name);
        if (Strings.isNullOrEmpty((String)domain)) {
            domain = annotation.domain();
        }
        if (!Strings.isNullOrEmpty((String)domain)) {
            this.workerDomains.put(name, domain);
        }
        this.workerClassObjs.put(name, bean);
        this.workerExecutors.put(name, method);
        LOGGER.info("Adding worker for task {}, method {} with threadCount {} and polling interval set to {} ms", new Object[]{name, method, threadCount, pollingInterval});
    }

    public void startPolling() {
        this.workerExecutors.forEach((taskName, method) -> {
            Object obj = this.workerClassObjs.get(taskName);
            AnnotatedWorker executor = new AnnotatedWorker((String)taskName, (Method)method, obj);
            executor.setPollingInterval(this.workerToPollingInterval.get(taskName));
            this.executors.add(executor);
        });
        if (this.executors.isEmpty()) {
            return;
        }
        LOGGER.info("Starting workers with threadCount {}", this.workerToThreadCount);
        LOGGER.info("Worker domains {}", this.workerDomains);
        this.taskRunner = new TaskRunnerConfigurer.Builder(this.taskClient, this.executors).withTaskThreadCount(this.workerToThreadCount).withTaskToDomain(this.workerDomains).build();
        this.taskRunner.init();
    }

    @VisibleForTesting
    List<Worker> getExecutors() {
        return this.executors;
    }

    @VisibleForTesting
    TaskRunnerConfigurer getTaskRunner() {
        return this.taskRunner;
    }
}

