/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.conductor.sdk.example.shipment;

import com.netflix.conductor.sdk.example.shipment.Order;
import com.netflix.conductor.sdk.example.shipment.User;
import com.netflix.conductor.sdk.workflow.def.tasks.DynamicForkInput;
import com.netflix.conductor.sdk.workflow.def.tasks.SubWorkflow;
import com.netflix.conductor.sdk.workflow.def.tasks.Task;
import com.netflix.conductor.sdk.workflow.task.InputParam;
import com.netflix.conductor.sdk.workflow.task.OutputParam;
import com.netflix.conductor.sdk.workflow.task.WorkerTask;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Random;
import java.util.UUID;

public class ShipmentWorkers {
    @WorkerTask(value="generateDynamicFork", threadCount=3)
    public DynamicForkInput generateDynamicFork(@InputParam(value="orderDetails") List<Order> orderDetails, @InputParam(value="userDetails") User userDetails) {
        DynamicForkInput input = new DynamicForkInput();
        ArrayList tasks = new ArrayList();
        HashMap<String, Object> inputs = new HashMap<String, Object>();
        for (int i = 0; i < orderDetails.size(); ++i) {
            Order detail = orderDetails.get(i);
            String referenceName = "order_flow_sub_" + i;
            tasks.add((Task)((SubWorkflow)new SubWorkflow(referenceName, "order_flow", null).input("orderDetail", (Object)detail)).input("userDetails", (Object)userDetails));
            inputs.put(referenceName, new HashMap());
        }
        input.setInputs(inputs);
        input.setTasks(tasks);
        return input;
    }

    @WorkerTask(value="get_order_details", threadCount=5)
    public List<Order> getOrderDetails(@InputParam(value="orderNo") String orderNo) {
        int lineItemCount = new Random().nextInt(10);
        ArrayList<Order> orderDetails = new ArrayList<Order>();
        for (int i = 0; i < lineItemCount; ++i) {
            Order orderDetail = new Order(orderNo, "sku_" + i, 2, BigDecimal.valueOf(20.5));
            orderDetail.setOrderNumber(UUID.randomUUID().toString());
            orderDetail.setCountryCode(i % 2 == 0 ? "US" : "CA");
            if (i % 3 == 0) {
                orderDetail.setCountryCode("UK");
            }
            if (orderDetail.getCountryCode().equals("US")) {
                orderDetail.setShippingMethod(Order.ShippingMethod.SAME_DAY);
            } else if (orderDetail.getCountryCode().equals("CA")) {
                orderDetail.setShippingMethod(Order.ShippingMethod.NEXT_DAY_AIR);
            } else {
                orderDetail.setShippingMethod(Order.ShippingMethod.GROUND);
            }
            orderDetails.add(orderDetail);
        }
        return orderDetails;
    }

    @WorkerTask(value="get_user_details")
    public User getUserDetails(@InputParam(value="userId") String userId) {
        User user = new User("User Name", userId + "@example.com", "1234 forline street", "mountain view", "95030", "US", "Paypal", "biling_001");
        return user;
    }

    @WorkerTask(value="calculate_tax_and_total")
    public @OutputParam(value="total_amount") BigDecimal calculateTax(@InputParam(value="orderDetail") Order orderDetails) {
        BigDecimal preTaxAmount = orderDetails.getUnitPrice().multiply(new BigDecimal(orderDetails.getQuantity()));
        BigDecimal tax = BigDecimal.valueOf(0.2).multiply(preTaxAmount);
        if (!"US".equals(orderDetails.getCountryCode())) {
            tax = BigDecimal.ZERO;
        }
        return preTaxAmount.add(tax);
    }

    @WorkerTask(value="ground_shipping_label")
    public @OutputParam(value="reference_number") String prepareGroundShipping(@InputParam(value="name") String name, @InputParam(value="address") String address, @InputParam(value="orderNo") String orderNo) {
        return "Ground_" + orderNo;
    }

    @WorkerTask(value="air_shipping_label")
    public @OutputParam(value="reference_number") String prepareAirShipping(@InputParam(value="name") String name, @InputParam(value="address") String address, @InputParam(value="orderNo") String orderNo) {
        return "Air_" + orderNo;
    }

    @WorkerTask(value="same_day_shipping_label")
    public @OutputParam(value="reference_number") String prepareSameDayShipping(@InputParam(value="name") String name, @InputParam(value="address") String address, @InputParam(value="orderNo") String orderNo) {
        return "SameDay_" + orderNo;
    }

    @WorkerTask(value="charge_payment")
    public @OutputParam(value="reference") String chargePayment(@InputParam(value="amount") BigDecimal amount, @InputParam(value="billingId") String billingId, @InputParam(value="billingType") String billingType) {
        return UUID.randomUUID().toString();
    }

    @WorkerTask(value="send_email")
    public void sendEmail(@InputParam(value="name") String name, @InputParam(value="email") String email, @InputParam(value="orderNo") String orderNo) {
    }
}

