/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.conductor.sdk.workflow.utils;

import com.fasterxml.jackson.annotation.JsonIgnore;

public class InputOutputGetter {
    private final String name;
    private final Field field;

    public InputOutputGetter(String name, Field field) {
        this.name = name;
        this.field = field;
    }

    public String get(String key) {
        return "${" + this.name + "." + this.field + "." + key + "}";
    }

    public String getParent() {
        return "${" + this.name + "." + this.field + "}";
    }

    @JsonIgnore
    public Map map(String key) {
        return new Map("${" + this.name + "." + this.field + "." + key);
    }

    @JsonIgnore
    public List list(String key) {
        return new List("${" + this.name + "." + this.field + "." + key);
    }

    public static enum Field {
        input,
        output;

    }

    public static final class Map {
        private final String parent;

        public Map(String parent) {
            this.parent = parent;
        }

        public String get(String key) {
            return this.parent + "." + key + "}";
        }

        public Map map(String key) {
            return new Map(this.parent + "." + key);
        }

        public List list(String key) {
            return new List(this.parent + "." + key);
        }

        public String toString() {
            return this.parent + "}";
        }
    }

    public static final class List {
        private final String parent;

        public List(String parent) {
            this.parent = parent;
        }

        public List list(String key) {
            return new List(this.parent + "." + key);
        }

        public Map map(String key) {
            return new Map(this.parent + "." + key);
        }

        public String get(String key, int index) {
            return this.parent + "." + key + "[" + index + "]}";
        }

        public String get(int index) {
            return this.parent + "[" + index + "]}";
        }

        public String toString() {
            return this.parent + "}";
        }
    }
}

