/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.conductor.redislock.config;

import com.netflix.conductor.redislock.config.RedisLockProperties;
import java.util.concurrent.TimeUnit;
import org.redisson.api.RedissonClient;
import org.redisson.api.redisnode.RedisCluster;
import org.redisson.api.redisnode.RedisNodes;
import org.redisson.api.redisnode.RedisSentinelMasterSlave;
import org.redisson.api.redisnode.RedisSingle;
import org.springframework.boot.actuate.health.Health;
import org.springframework.boot.actuate.health.HealthIndicator;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.stereotype.Component;

@Component
@ConditionalOnProperty(name={"management.health.redis.enabled"}, havingValue="true")
public class RedisHealthIndicator
implements HealthIndicator {
    private final RedissonClient redisClient;
    private final RedisLockProperties redisProperties;

    public RedisHealthIndicator(RedissonClient redisClient, RedisLockProperties redisProperties) {
        this.redisClient = redisClient;
        this.redisProperties = redisProperties;
    }

    public Health health() {
        return this.isHealth() ? Health.up().build() : Health.down().build();
    }

    private boolean isHealth() {
        switch (this.redisProperties.getServerType()) {
            case SINGLE: {
                return ((RedisSingle)this.redisClient.getRedisNodes(RedisNodes.SINGLE)).pingAll(5L, TimeUnit.SECONDS);
            }
            case CLUSTER: {
                return ((RedisCluster)this.redisClient.getRedisNodes(RedisNodes.CLUSTER)).pingAll(5L, TimeUnit.SECONDS);
            }
            case SENTINEL: {
                return ((RedisSentinelMasterSlave)this.redisClient.getRedisNodes(RedisNodes.SENTINEL_MASTER_SLAVE)).pingAll(5L, TimeUnit.SECONDS);
            }
        }
        return false;
    }
}

