/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.conductor.redislock.lock;

import com.netflix.conductor.core.sync.Lock;
import com.netflix.conductor.metrics.Monitors;
import com.netflix.conductor.redislock.config.RedisLockProperties;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;
import org.redisson.Redisson;
import org.redisson.api.RLock;
import org.redisson.api.RedissonClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RedisLock
implements Lock {
    private static final Logger LOGGER = LoggerFactory.getLogger(RedisLock.class);
    private final RedisLockProperties properties;
    private final RedissonClient redisson;
    private static String LOCK_NAMESPACE = "";

    public RedisLock(Redisson redisson, RedisLockProperties properties) {
        this.properties = properties;
        this.redisson = redisson;
        LOCK_NAMESPACE = properties.getNamespace();
    }

    public void acquireLock(String lockId) {
        RLock lock = this.redisson.getLock(this.parseLockId(lockId));
        lock.lock();
    }

    public boolean acquireLock(String lockId, long timeToTry, TimeUnit unit) {
        RLock lock = this.redisson.getLock(this.parseLockId(lockId));
        try {
            return lock.tryLock(timeToTry, unit);
        }
        catch (Exception e) {
            return this.handleAcquireLockFailure(lockId, e);
        }
    }

    public boolean acquireLock(String lockId, long timeToTry, long leaseTime, TimeUnit unit) {
        RLock lock = this.redisson.getLock(this.parseLockId(lockId));
        try {
            return lock.tryLock(timeToTry, leaseTime, unit);
        }
        catch (Exception e) {
            return this.handleAcquireLockFailure(lockId, e);
        }
    }

    public void releaseLock(String lockId) {
        RLock lock = this.redisson.getLock(this.parseLockId(lockId));
        try {
            lock.unlock();
        }
        catch (IllegalMonitorStateException illegalMonitorStateException) {
            // empty catch block
        }
    }

    public void deleteLock(String lockId) {
    }

    private String parseLockId(String lockId) {
        if (StringUtils.isEmpty((CharSequence)lockId)) {
            throw new IllegalArgumentException("lockId cannot be NULL or empty: lockId=" + lockId);
        }
        return LOCK_NAMESPACE + "." + lockId;
    }

    private boolean handleAcquireLockFailure(String lockId, Exception e) {
        LOGGER.error("Failed to acquireLock for lockId: {}", (Object)lockId, (Object)e);
        Monitors.recordAcquireLockFailure((String)e.getClass().getName());
        return this.properties.isIgnoreLockingExceptions();
    }
}

