/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.conductor.redis.config;

import com.netflix.conductor.core.config.ConductorProperties;
import com.netflix.conductor.redis.config.JedisCommandsConfigurer;
import com.netflix.conductor.redis.config.RedisProperties;
import com.netflix.conductor.redis.jedis.JedisSentinel;
import com.netflix.dyno.connectionpool.Host;
import com.netflix.dyno.connectionpool.HostSupplier;
import com.netflix.dyno.connectionpool.TokenMapSupplier;
import java.lang.invoke.CallSite;
import java.util.HashSet;
import java.util.List;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Configuration;
import redis.clients.jedis.JedisPoolAbstract;
import redis.clients.jedis.JedisSentinelPool;
import redis.clients.jedis.commands.JedisCommands;

@Configuration(proxyBeanMethods=false)
@ConditionalOnProperty(name={"conductor.db.type"}, havingValue="redis_sentinel")
public class RedisSentinelConfiguration
extends JedisCommandsConfigurer {
    private static final Logger log = LoggerFactory.getLogger(RedisSentinelConfiguration.class);

    @Override
    protected JedisCommands createJedisCommands(RedisProperties properties, ConductorProperties conductorProperties, HostSupplier hostSupplier, TokenMapSupplier tokenMapSupplier) {
        GenericObjectPoolConfig genericObjectPoolConfig = new GenericObjectPoolConfig();
        genericObjectPoolConfig.setMinIdle(properties.getMinIdleConnections());
        genericObjectPoolConfig.setMaxIdle(properties.getMaxIdleConnections());
        genericObjectPoolConfig.setMaxTotal(properties.getMaxConnectionsPerHost());
        genericObjectPoolConfig.setTestWhileIdle(properties.isTestWhileIdle());
        genericObjectPoolConfig.setMinEvictableIdleTimeMillis(properties.getMinEvictableIdleTimeMillis());
        genericObjectPoolConfig.setTimeBetweenEvictionRunsMillis(properties.getTimeBetweenEvictionRunsMillis());
        genericObjectPoolConfig.setNumTestsPerEvictionRun(properties.getNumTestsPerEvictionRun());
        log.info("Starting conductor server using redis_sentinel and cluster " + properties.getClusterName());
        HashSet<CallSite> sentinels = new HashSet<CallSite>();
        for (Host host : hostSupplier.getHosts()) {
            sentinels.add((CallSite)((Object)(host.getHostName() + ":" + host.getPort())));
        }
        String password = this.getPassword(hostSupplier.getHosts());
        if (properties.getUsername() != null && password != null) {
            return new JedisSentinel((JedisPoolAbstract)new JedisSentinelPool(properties.getClusterName(), sentinels, genericObjectPoolConfig, 2000, 2000, properties.getUsername(), password, properties.getDatabase(), null, 2000, 2000, properties.getUsername(), password, null));
        }
        if (password != null) {
            return new JedisSentinel((JedisPoolAbstract)new JedisSentinelPool(properties.getClusterName(), sentinels, genericObjectPoolConfig, 2000, 2000, password, properties.getDatabase(), null, 2000, 2000, password, null));
        }
        return new JedisSentinel((JedisPoolAbstract)new JedisSentinelPool(properties.getClusterName(), sentinels, genericObjectPoolConfig));
    }

    private String getPassword(List<Host> hosts) {
        return hosts.isEmpty() ? null : hosts.get(0).getPassword();
    }
}

