/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.conductor.redis.dao;

import com.netflix.conductor.core.events.queue.Message;
import com.netflix.conductor.dao.QueueDAO;
import com.netflix.conductor.redis.config.AnyRedisCondition;
import com.netflix.dyno.queues.DynoQueue;
import com.netflix.dyno.queues.redis.RedisQueues;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.springframework.context.annotation.Conditional;
import org.springframework.stereotype.Component;

@Component
@Conditional(value={AnyRedisCondition.class})
public class DynoQueueDAO
implements QueueDAO {
    private final RedisQueues queues;

    public DynoQueueDAO(RedisQueues queues) {
        this.queues = queues;
    }

    public void push(String queueName, String id, long offsetTimeInSecond) {
        this.push(queueName, id, -1, offsetTimeInSecond);
    }

    public void push(String queueName, String id, int priority, long offsetTimeInSecond) {
        com.netflix.dyno.queues.Message msg = new com.netflix.dyno.queues.Message(id, null);
        msg.setTimeout(offsetTimeInSecond, TimeUnit.SECONDS);
        if (priority >= 0 && priority <= 99) {
            msg.setPriority(priority);
        }
        this.queues.get(queueName).push(Collections.singletonList(msg));
    }

    public void push(String queueName, List<Message> messages) {
        List msgs = messages.stream().map(msg -> {
            com.netflix.dyno.queues.Message m = new com.netflix.dyno.queues.Message(msg.getId(), msg.getPayload());
            if (msg.getPriority() > 0) {
                m.setPriority(msg.getPriority());
            }
            return m;
        }).collect(Collectors.toList());
        this.queues.get(queueName).push(msgs);
    }

    public boolean pushIfNotExists(String queueName, String id, long offsetTimeInSecond) {
        return this.pushIfNotExists(queueName, id, -1, offsetTimeInSecond);
    }

    public boolean pushIfNotExists(String queueName, String id, int priority, long offsetTimeInSecond) {
        DynoQueue queue = this.queues.get(queueName);
        if (queue.get(id) != null) {
            return false;
        }
        com.netflix.dyno.queues.Message msg = new com.netflix.dyno.queues.Message(id, null);
        if (priority >= 0 && priority <= 99) {
            msg.setPriority(priority);
        }
        msg.setTimeout(offsetTimeInSecond, TimeUnit.SECONDS);
        queue.push(Collections.singletonList(msg));
        return true;
    }

    public List<String> pop(String queueName, int count, int timeout) {
        List msg = this.queues.get(queueName).pop(count, timeout, TimeUnit.MILLISECONDS);
        return msg.stream().map(com.netflix.dyno.queues.Message::getId).collect(Collectors.toList());
    }

    public List<Message> pollMessages(String queueName, int count, int timeout) {
        List msgs = this.queues.get(queueName).pop(count, timeout, TimeUnit.MILLISECONDS);
        return msgs.stream().map(msg -> new Message(msg.getId(), msg.getPayload(), null, msg.getPriority())).collect(Collectors.toList());
    }

    public void remove(String queueName, String messageId) {
        this.queues.get(queueName).remove(messageId);
    }

    public int getSize(String queueName) {
        return (int)this.queues.get(queueName).size();
    }

    public boolean ack(String queueName, String messageId) {
        return this.queues.get(queueName).ack(messageId);
    }

    public boolean setUnackTimeout(String queueName, String messageId, long timeout) {
        return this.queues.get(queueName).setUnackTimeout(messageId, timeout);
    }

    public void flush(String queueName) {
        DynoQueue queue = this.queues.get(queueName);
        if (queue != null) {
            queue.clear();
        }
    }

    public Map<String, Long> queuesDetail() {
        return this.queues.queues().stream().collect(Collectors.toMap(DynoQueue::getName, DynoQueue::size));
    }

    public Map<String, Map<String, Map<String, Long>>> queuesDetailVerbose() {
        return this.queues.queues().stream().collect(Collectors.toMap(DynoQueue::getName, DynoQueue::shardSizes));
    }

    public void processUnacks(String queueName) {
        this.queues.get(queueName).processUnacks();
    }

    public boolean resetOffsetTime(String queueName, String id) {
        DynoQueue queue = this.queues.get(queueName);
        return queue.setTimeout(id, 0L);
    }

    public boolean containsMessage(String queueName, String messageId) {
        DynoQueue queue = this.queues.get(queueName);
        com.netflix.dyno.queues.Message message = queue.get(messageId);
        return Objects.nonNull(message);
    }
}

