/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.conductor.redis.dao;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Preconditions;
import com.netflix.conductor.common.metadata.events.EventHandler;
import com.netflix.conductor.core.config.ConductorProperties;
import com.netflix.conductor.core.exception.ConflictException;
import com.netflix.conductor.core.exception.NotFoundException;
import com.netflix.conductor.core.exception.TransientException;
import com.netflix.conductor.dao.EventHandlerDAO;
import com.netflix.conductor.redis.config.AnyRedisCondition;
import com.netflix.conductor.redis.config.RedisProperties;
import com.netflix.conductor.redis.dao.BaseDynoDAO;
import com.netflix.conductor.redis.jedis.JedisProxy;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Conditional;
import org.springframework.stereotype.Component;

@Component
@Conditional(value={AnyRedisCondition.class})
public class RedisEventHandlerDAO
extends BaseDynoDAO
implements EventHandlerDAO {
    private static final Logger LOGGER = LoggerFactory.getLogger(RedisEventHandlerDAO.class);
    private static final String EVENT_HANDLERS = "EVENT_HANDLERS";
    private static final String EVENT_HANDLERS_BY_EVENT = "EVENT_HANDLERS_BY_EVENT";

    public RedisEventHandlerDAO(JedisProxy jedisProxy, ObjectMapper objectMapper, ConductorProperties conductorProperties, RedisProperties properties) {
        super(jedisProxy, objectMapper, conductorProperties, properties);
    }

    public void addEventHandler(EventHandler eventHandler) {
        Preconditions.checkNotNull((Object)eventHandler.getName(), (Object)"Missing Name");
        if (this.getEventHandler(eventHandler.getName()) != null) {
            throw new ConflictException("EventHandler with name %s already exists!", new Object[]{eventHandler.getName()});
        }
        this.index(eventHandler);
        this.jedisProxy.hset(this.nsKey(EVENT_HANDLERS), eventHandler.getName(), this.toJson(eventHandler));
        this.recordRedisDaoRequests("addEventHandler");
    }

    public void updateEventHandler(EventHandler eventHandler) {
        Preconditions.checkNotNull((Object)eventHandler.getName(), (Object)"Missing Name");
        EventHandler existing = this.getEventHandler(eventHandler.getName());
        if (existing == null) {
            throw new NotFoundException("EventHandler with name %s not found!", new Object[]{eventHandler.getName()});
        }
        if (!existing.getEvent().equals(eventHandler.getEvent())) {
            this.removeIndex(existing);
        }
        this.index(eventHandler);
        this.jedisProxy.hset(this.nsKey(EVENT_HANDLERS), eventHandler.getName(), this.toJson(eventHandler));
        this.recordRedisDaoRequests("updateEventHandler");
    }

    public void removeEventHandler(String name) {
        EventHandler existing = this.getEventHandler(name);
        if (existing == null) {
            throw new NotFoundException("EventHandler with name %s not found!", new Object[]{name});
        }
        this.jedisProxy.hdel(this.nsKey(EVENT_HANDLERS), name);
        this.recordRedisDaoRequests("removeEventHandler");
        this.removeIndex(existing);
    }

    public List<EventHandler> getAllEventHandlers() {
        Map<String, String> all = this.jedisProxy.hgetAll(this.nsKey(EVENT_HANDLERS));
        LinkedList<EventHandler> handlers = new LinkedList<EventHandler>();
        all.forEach((key, json) -> {
            EventHandler eventHandler = this.readValue((String)json, EventHandler.class);
            handlers.add(eventHandler);
        });
        this.recordRedisDaoRequests("getAllEventHandlers");
        return handlers;
    }

    private void index(EventHandler eventHandler) {
        String event = eventHandler.getEvent();
        String key = this.nsKey(EVENT_HANDLERS_BY_EVENT, event);
        this.jedisProxy.sadd(key, eventHandler.getName());
    }

    private void removeIndex(EventHandler eventHandler) {
        String event = eventHandler.getEvent();
        String key = this.nsKey(EVENT_HANDLERS_BY_EVENT, event);
        this.jedisProxy.srem(key, eventHandler.getName());
    }

    public List<EventHandler> getEventHandlersForEvent(String event, boolean activeOnly) {
        String key = this.nsKey(EVENT_HANDLERS_BY_EVENT, event);
        Set<String> names = this.jedisProxy.smembers(key);
        LinkedList<EventHandler> handlers = new LinkedList<EventHandler>();
        for (String name : names) {
            try {
                EventHandler eventHandler = this.getEventHandler(name);
                this.recordRedisDaoEventRequests("getEventHandler", event);
                if (!eventHandler.getEvent().equals(event) || activeOnly && !eventHandler.isActive()) continue;
                handlers.add(eventHandler);
            }
            catch (NotFoundException nfe) {
                LOGGER.info("No matching event handler found for event: {}", (Object)event);
                throw nfe;
            }
        }
        return handlers;
    }

    private EventHandler getEventHandler(String name) {
        String json;
        EventHandler eventHandler = null;
        try {
            json = this.jedisProxy.hget(this.nsKey(EVENT_HANDLERS), name);
        }
        catch (Exception e) {
            throw new TransientException("Unable to get event handler named " + name, (Throwable)e);
        }
        if (json != null) {
            eventHandler = this.readValue(json, EventHandler.class);
        }
        return eventHandler;
    }
}

