/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.conductor.redis.dao;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.netflix.conductor.common.metadata.tasks.TaskDef;
import com.netflix.conductor.core.config.ConductorProperties;
import com.netflix.conductor.dao.RateLimitingDAO;
import com.netflix.conductor.metrics.Monitors;
import com.netflix.conductor.model.TaskModel;
import com.netflix.conductor.redis.config.AnyRedisCondition;
import com.netflix.conductor.redis.config.RedisProperties;
import com.netflix.conductor.redis.dao.BaseDynoDAO;
import com.netflix.conductor.redis.jedis.JedisProxy;
import java.util.Optional;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Conditional;
import org.springframework.stereotype.Component;

@Component
@Conditional(value={AnyRedisCondition.class})
public class RedisRateLimitingDAO
extends BaseDynoDAO
implements RateLimitingDAO {
    private static final Logger LOGGER = LoggerFactory.getLogger(RedisRateLimitingDAO.class);
    private static final String TASK_RATE_LIMIT_BUCKET = "TASK_RATE_LIMIT_BUCKET";

    public RedisRateLimitingDAO(JedisProxy jedisProxy, ObjectMapper objectMapper, ConductorProperties conductorProperties, RedisProperties properties) {
        super(jedisProxy, objectMapper, conductorProperties, properties);
    }

    public boolean exceedsRateLimitPerFrequency(TaskModel task, TaskDef taskDef) {
        ImmutablePair rateLimitPair = Optional.ofNullable(taskDef).map(definition -> new ImmutablePair((Object)definition.getRateLimitPerFrequency(), (Object)definition.getRateLimitFrequencyInSeconds())).orElse(new ImmutablePair((Object)task.getRateLimitPerFrequency(), (Object)task.getRateLimitFrequencyInSeconds()));
        int rateLimitPerFrequency = (Integer)rateLimitPair.getLeft();
        int rateLimitFrequencyInSeconds = (Integer)rateLimitPair.getRight();
        if (rateLimitPerFrequency <= 0 || rateLimitFrequencyInSeconds <= 0) {
            LOGGER.debug("Rate limit not applied to the Task: {}  either rateLimitPerFrequency: {} or rateLimitFrequencyInSeconds: {} is 0 or less", new Object[]{task, rateLimitPerFrequency, rateLimitFrequencyInSeconds});
            return false;
        }
        LOGGER.debug("Evaluating rate limiting for TaskId: {} with TaskDefinition of: {} with rateLimitPerFrequency: {} and rateLimitFrequencyInSeconds: {}", new Object[]{task.getTaskId(), task.getTaskDefName(), rateLimitPerFrequency, rateLimitFrequencyInSeconds});
        long currentTimeEpochMillis = System.currentTimeMillis();
        long currentTimeEpochMinusRateLimitBucket = currentTimeEpochMillis - (long)rateLimitFrequencyInSeconds * 1000L;
        String key = this.nsKey(TASK_RATE_LIMIT_BUCKET, task.getTaskDefName());
        this.jedisProxy.zremrangeByScore(key, "-inf", String.valueOf(currentTimeEpochMinusRateLimitBucket));
        int currentBucketCount = Math.toIntExact(this.jedisProxy.zcount(key, currentTimeEpochMinusRateLimitBucket, currentTimeEpochMillis));
        if (currentBucketCount < rateLimitPerFrequency) {
            this.jedisProxy.zadd(key, currentTimeEpochMillis, String.valueOf(currentTimeEpochMillis));
            this.jedisProxy.expire(key, rateLimitFrequencyInSeconds);
            LOGGER.info("TaskId: {} with TaskDefinition of: {} has rateLimitPerFrequency: {} and rateLimitFrequencyInSeconds: {} within the rate limit with current count {}", new Object[]{task.getTaskId(), task.getTaskDefName(), rateLimitPerFrequency, rateLimitFrequencyInSeconds, ++currentBucketCount});
            Monitors.recordTaskRateLimited((String)task.getTaskDefName(), (int)rateLimitPerFrequency);
            return false;
        }
        LOGGER.info("TaskId: {} with TaskDefinition of: {} has rateLimitPerFrequency: {} and rateLimitFrequencyInSeconds: {} is out of bounds of rate limit with current count {}", new Object[]{task.getTaskId(), task.getTaskDefName(), rateLimitPerFrequency, rateLimitFrequencyInSeconds, currentBucketCount});
        return true;
    }
}

