/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.conductor.redis.jedis;

import com.netflix.conductor.redis.config.AnyRedisCondition;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Conditional;
import org.springframework.stereotype.Component;
import redis.clients.jedis.ScanParams;
import redis.clients.jedis.ScanResult;
import redis.clients.jedis.Tuple;
import redis.clients.jedis.commands.JedisCommands;
import redis.clients.jedis.params.ZAddParams;

@Component
@Conditional(value={AnyRedisCondition.class})
public class JedisProxy {
    private static final Logger LOGGER = LoggerFactory.getLogger(JedisProxy.class);
    protected JedisCommands jedisCommands;

    public JedisProxy(@Qualifier(value="DefaultJedisCommands") JedisCommands jedisCommands) {
        this.jedisCommands = jedisCommands;
    }

    public Set<String> zrange(String key, long start, long end) {
        return this.jedisCommands.zrange(key, start, end);
    }

    public Set<Tuple> zrangeByScoreWithScores(String key, double maxScore, int count) {
        return this.jedisCommands.zrangeByScoreWithScores(key, 0.0, maxScore, 0, count);
    }

    public Set<String> zrangeByScore(String key, double maxScore, int count) {
        return this.jedisCommands.zrangeByScore(key, 0.0, maxScore, 0, count);
    }

    public Set<String> zrangeByScore(String key, double minScore, double maxScore, int count) {
        return this.jedisCommands.zrangeByScore(key, minScore, maxScore, 0, count);
    }

    public ScanResult<Tuple> zscan(String key, int cursor) {
        return this.jedisCommands.zscan(key, "" + cursor);
    }

    public String get(String key) {
        return this.jedisCommands.get(key);
    }

    public Long zcard(String key) {
        return this.jedisCommands.zcard(key);
    }

    public Long del(String key) {
        return this.jedisCommands.del(key);
    }

    public Long zrem(String key, String member) {
        return this.jedisCommands.zrem(key, new String[]{member});
    }

    public long zremrangeByScore(String key, String start, String end) {
        return this.jedisCommands.zremrangeByScore(key, start, end);
    }

    public long zcount(String key, double min, double max) {
        return this.jedisCommands.zcount(key, min, max);
    }

    public String set(String key, String value) {
        return this.jedisCommands.set(key, value);
    }

    public Long setnx(String key, String value) {
        return this.jedisCommands.setnx(key, value);
    }

    public Long zadd(String key, double score, String member) {
        return this.jedisCommands.zadd(key, score, member);
    }

    public Long zaddnx(String key, double score, String member) {
        ZAddParams params = ZAddParams.zAddParams().nx();
        return this.jedisCommands.zadd(key, score, member, params);
    }

    public Long hset(String key, String field, String value) {
        return this.jedisCommands.hset(key, field, value);
    }

    public Long hsetnx(String key, String field, String value) {
        return this.jedisCommands.hsetnx(key, field, value);
    }

    public Long hlen(String key) {
        return this.jedisCommands.hlen(key);
    }

    public String hget(String key, String field) {
        return this.jedisCommands.hget(key, field);
    }

    public Optional<String> optionalHget(String key, String field) {
        return Optional.ofNullable(this.jedisCommands.hget(key, field));
    }

    public Map<String, String> hscan(String key, int count) {
        HashMap<String, String> m = new HashMap<String, String>();
        int cursor = 0;
        do {
            ScanResult scanResult = this.jedisCommands.hscan(key, "" + cursor);
            cursor = Integer.parseInt(scanResult.getCursor());
            for (Map.Entry r : scanResult.getResult()) {
                m.put((String)r.getKey(), (String)r.getValue());
            }
        } while (m.size() <= count && cursor > 0);
        return m;
    }

    public Map<String, String> hgetAll(String key) {
        HashMap<String, String> m = new HashMap<String, String>();
        int cursor = 0;
        do {
            ScanResult scanResult = this.jedisCommands.hscan(key, "" + cursor);
            cursor = Integer.parseInt(scanResult.getCursor());
            for (Map.Entry r : scanResult.getResult()) {
                m.put((String)r.getKey(), (String)r.getValue());
            }
        } while (cursor > 0);
        return m;
    }

    public List<String> hvals(String key) {
        LOGGER.trace("hvals {}", (Object)key);
        return this.jedisCommands.hvals(key);
    }

    public Set<String> hkeys(String key) {
        LOGGER.trace("hkeys {}", (Object)key);
        HashSet<String> keys = new HashSet<String>();
        int cursor = 0;
        do {
            ScanResult sr = this.jedisCommands.hscan(key, "" + cursor);
            cursor = Integer.parseInt(sr.getCursor());
            List result = sr.getResult();
            for (Map.Entry e : result) {
                keys.add((String)e.getKey());
            }
        } while (cursor > 0);
        return keys;
    }

    public Long hdel(String key, String ... fields) {
        LOGGER.trace("hdel {} {}", (Object)key, (Object)fields[0]);
        return this.jedisCommands.hdel(key, fields);
    }

    public Long expire(String key, int seconds) {
        return this.jedisCommands.expire(key, seconds);
    }

    public Boolean hexists(String key, String field) {
        return this.jedisCommands.hexists(key, field);
    }

    public Long sadd(String key, String value) {
        LOGGER.trace("sadd {} {}", (Object)key, (Object)value);
        return this.jedisCommands.sadd(key, new String[]{value});
    }

    public Long srem(String key, String member) {
        LOGGER.trace("srem {} {}", (Object)key, (Object)member);
        return this.jedisCommands.srem(key, new String[]{member});
    }

    public boolean sismember(String key, String member) {
        return this.jedisCommands.sismember(key, member);
    }

    public Set<String> smembers(String key) {
        LOGGER.trace("smembers {}", (Object)key);
        HashSet<String> r = new HashSet<String>();
        int cursor = 0;
        ScanParams sp = new ScanParams();
        sp.count(Integer.valueOf(50));
        do {
            ScanResult scanResult = this.jedisCommands.sscan(key, "" + cursor, sp);
            cursor = Integer.parseInt(scanResult.getCursor());
            r.addAll(scanResult.getResult());
        } while (cursor > 0);
        return r;
    }

    public Long scard(String key) {
        return this.jedisCommands.scard(key);
    }
}

