/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.conductor.redis.jedis;

import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import redis.clients.jedis.BitPosParams;
import redis.clients.jedis.GeoCoordinate;
import redis.clients.jedis.GeoRadiusResponse;
import redis.clients.jedis.GeoUnit;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPool;
import redis.clients.jedis.ListPosition;
import redis.clients.jedis.ScanParams;
import redis.clients.jedis.ScanResult;
import redis.clients.jedis.SortingParams;
import redis.clients.jedis.StreamConsumersInfo;
import redis.clients.jedis.StreamEntry;
import redis.clients.jedis.StreamEntryID;
import redis.clients.jedis.StreamGroupInfo;
import redis.clients.jedis.StreamInfo;
import redis.clients.jedis.StreamPendingEntry;
import redis.clients.jedis.Tuple;
import redis.clients.jedis.commands.JedisCommands;
import redis.clients.jedis.params.GeoRadiusParam;
import redis.clients.jedis.params.SetParams;
import redis.clients.jedis.params.ZAddParams;
import redis.clients.jedis.params.ZIncrByParams;

public class JedisStandalone
implements JedisCommands {
    private final JedisPool jedisPool;

    public JedisStandalone(JedisPool jedisPool) {
        this.jedisPool = jedisPool;
    }

    private <R> R executeInJedis(Function<Jedis, R> function) {
        try (Jedis jedis = this.jedisPool.getResource();){
            R r = function.apply(jedis);
            return r;
        }
    }

    public String set(String key, String value) {
        return this.executeInJedis(jedis -> jedis.set(key, value));
    }

    public String set(String key, String value, SetParams params) {
        return this.executeInJedis(jedis -> jedis.set(key, value, params));
    }

    public String get(String key) {
        return this.executeInJedis(jedis -> jedis.get(key));
    }

    public Boolean exists(String key) {
        return this.executeInJedis(jedis -> jedis.exists(key));
    }

    public Long persist(String key) {
        return this.executeInJedis(jedis -> jedis.persist(key));
    }

    public String type(String key) {
        return this.executeInJedis(jedis -> jedis.type(key));
    }

    public byte[] dump(String key) {
        return this.executeInJedis(jedis -> jedis.dump(key));
    }

    public String restore(String key, int ttl, byte[] serializedValue) {
        return this.executeInJedis(jedis -> jedis.restore(key, ttl, serializedValue));
    }

    public String restoreReplace(String key, int ttl, byte[] serializedValue) {
        return this.executeInJedis(jedis -> jedis.restoreReplace(key, ttl, serializedValue));
    }

    public Long expire(String key, int seconds) {
        return this.executeInJedis(jedis -> jedis.expire(key, seconds));
    }

    public Long pexpire(String key, long milliseconds) {
        return this.executeInJedis(jedis -> jedis.pexpire(key, milliseconds));
    }

    public Long expireAt(String key, long unixTime) {
        return this.executeInJedis(jedis -> jedis.expireAt(key, unixTime));
    }

    public Long pexpireAt(String key, long millisecondsTimestamp) {
        return this.executeInJedis(jedis -> jedis.pexpireAt(key, millisecondsTimestamp));
    }

    public Long ttl(String key) {
        return this.executeInJedis(jedis -> jedis.ttl(key));
    }

    public Long pttl(String key) {
        return this.executeInJedis(jedis -> jedis.pttl(key));
    }

    public Long touch(String key) {
        return this.executeInJedis(jedis -> jedis.touch(key));
    }

    public Boolean setbit(String key, long offset, boolean value) {
        return this.executeInJedis(jedis -> jedis.setbit(key, offset, value));
    }

    public Boolean setbit(String key, long offset, String value) {
        return this.executeInJedis(jedis -> jedis.setbit(key, offset, value));
    }

    public Boolean getbit(String key, long offset) {
        return this.executeInJedis(jedis -> jedis.getbit(key, offset));
    }

    public Long setrange(String key, long offset, String value) {
        return this.executeInJedis(jedis -> jedis.setrange(key, offset, value));
    }

    public String getrange(String key, long startOffset, long endOffset) {
        return this.executeInJedis(jedis -> jedis.getrange(key, startOffset, endOffset));
    }

    public String getSet(String key, String value) {
        return this.executeInJedis(jedis -> jedis.getSet(key, value));
    }

    public Long setnx(String key, String value) {
        return this.executeInJedis(jedis -> jedis.setnx(key, value));
    }

    public String setex(String key, int seconds, String value) {
        return this.executeInJedis(jedis -> jedis.setex(key, seconds, value));
    }

    public String psetex(String key, long milliseconds, String value) {
        return this.executeInJedis(jedis -> jedis.psetex(key, milliseconds, value));
    }

    public Long decrBy(String key, long decrement) {
        return this.executeInJedis(jedis -> jedis.decrBy(key, decrement));
    }

    public Long decr(String key) {
        return this.executeInJedis(jedis -> jedis.decr(key));
    }

    public Long incrBy(String key, long increment) {
        return this.executeInJedis(jedis -> jedis.incrBy(key, increment));
    }

    public Double incrByFloat(String key, double increment) {
        return this.executeInJedis(jedis -> jedis.incrByFloat(key, increment));
    }

    public Long incr(String key) {
        return this.executeInJedis(jedis -> jedis.incr(key));
    }

    public Long append(String key, String value) {
        return this.executeInJedis(jedis -> jedis.append(key, value));
    }

    public String substr(String key, int start, int end) {
        return this.executeInJedis(jedis -> jedis.substr(key, start, end));
    }

    public Long hset(String key, String field, String value) {
        return this.executeInJedis(jedis -> jedis.hset(key, field, value));
    }

    public Long hset(String key, Map<String, String> hash) {
        return this.executeInJedis(jedis -> jedis.hset(key, hash));
    }

    public String hget(String key, String field) {
        return this.executeInJedis(jedis -> jedis.hget(key, field));
    }

    public Long hsetnx(String key, String field, String value) {
        return this.executeInJedis(jedis -> jedis.hsetnx(key, field, value));
    }

    public String hmset(String key, Map<String, String> hash) {
        return this.executeInJedis(jedis -> jedis.hmset(key, hash));
    }

    public List<String> hmget(String key, String ... fields) {
        return this.executeInJedis(jedis -> jedis.hmget(key, fields));
    }

    public Long hincrBy(String key, String field, long value) {
        return this.executeInJedis(jedis -> jedis.hincrBy(key, field, value));
    }

    public Double hincrByFloat(String key, String field, double value) {
        return this.executeInJedis(jedis -> jedis.hincrByFloat(key, field, value));
    }

    public Boolean hexists(String key, String field) {
        return this.executeInJedis(jedis -> jedis.hexists(key, field));
    }

    public Long hdel(String key, String ... field) {
        return this.executeInJedis(jedis -> jedis.hdel(key, field));
    }

    public Long hlen(String key) {
        return this.executeInJedis(jedis -> jedis.hlen(key));
    }

    public Set<String> hkeys(String key) {
        return this.executeInJedis(jedis -> jedis.hkeys(key));
    }

    public List<String> hvals(String key) {
        return this.executeInJedis(jedis -> jedis.hvals(key));
    }

    public Map<String, String> hgetAll(String key) {
        return this.executeInJedis(jedis -> jedis.hgetAll(key));
    }

    public Long rpush(String key, String ... string) {
        return this.executeInJedis(jedis -> jedis.rpush(key, new String[0]));
    }

    public Long lpush(String key, String ... string) {
        return this.executeInJedis(jedis -> jedis.lpush(key, string));
    }

    public Long llen(String key) {
        return this.executeInJedis(jedis -> jedis.llen(key));
    }

    public List<String> lrange(String key, long start, long stop) {
        return this.executeInJedis(jedis -> jedis.lrange(key, start, stop));
    }

    public String ltrim(String key, long start, long stop) {
        return this.executeInJedis(jedis -> jedis.ltrim(key, start, stop));
    }

    public String lindex(String key, long index) {
        return this.executeInJedis(jedis -> jedis.lindex(key, index));
    }

    public String lset(String key, long index, String value) {
        return this.executeInJedis(jedis -> jedis.lset(key, index, value));
    }

    public Long lrem(String key, long count, String value) {
        return this.executeInJedis(jedis -> jedis.lrem(key, count, value));
    }

    public String lpop(String key) {
        return this.executeInJedis(jedis -> jedis.lpop(key));
    }

    public String rpop(String key) {
        return this.executeInJedis(jedis -> jedis.rpop(key));
    }

    public Long sadd(String key, String ... member) {
        return this.executeInJedis(jedis -> jedis.sadd(key, member));
    }

    public Set<String> smembers(String key) {
        return this.executeInJedis(jedis -> jedis.smembers(key));
    }

    public Long srem(String key, String ... member) {
        return this.executeInJedis(jedis -> jedis.srem(key, member));
    }

    public String spop(String key) {
        return this.executeInJedis(jedis -> jedis.spop(key));
    }

    public Set<String> spop(String key, long count) {
        return this.executeInJedis(jedis -> jedis.spop(key, count));
    }

    public Long scard(String key) {
        return this.executeInJedis(jedis -> jedis.scard(key));
    }

    public Boolean sismember(String key, String member) {
        return this.executeInJedis(jedis -> jedis.sismember(key, member));
    }

    public String srandmember(String key) {
        return this.executeInJedis(jedis -> jedis.srandmember(key));
    }

    public List<String> srandmember(String key, int count) {
        return this.executeInJedis(jedis -> jedis.srandmember(key, count));
    }

    public Long strlen(String key) {
        return this.executeInJedis(jedis -> jedis.strlen(key));
    }

    public Long zadd(String key, double score, String member) {
        return this.executeInJedis(jedis -> jedis.zadd(key, score, member));
    }

    public Long zadd(String key, double score, String member, ZAddParams params) {
        return this.executeInJedis(jedis -> jedis.zadd(key, score, member, params));
    }

    public Long zadd(String key, Map<String, Double> scoreMembers) {
        return this.executeInJedis(jedis -> jedis.zadd(key, scoreMembers));
    }

    public Long zadd(String key, Map<String, Double> scoreMembers, ZAddParams params) {
        return this.executeInJedis(jedis -> jedis.zadd(key, scoreMembers, params));
    }

    public Set<String> zrange(String key, long start, long stop) {
        return this.executeInJedis(jedis -> jedis.zrange(key, start, stop));
    }

    public Long zrem(String key, String ... members) {
        return this.executeInJedis(jedis -> jedis.zrem(key, members));
    }

    public Double zincrby(String key, double increment, String member) {
        return this.executeInJedis(jedis -> jedis.zincrby(key, increment, member));
    }

    public Double zincrby(String key, double increment, String member, ZIncrByParams params) {
        return this.executeInJedis(jedis -> jedis.zincrby(key, increment, member, params));
    }

    public Long zrank(String key, String member) {
        return this.executeInJedis(jedis -> jedis.zrank(key, member));
    }

    public Long zrevrank(String key, String member) {
        return this.executeInJedis(jedis -> jedis.zrevrank(key, member));
    }

    public Set<String> zrevrange(String key, long start, long stop) {
        return this.executeInJedis(jedis -> jedis.zrevrange(key, start, stop));
    }

    public Set<Tuple> zrangeWithScores(String key, long start, long stop) {
        return this.executeInJedis(jedis -> jedis.zrangeWithScores(key, start, stop));
    }

    public Set<Tuple> zrevrangeWithScores(String key, long start, long stop) {
        return this.executeInJedis(jedis -> jedis.zrevrangeWithScores(key, start, stop));
    }

    public Long zcard(String key) {
        return this.executeInJedis(jedis -> jedis.zcard(key));
    }

    public Double zscore(String key, String member) {
        return this.executeInJedis(jedis -> jedis.zscore(key, member));
    }

    public Tuple zpopmax(String key) {
        return this.executeInJedis(jedis -> jedis.zpopmax(key));
    }

    public Set<Tuple> zpopmax(String key, int count) {
        return this.executeInJedis(jedis -> jedis.zpopmax(key, count));
    }

    public Tuple zpopmin(String key) {
        return this.executeInJedis(jedis -> jedis.zpopmin(key));
    }

    public Set<Tuple> zpopmin(String key, int count) {
        return this.executeInJedis(jedis -> jedis.zpopmin(key, count));
    }

    public List<String> sort(String key) {
        return this.executeInJedis(jedis -> jedis.sort(key));
    }

    public List<String> sort(String key, SortingParams sortingParameters) {
        return this.executeInJedis(jedis -> jedis.sort(key, sortingParameters));
    }

    public Long zcount(String key, double min, double max) {
        return this.executeInJedis(jedis -> jedis.zcount(key, min, max));
    }

    public Long zcount(String key, String min, String max) {
        return this.executeInJedis(jedis -> jedis.zcount(key, min, max));
    }

    public Set<String> zrangeByScore(String key, double min, double max) {
        return this.executeInJedis(jedis -> jedis.zrangeByScore(key, min, max));
    }

    public Set<String> zrangeByScore(String key, String min, String max) {
        return this.executeInJedis(jedis -> jedis.zrangeByScore(key, min, max));
    }

    public Set<String> zrevrangeByScore(String key, double max, double min) {
        return this.executeInJedis(jedis -> jedis.zrevrangeByScore(key, max, min));
    }

    public Set<String> zrangeByScore(String key, double min, double max, int offset, int count) {
        return this.executeInJedis(jedis -> jedis.zrangeByScore(key, min, max, offset, count));
    }

    public Set<String> zrevrangeByScore(String key, String max, String min) {
        return this.executeInJedis(jedis -> jedis.zrevrangeByScore(key, max, min));
    }

    public Set<String> zrangeByScore(String key, String min, String max, int offset, int count) {
        return this.executeInJedis(jedis -> jedis.zrangeByScore(key, min, max, offset, count));
    }

    public Set<String> zrevrangeByScore(String key, double max, double min, int offset, int count) {
        return this.executeInJedis(jedis -> jedis.zrevrangeByScore(key, max, min, offset, count));
    }

    public Set<Tuple> zrangeByScoreWithScores(String key, double min, double max) {
        return this.executeInJedis(jedis -> jedis.zrangeByScoreWithScores(key, min, max));
    }

    public Set<Tuple> zrevrangeByScoreWithScores(String key, double max, double min) {
        return this.executeInJedis(jedis -> jedis.zrevrangeByScoreWithScores(key, max, min));
    }

    public Set<Tuple> zrangeByScoreWithScores(String key, double min, double max, int offset, int count) {
        return this.executeInJedis(jedis -> jedis.zrangeByScoreWithScores(key, min, max, offset, count));
    }

    public Set<String> zrevrangeByScore(String key, String max, String min, int offset, int count) {
        return this.executeInJedis(jedis -> jedis.zrevrangeByScore(key, max, min, offset, count));
    }

    public Set<Tuple> zrangeByScoreWithScores(String key, String min, String max) {
        return this.executeInJedis(jedis -> jedis.zrangeByScoreWithScores(key, min, max));
    }

    public Set<Tuple> zrevrangeByScoreWithScores(String key, String max, String min) {
        return this.executeInJedis(jedis -> jedis.zrevrangeByScoreWithScores(key, max, min));
    }

    public Set<Tuple> zrangeByScoreWithScores(String key, String min, String max, int offset, int count) {
        return this.executeInJedis(jedis -> jedis.zrangeByScoreWithScores(key, min, max, offset, count));
    }

    public Set<Tuple> zrevrangeByScoreWithScores(String key, double max, double min, int offset, int count) {
        return this.executeInJedis(jedis -> jedis.zrevrangeByScoreWithScores(key, max, min, offset, count));
    }

    public Set<Tuple> zrevrangeByScoreWithScores(String key, String max, String min, int offset, int count) {
        return this.executeInJedis(jedis -> jedis.zrevrangeByScoreWithScores(key, max, min, offset, count));
    }

    public Long zremrangeByRank(String key, long start, long stop) {
        return this.executeInJedis(jedis -> jedis.zremrangeByRank(key, start, stop));
    }

    public Long zremrangeByScore(String key, double min, double max) {
        return this.executeInJedis(jedis -> jedis.zremrangeByScore(key, min, max));
    }

    public Long zremrangeByScore(String key, String min, String max) {
        return this.executeInJedis(jedis -> jedis.zremrangeByScore(key, min, max));
    }

    public Long zlexcount(String key, String min, String max) {
        return this.executeInJedis(jedis -> jedis.zlexcount(key, min, max));
    }

    public Set<String> zrangeByLex(String key, String min, String max) {
        return this.executeInJedis(jedis -> jedis.zrangeByLex(key, min, max));
    }

    public Set<String> zrangeByLex(String key, String min, String max, int offset, int count) {
        return this.executeInJedis(jedis -> jedis.zrangeByLex(key, min, max, offset, count));
    }

    public Set<String> zrevrangeByLex(String key, String max, String min) {
        return this.executeInJedis(jedis -> jedis.zrevrangeByLex(key, max, min));
    }

    public Set<String> zrevrangeByLex(String key, String max, String min, int offset, int count) {
        return this.executeInJedis(jedis -> jedis.zrevrangeByLex(key, max, min, offset, count));
    }

    public Long zremrangeByLex(String key, String min, String max) {
        return this.executeInJedis(jedis -> jedis.zremrangeByLex(key, min, max));
    }

    public Long linsert(String key, ListPosition where, String pivot, String value) {
        return this.executeInJedis(jedis -> jedis.linsert(key, where, pivot, value));
    }

    public Long lpushx(String key, String ... string) {
        return this.executeInJedis(jedis -> jedis.lpushx(key, string));
    }

    public Long rpushx(String key, String ... string) {
        return this.executeInJedis(jedis -> jedis.rpushx(key, string));
    }

    public List<String> blpop(int timeout, String key) {
        return this.executeInJedis(jedis -> jedis.blpop(timeout, key));
    }

    public List<String> brpop(int timeout, String key) {
        return this.executeInJedis(jedis -> jedis.brpop(timeout, key));
    }

    public Long del(String key) {
        return this.executeInJedis(jedis -> jedis.del(key));
    }

    public Long unlink(String key) {
        return this.executeInJedis(jedis -> jedis.unlink(key));
    }

    public String echo(String string) {
        return this.executeInJedis(jedis -> jedis.echo(string));
    }

    public Long move(String key, int dbIndex) {
        return this.executeInJedis(jedis -> jedis.move(key, dbIndex));
    }

    public Long bitcount(String key) {
        return this.executeInJedis(jedis -> jedis.bitcount(key));
    }

    public Long bitcount(String key, long start, long end) {
        return this.executeInJedis(jedis -> jedis.bitcount(key, start, end));
    }

    public Long bitpos(String key, boolean value) {
        return this.executeInJedis(jedis -> jedis.bitpos(key, value));
    }

    public Long bitpos(String key, boolean value, BitPosParams params) {
        return this.executeInJedis(jedis -> jedis.bitpos(key, value, params));
    }

    public ScanResult<Map.Entry<String, String>> hscan(String key, String cursor) {
        return this.executeInJedis(jedis -> jedis.hscan(key, cursor));
    }

    public ScanResult<Map.Entry<String, String>> hscan(String key, String cursor, ScanParams params) {
        return this.executeInJedis(jedis -> jedis.hscan(key, cursor, params));
    }

    public ScanResult<String> sscan(String key, String cursor) {
        return this.executeInJedis(jedis -> jedis.sscan(key, cursor));
    }

    public ScanResult<Tuple> zscan(String key, String cursor) {
        return this.executeInJedis(jedis -> jedis.zscan(key, cursor));
    }

    public ScanResult<Tuple> zscan(String key, String cursor, ScanParams params) {
        return this.executeInJedis(jedis -> jedis.zscan(key, cursor, params));
    }

    public ScanResult<String> sscan(String key, String cursor, ScanParams params) {
        return this.executeInJedis(jedis -> jedis.sscan(key, cursor, params));
    }

    public Long pfadd(String key, String ... elements) {
        return this.executeInJedis(jedis -> jedis.pfadd(key, elements));
    }

    public long pfcount(String key) {
        return this.executeInJedis(jedis -> jedis.pfcount(key));
    }

    public Long geoadd(String key, double longitude, double latitude, String member) {
        return this.executeInJedis(jedis -> jedis.geoadd(key, longitude, latitude, member));
    }

    public Long geoadd(String key, Map<String, GeoCoordinate> memberCoordinateMap) {
        return this.executeInJedis(jedis -> jedis.geoadd(key, memberCoordinateMap));
    }

    public Double geodist(String key, String member1, String member2) {
        return this.executeInJedis(jedis -> jedis.geodist(key, member1, member2));
    }

    public Double geodist(String key, String member1, String member2, GeoUnit unit) {
        return this.executeInJedis(jedis -> jedis.geodist(key, member1, member2, unit));
    }

    public List<String> geohash(String key, String ... members) {
        return this.executeInJedis(jedis -> jedis.geohash(key, members));
    }

    public List<GeoCoordinate> geopos(String key, String ... members) {
        return this.executeInJedis(jedis -> jedis.geopos(key, members));
    }

    public List<GeoRadiusResponse> georadius(String key, double longitude, double latitude, double radius, GeoUnit unit) {
        return this.executeInJedis(jedis -> jedis.georadius(key, longitude, latitude, radius, unit));
    }

    public List<GeoRadiusResponse> georadiusReadonly(String key, double longitude, double latitude, double radius, GeoUnit unit) {
        return this.executeInJedis(jedis -> jedis.georadiusReadonly(key, longitude, latitude, radius, unit));
    }

    public List<GeoRadiusResponse> georadius(String key, double longitude, double latitude, double radius, GeoUnit unit, GeoRadiusParam param) {
        return this.executeInJedis(jedis -> jedis.georadius(key, longitude, latitude, radius, unit, param));
    }

    public List<GeoRadiusResponse> georadiusReadonly(String key, double longitude, double latitude, double radius, GeoUnit unit, GeoRadiusParam param) {
        return this.executeInJedis(jedis -> jedis.georadiusReadonly(key, longitude, latitude, radius, unit, param));
    }

    public List<GeoRadiusResponse> georadiusByMember(String key, String member, double radius, GeoUnit unit) {
        return this.executeInJedis(jedis -> jedis.georadiusByMember(key, member, radius, unit));
    }

    public List<GeoRadiusResponse> georadiusByMemberReadonly(String key, String member, double radius, GeoUnit unit) {
        return this.executeInJedis(jedis -> jedis.georadiusByMemberReadonly(key, member, radius, unit));
    }

    public List<GeoRadiusResponse> georadiusByMember(String key, String member, double radius, GeoUnit unit, GeoRadiusParam param) {
        return this.executeInJedis(jedis -> jedis.georadiusByMember(key, member, radius, unit, param));
    }

    public List<GeoRadiusResponse> georadiusByMemberReadonly(String key, String member, double radius, GeoUnit unit, GeoRadiusParam param) {
        return this.executeInJedis(jedis -> jedis.georadiusByMemberReadonly(key, member, radius, unit, param));
    }

    public List<Long> bitfield(String key, String ... arguments) {
        return this.executeInJedis(jedis -> jedis.bitfield(key, arguments));
    }

    public List<Long> bitfieldReadonly(String key, String ... arguments) {
        return this.executeInJedis(jedis -> jedis.bitfieldReadonly(key, arguments));
    }

    public Long hstrlen(String key, String field) {
        return this.executeInJedis(jedis -> jedis.hstrlen(key, field));
    }

    public StreamEntryID xadd(String key, StreamEntryID id, Map<String, String> hash) {
        return this.executeInJedis(jedis -> jedis.xadd(key, id, hash));
    }

    public StreamEntryID xadd(String key, StreamEntryID id, Map<String, String> hash, long maxLen, boolean approximateLength) {
        return this.executeInJedis(jedis -> jedis.xadd(key, id, hash, maxLen, approximateLength));
    }

    public Long xlen(String key) {
        return this.executeInJedis(jedis -> jedis.xlen(key));
    }

    public List<StreamEntry> xrange(String key, StreamEntryID start, StreamEntryID end, int count) {
        return this.executeInJedis(jedis -> jedis.xrange(key, start, end, count));
    }

    public List<StreamEntry> xrevrange(String key, StreamEntryID end, StreamEntryID start, int count) {
        return this.executeInJedis(jedis -> jedis.xrevrange(key, end, start, count));
    }

    public long xack(String key, String group, StreamEntryID ... ids) {
        return this.executeInJedis(jedis -> jedis.xack(key, group, ids));
    }

    public String xgroupCreate(String key, String groupname, StreamEntryID id, boolean makeStream) {
        return this.executeInJedis(jedis -> jedis.xgroupCreate(key, groupname, id, makeStream));
    }

    public String xgroupSetID(String key, String groupname, StreamEntryID id) {
        return this.executeInJedis(jedis -> jedis.xgroupSetID(key, groupname, id));
    }

    public long xgroupDestroy(String key, String groupname) {
        return this.executeInJedis(jedis -> jedis.xgroupDestroy(key, groupname));
    }

    public Long xgroupDelConsumer(String key, String groupname, String consumername) {
        return this.executeInJedis(jedis -> jedis.hsetnx(key, groupname, consumername));
    }

    public List<StreamPendingEntry> xpending(String key, String groupname, StreamEntryID start, StreamEntryID end, int count, String consumername) {
        return this.executeInJedis(jedis -> jedis.xpending(key, groupname, start, end, count, consumername));
    }

    public long xdel(String key, StreamEntryID ... ids) {
        return this.executeInJedis(jedis -> jedis.xdel(key, ids));
    }

    public long xtrim(String key, long maxLen, boolean approximate) {
        return this.executeInJedis(jedis -> jedis.xtrim(key, maxLen, approximate));
    }

    public List<StreamEntry> xclaim(String key, String group, String consumername, long minIdleTime, long newIdleTime, int retries, boolean force, StreamEntryID ... ids) {
        return this.executeInJedis(jedis -> jedis.xclaim(key, group, consumername, minIdleTime, newIdleTime, retries, force, ids));
    }

    public StreamInfo xinfoStream(String key) {
        return this.executeInJedis(jedis -> jedis.xinfoStream(key));
    }

    public List<StreamGroupInfo> xinfoGroup(String key) {
        return this.executeInJedis(jedis -> jedis.xinfoGroup(key));
    }

    public List<StreamConsumersInfo> xinfoConsumers(String key, String group) {
        return this.executeInJedis(jedis -> jedis.xinfoConsumers(key, group));
    }
}

