/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.conductor.redis.config;

import com.netflix.conductor.core.config.ConductorProperties;
import com.netflix.conductor.redis.config.JedisCommandsConfigurer;
import com.netflix.conductor.redis.config.RedisProperties;
import com.netflix.conductor.redis.config.RedisSentinelConfiguration;
import com.netflix.conductor.redis.jedis.JedisStandalone;
import com.netflix.dyno.connectionpool.Host;
import com.netflix.dyno.connectionpool.HostSupplier;
import com.netflix.dyno.connectionpool.TokenMapSupplier;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Configuration;
import redis.clients.jedis.JedisPool;
import redis.clients.jedis.JedisPoolConfig;
import redis.clients.jedis.commands.JedisCommands;

@Configuration(proxyBeanMethods=false)
@ConditionalOnProperty(name={"conductor.db.type"}, havingValue="redis_standalone")
public class RedisStandaloneConfiguration
extends JedisCommandsConfigurer {
    private static final Logger log = LoggerFactory.getLogger(RedisSentinelConfiguration.class);

    @Override
    protected JedisCommands createJedisCommands(RedisProperties properties, ConductorProperties conductorProperties, HostSupplier hostSupplier, TokenMapSupplier tokenMapSupplier) {
        JedisPoolConfig config = new JedisPoolConfig();
        config.setMinIdle(2);
        config.setMaxTotal(properties.getMaxConnectionsPerHost());
        log.info("Starting conductor server using redis_standalone.");
        Host host = (Host)hostSupplier.getHosts().get(0);
        return new JedisStandalone(this.getJedisPool(config, host, properties));
    }

    private JedisPool getJedisPool(JedisPoolConfig config, Host host, RedisProperties properties) {
        if (properties.getUsername() != null && host.getPassword() != null) {
            log.info("Connecting to Redis Standalone with AUTH");
            return new JedisPool((GenericObjectPoolConfig)config, host.getHostName(), host.getPort(), 2000, properties.getUsername(), host.getPassword(), properties.getDatabase());
        }
        if (host.getPassword() != null) {
            log.info("Connecting to Redis Standalone with AUTH");
            return new JedisPool((GenericObjectPoolConfig)config, host.getHostName(), host.getPort(), 2000, host.getPassword(), properties.getDatabase());
        }
        return new JedisPool((GenericObjectPoolConfig)config, host.getHostName(), host.getPort());
    }
}

