/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.conductor.redis.dynoqueue;

import com.netflix.conductor.redis.config.RedisProperties;
import com.netflix.dyno.connectionpool.Host;
import com.netflix.dyno.connectionpool.HostBuilder;
import com.netflix.dyno.connectionpool.HostSupplier;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigurationHostSupplier
implements HostSupplier {
    private static final Logger log = LoggerFactory.getLogger(ConfigurationHostSupplier.class);
    private final RedisProperties properties;

    public ConfigurationHostSupplier(RedisProperties properties) {
        this.properties = properties;
    }

    public List<Host> getHosts() {
        return this.parseHostsFromConfig();
    }

    private List<Host> parseHostsFromConfig() {
        String hosts = this.properties.getHosts();
        if (hosts == null) {
            String message = "Missing dynomite/redis hosts. Ensure 'conductor.redis.hosts' has been set in the supplied configuration.";
            log.error(message);
            throw new RuntimeException(message);
        }
        return this.parseHostsFrom(hosts);
    }

    private List<Host> parseHostsFrom(String hostConfig) {
        List<String> hostConfigs = Arrays.asList(hostConfig.split(";"));
        return hostConfigs.stream().map(hc -> {
            String[] hostConfigValues = hc.split(":");
            String host = hostConfigValues[0];
            int port = Integer.parseInt(hostConfigValues[1]);
            String rack = hostConfigValues[2];
            if (hostConfigValues.length >= 4) {
                String password = hostConfigValues[3];
                return new HostBuilder().setHostname(host).setPort(port).setRack(rack).setStatus(Host.Status.Up).setPassword(password).createHost();
            }
            return new HostBuilder().setHostname(host).setPort(port).setRack(rack).setStatus(Host.Status.Up).createHost();
        }).collect(Collectors.toList());
    }
}

