/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.conductor.redis.config;

import com.netflix.conductor.redis.config.RedisProperties;
import com.netflix.conductor.redis.dynoqueue.LocalhostHostSupplier;
import com.netflix.conductor.redis.jedis.JedisMock;
import com.netflix.dyno.connectionpool.HostSupplier;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration(proxyBeanMethods=false)
@ConditionalOnProperty(name={"conductor.db.type"}, havingValue="memory")
public class InMemoryRedisConfiguration {
    @Bean
    public HostSupplier hostSupplier(RedisProperties properties) {
        return new LocalhostHostSupplier(properties);
    }

    @Bean(name={"DefaultJedisCommands", "ReadJedisCommands"})
    public JedisMock jedisMock() {
        return new JedisMock();
    }
}

