/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.conductor.redis.dao;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Preconditions;
import com.netflix.conductor.common.metadata.tasks.PollData;
import com.netflix.conductor.core.config.ConductorProperties;
import com.netflix.conductor.dao.PollDataDAO;
import com.netflix.conductor.redis.config.AnyRedisCondition;
import com.netflix.conductor.redis.config.RedisProperties;
import com.netflix.conductor.redis.dao.BaseDynoDAO;
import com.netflix.conductor.redis.jedis.JedisProxy;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.springframework.context.annotation.Conditional;
import org.springframework.stereotype.Component;

@Component
@Conditional(value={AnyRedisCondition.class})
public class RedisPollDataDAO
extends BaseDynoDAO
implements PollDataDAO {
    private static final String POLL_DATA = "POLL_DATA";

    public RedisPollDataDAO(JedisProxy jedisProxy, ObjectMapper objectMapper, ConductorProperties conductorProperties, RedisProperties properties) {
        super(jedisProxy, objectMapper, conductorProperties, properties);
    }

    public void updateLastPollData(String taskDefName, String domain, String workerId) {
        Preconditions.checkNotNull((Object)taskDefName, (Object)"taskDefName name cannot be null");
        PollData pollData = new PollData(taskDefName, domain, workerId, System.currentTimeMillis());
        String key = this.nsKey(POLL_DATA, pollData.getQueueName());
        String field = domain == null ? "DEFAULT" : domain;
        String payload = this.toJson(pollData);
        this.recordRedisDaoRequests("updatePollData");
        this.recordRedisDaoPayloadSize("updatePollData", payload.length(), "n/a", "n/a");
        this.jedisProxy.hset(key, field, payload);
    }

    public PollData getPollData(String taskDefName, String domain) {
        Preconditions.checkNotNull((Object)taskDefName, (Object)"taskDefName name cannot be null");
        String key = this.nsKey(POLL_DATA, taskDefName);
        String field = domain == null ? "DEFAULT" : domain;
        String pollDataJsonString = this.jedisProxy.hget(key, field);
        this.recordRedisDaoRequests("getPollData");
        this.recordRedisDaoPayloadSize("getPollData", StringUtils.length((CharSequence)pollDataJsonString), "n/a", "n/a");
        PollData pollData = null;
        if (StringUtils.isNotBlank((CharSequence)pollDataJsonString)) {
            pollData = this.readValue(pollDataJsonString, PollData.class);
        }
        return pollData;
    }

    public List<PollData> getPollData(String taskDefName) {
        Preconditions.checkNotNull((Object)taskDefName, (Object)"taskDefName name cannot be null");
        String key = this.nsKey(POLL_DATA, taskDefName);
        Map<String, String> pMapdata = this.jedisProxy.hgetAll(key);
        ArrayList<PollData> pollData = new ArrayList<PollData>();
        if (pMapdata != null) {
            pMapdata.values().forEach(pollDataJsonString -> {
                pollData.add(this.readValue((String)pollDataJsonString, PollData.class));
                this.recordRedisDaoRequests("getPollData");
                this.recordRedisDaoPayloadSize("getPollData", pollDataJsonString.length(), "n/a", "n/a");
            });
        }
        return pollData;
    }
}

