/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.conductor.redis.config;

import com.netflix.conductor.core.config.ConductorProperties;
import com.netflix.dyno.connectionpool.RetryPolicy;
import com.netflix.dyno.connectionpool.impl.RetryNTimes;
import com.netflix.dyno.connectionpool.impl.RunOnce;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.convert.DurationUnit;

@ConfigurationProperties(value="conductor.redis")
public class RedisProperties {
    private final ConductorProperties conductorProperties;
    private String dataCenterRegion = "us-east-1";
    private String availabilityZone = "us-east-1c";
    private String clusterName = "";
    private String hosts = null;
    private String workflowNamespacePrefix = null;
    private String queueNamespacePrefix = null;
    private String keyspaceDomain = null;
    private int maxConnectionsPerHost = 10;
    private Duration maxTimeoutWhenExhausted = Duration.ofMillis(800L);
    private int maxRetryAttempts = 0;
    private int queuesNonQuorumPort = 22122;
    private String queueShardingStrategy = "roundRobin";
    @DurationUnit(value=ChronoUnit.SECONDS)
    private Duration taskDefCacheRefreshInterval = Duration.ofSeconds(60L);
    @DurationUnit(value=ChronoUnit.SECONDS)
    private Duration eventExecutionPersistenceTTL = Duration.ofSeconds(60L);
    private int maxIdleConnections = 8;
    private int minIdleConnections = 5;
    private long minEvictableIdleTimeMillis = 1800000L;
    private long timeBetweenEvictionRunsMillis = -1L;
    private boolean testWhileIdle = false;
    private int numTestsPerEvictionRun = 3;
    private int database = 0;
    private String username = null;

    @Autowired
    public RedisProperties(ConductorProperties conductorProperties) {
        this.conductorProperties = conductorProperties;
    }

    public int getNumTestsPerEvictionRun() {
        return this.numTestsPerEvictionRun;
    }

    public void setNumTestsPerEvictionRun(int numTestsPerEvictionRun) {
        this.numTestsPerEvictionRun = numTestsPerEvictionRun;
    }

    public boolean isTestWhileIdle() {
        return this.testWhileIdle;
    }

    public void setTestWhileIdle(boolean testWhileIdle) {
        this.testWhileIdle = testWhileIdle;
    }

    public long getMinEvictableIdleTimeMillis() {
        return this.minEvictableIdleTimeMillis;
    }

    public void setMinEvictableIdleTimeMillis(long minEvictableIdleTimeMillis) {
        this.minEvictableIdleTimeMillis = minEvictableIdleTimeMillis;
    }

    public long getTimeBetweenEvictionRunsMillis() {
        return this.timeBetweenEvictionRunsMillis;
    }

    public void setTimeBetweenEvictionRunsMillis(long timeBetweenEvictionRunsMillis) {
        this.timeBetweenEvictionRunsMillis = timeBetweenEvictionRunsMillis;
    }

    public int getMinIdleConnections() {
        return this.minIdleConnections;
    }

    public void setMinIdleConnections(int minIdleConnections) {
        this.minIdleConnections = minIdleConnections;
    }

    public int getMaxIdleConnections() {
        return this.maxIdleConnections;
    }

    public void setMaxIdleConnections(int maxIdleConnections) {
        this.maxIdleConnections = maxIdleConnections;
    }

    public String getDataCenterRegion() {
        return this.dataCenterRegion;
    }

    public void setDataCenterRegion(String dataCenterRegion) {
        this.dataCenterRegion = dataCenterRegion;
    }

    public String getAvailabilityZone() {
        return this.availabilityZone;
    }

    public void setAvailabilityZone(String availabilityZone) {
        this.availabilityZone = availabilityZone;
    }

    public String getClusterName() {
        return this.clusterName;
    }

    public void setClusterName(String clusterName) {
        this.clusterName = clusterName;
    }

    public String getHosts() {
        return this.hosts;
    }

    public void setHosts(String hosts) {
        this.hosts = hosts;
    }

    public String getWorkflowNamespacePrefix() {
        return this.workflowNamespacePrefix;
    }

    public void setWorkflowNamespacePrefix(String workflowNamespacePrefix) {
        this.workflowNamespacePrefix = workflowNamespacePrefix;
    }

    public String getQueueNamespacePrefix() {
        return this.queueNamespacePrefix;
    }

    public void setQueueNamespacePrefix(String queueNamespacePrefix) {
        this.queueNamespacePrefix = queueNamespacePrefix;
    }

    public String getKeyspaceDomain() {
        return this.keyspaceDomain;
    }

    public void setKeyspaceDomain(String keyspaceDomain) {
        this.keyspaceDomain = keyspaceDomain;
    }

    public int getMaxConnectionsPerHost() {
        return this.maxConnectionsPerHost;
    }

    public void setMaxConnectionsPerHost(int maxConnectionsPerHost) {
        this.maxConnectionsPerHost = maxConnectionsPerHost;
    }

    public Duration getMaxTimeoutWhenExhausted() {
        return this.maxTimeoutWhenExhausted;
    }

    public void setMaxTimeoutWhenExhausted(Duration maxTimeoutWhenExhausted) {
        this.maxTimeoutWhenExhausted = maxTimeoutWhenExhausted;
    }

    public int getMaxRetryAttempts() {
        return this.maxRetryAttempts;
    }

    public void setMaxRetryAttempts(int maxRetryAttempts) {
        this.maxRetryAttempts = maxRetryAttempts;
    }

    public int getQueuesNonQuorumPort() {
        return this.queuesNonQuorumPort;
    }

    public void setQueuesNonQuorumPort(int queuesNonQuorumPort) {
        this.queuesNonQuorumPort = queuesNonQuorumPort;
    }

    public String getQueueShardingStrategy() {
        return this.queueShardingStrategy;
    }

    public void setQueueShardingStrategy(String queueShardingStrategy) {
        this.queueShardingStrategy = queueShardingStrategy;
    }

    public Duration getTaskDefCacheRefreshInterval() {
        return this.taskDefCacheRefreshInterval;
    }

    public void setTaskDefCacheRefreshInterval(Duration taskDefCacheRefreshInterval) {
        this.taskDefCacheRefreshInterval = taskDefCacheRefreshInterval;
    }

    public Duration getEventExecutionPersistenceTTL() {
        return this.eventExecutionPersistenceTTL;
    }

    public void setEventExecutionPersistenceTTL(Duration eventExecutionPersistenceTTL) {
        this.eventExecutionPersistenceTTL = eventExecutionPersistenceTTL;
    }

    public String getQueuePrefix() {
        String prefix = this.getQueueNamespacePrefix() + "." + this.conductorProperties.getStack();
        if (this.getKeyspaceDomain() != null) {
            prefix = prefix + "." + this.getKeyspaceDomain();
        }
        return prefix;
    }

    public RetryPolicy.RetryPolicyFactory getConnectionRetryPolicy() {
        if (this.getMaxRetryAttempts() == 0) {
            return RunOnce::new;
        }
        return () -> new RetryNTimes(this.maxRetryAttempts, false);
    }

    public int getDatabase() {
        return this.database;
    }

    public void setDatabase(int database) {
        this.database = database;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }
}

