/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.conductor.redis.dao;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.netflix.conductor.core.config.ConductorProperties;
import com.netflix.conductor.metrics.Monitors;
import com.netflix.conductor.redis.config.RedisProperties;
import com.netflix.conductor.redis.jedis.JedisProxy;
import java.io.IOException;
import org.apache.commons.lang3.StringUtils;

public class BaseDynoDAO {
    private static final String NAMESPACE_SEP = ".";
    private static final String DAO_NAME = "redis";
    private final RedisProperties properties;
    private final ConductorProperties conductorProperties;
    protected JedisProxy jedisProxy;
    protected ObjectMapper objectMapper;

    protected BaseDynoDAO(JedisProxy jedisProxy, ObjectMapper objectMapper, ConductorProperties conductorProperties, RedisProperties properties) {
        this.jedisProxy = jedisProxy;
        this.objectMapper = objectMapper;
        this.conductorProperties = conductorProperties;
        this.properties = properties;
    }

    String nsKey(String ... nsValues) {
        String domain;
        String stack;
        String rootNamespace = this.properties.getWorkflowNamespacePrefix();
        StringBuilder namespacedKey = new StringBuilder();
        if (StringUtils.isNotBlank((CharSequence)rootNamespace)) {
            namespacedKey.append(rootNamespace).append(NAMESPACE_SEP);
        }
        if (StringUtils.isNotBlank((CharSequence)(stack = this.conductorProperties.getStack()))) {
            namespacedKey.append(stack).append(NAMESPACE_SEP);
        }
        if (StringUtils.isNotBlank((CharSequence)(domain = this.properties.getKeyspaceDomain()))) {
            namespacedKey.append(domain).append(NAMESPACE_SEP);
        }
        for (String nsValue : nsValues) {
            namespacedKey.append(nsValue).append(NAMESPACE_SEP);
        }
        return StringUtils.removeEnd((String)namespacedKey.toString(), (String)NAMESPACE_SEP);
    }

    public JedisProxy getDyno() {
        return this.jedisProxy;
    }

    String toJson(Object value) {
        try {
            return this.objectMapper.writeValueAsString(value);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }

    <T> T readValue(String json, Class<T> clazz) {
        try {
            return (T)this.objectMapper.readValue(json, clazz);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    void recordRedisDaoRequests(String action) {
        this.recordRedisDaoRequests(action, "n/a", "n/a");
    }

    void recordRedisDaoRequests(String action, String taskType, String workflowType) {
        Monitors.recordDaoRequests((String)DAO_NAME, (String)action, (String)taskType, (String)workflowType);
    }

    void recordRedisDaoEventRequests(String action, String event) {
        Monitors.recordDaoEventRequests((String)DAO_NAME, (String)action, (String)event);
    }

    void recordRedisDaoPayloadSize(String action, int size, String taskType, String workflowType) {
        Monitors.recordDaoPayloadSize((String)DAO_NAME, (String)action, (String)((String)StringUtils.defaultIfBlank((CharSequence)taskType, (CharSequence)"")), (String)((String)StringUtils.defaultIfBlank((CharSequence)workflowType, (CharSequence)"")), (int)size);
    }
}

