/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.conductor.redis.dynoqueue;

import com.netflix.conductor.redis.config.RedisProperties;
import com.netflix.dyno.queues.Message;
import com.netflix.dyno.queues.ShardSupplier;
import com.netflix.dyno.queues.redis.sharding.RoundRobinStrategy;
import com.netflix.dyno.queues.redis.sharding.ShardingStrategy;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RedisQueuesShardingStrategyProvider {
    public static final String LOCAL_ONLY_STRATEGY = "localOnly";
    public static final String ROUND_ROBIN_STRATEGY = "roundRobin";
    private static final Logger LOGGER = LoggerFactory.getLogger(RedisQueuesShardingStrategyProvider.class);
    private final ShardSupplier shardSupplier;
    private final RedisProperties properties;

    public RedisQueuesShardingStrategyProvider(ShardSupplier shardSupplier, RedisProperties properties) {
        this.shardSupplier = shardSupplier;
        this.properties = properties;
    }

    public ShardingStrategy get() {
        String shardingStrat = this.properties.getQueueShardingStrategy();
        if (shardingStrat.equals(LOCAL_ONLY_STRATEGY)) {
            LOGGER.info("Using {} sharding strategy for queues", (Object)LocalOnlyStrategy.class.getSimpleName());
            return new LocalOnlyStrategy(this.shardSupplier);
        }
        LOGGER.info("Using {} sharding strategy for queues", (Object)RoundRobinStrategy.class.getSimpleName());
        return new RoundRobinStrategy();
    }

    public static final class LocalOnlyStrategy
    implements ShardingStrategy {
        private static final Logger LOGGER = LoggerFactory.getLogger(LocalOnlyStrategy.class);
        private final ShardSupplier shardSupplier;

        public LocalOnlyStrategy(ShardSupplier shardSupplier) {
            this.shardSupplier = shardSupplier;
        }

        public String getNextShard(List<String> allShards, Message message) {
            LOGGER.debug("Always using {} shard out of {}", (Object)this.shardSupplier.getCurrentShard(), allShards);
            return this.shardSupplier.getCurrentShard();
        }
    }
}

