/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.conductor.redis.jedis;

import java.util.AbstractMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import redis.clients.jedis.BitPosParams;
import redis.clients.jedis.GeoCoordinate;
import redis.clients.jedis.GeoRadiusResponse;
import redis.clients.jedis.GeoUnit;
import redis.clients.jedis.ListPosition;
import redis.clients.jedis.ScanParams;
import redis.clients.jedis.ScanResult;
import redis.clients.jedis.SortingParams;
import redis.clients.jedis.StreamConsumersInfo;
import redis.clients.jedis.StreamEntry;
import redis.clients.jedis.StreamEntryID;
import redis.clients.jedis.StreamGroupInfo;
import redis.clients.jedis.StreamInfo;
import redis.clients.jedis.StreamPendingEntry;
import redis.clients.jedis.Tuple;
import redis.clients.jedis.commands.JedisCommands;
import redis.clients.jedis.params.GeoRadiusParam;
import redis.clients.jedis.params.SetParams;
import redis.clients.jedis.params.ZAddParams;
import redis.clients.jedis.params.ZIncrByParams;

public class JedisCluster
implements JedisCommands {
    private final redis.clients.jedis.JedisCluster jedisCluster;

    public JedisCluster(redis.clients.jedis.JedisCluster jedisCluster) {
        this.jedisCluster = jedisCluster;
    }

    public String set(String key, String value) {
        return this.jedisCluster.set(key, value);
    }

    public String set(String key, String value, SetParams params) {
        return this.jedisCluster.set(key, value, params);
    }

    public String get(String key) {
        return this.jedisCluster.get(key);
    }

    public Boolean exists(String key) {
        return this.jedisCluster.exists(key);
    }

    public Long persist(String key) {
        return this.jedisCluster.persist(key);
    }

    public String type(String key) {
        return this.jedisCluster.type(key);
    }

    public byte[] dump(String key) {
        return this.jedisCluster.dump(key);
    }

    public String restore(String key, int ttl, byte[] serializedValue) {
        return this.jedisCluster.restore(key, ttl, serializedValue);
    }

    public String restoreReplace(String key, int ttl, byte[] serializedValue) {
        throw new UnsupportedOperationException();
    }

    public Long expire(String key, int seconds) {
        return this.jedisCluster.expire(key, seconds);
    }

    public Long pexpire(String key, long milliseconds) {
        return this.jedisCluster.pexpire(key, milliseconds);
    }

    public Long expireAt(String key, long unixTime) {
        return this.jedisCluster.expireAt(key, unixTime);
    }

    public Long pexpireAt(String key, long millisecondsTimestamp) {
        return this.jedisCluster.pexpireAt(key, millisecondsTimestamp);
    }

    public Long ttl(String key) {
        return this.jedisCluster.ttl(key);
    }

    public Long pttl(String key) {
        return this.jedisCluster.pttl(key);
    }

    public Long touch(String key) {
        return this.jedisCluster.touch(key);
    }

    public Boolean setbit(String key, long offset, boolean value) {
        return this.jedisCluster.setbit(key, offset, value);
    }

    public Boolean setbit(String key, long offset, String value) {
        return this.jedisCluster.setbit(key, offset, value);
    }

    public Boolean getbit(String key, long offset) {
        return this.jedisCluster.getbit(key, offset);
    }

    public Long setrange(String key, long offset, String value) {
        return this.jedisCluster.setrange(key, offset, value);
    }

    public String getrange(String key, long startOffset, long endOffset) {
        return this.jedisCluster.getrange(key, startOffset, endOffset);
    }

    public String getSet(String key, String value) {
        return this.jedisCluster.getSet(key, value);
    }

    public Long setnx(String key, String value) {
        return this.jedisCluster.setnx(key, value);
    }

    public String setex(String key, int seconds, String value) {
        return this.jedisCluster.setex(key, seconds, value);
    }

    public String psetex(String key, long milliseconds, String value) {
        return this.jedisCluster.psetex(key, milliseconds, value);
    }

    public Long decrBy(String key, long integer) {
        return this.jedisCluster.decrBy(key, integer);
    }

    public Long decr(String key) {
        return this.jedisCluster.decr(key);
    }

    public Long incrBy(String key, long integer) {
        return this.jedisCluster.incrBy(key, integer);
    }

    public Double incrByFloat(String key, double value) {
        return this.jedisCluster.incrByFloat(key, value);
    }

    public Long incr(String key) {
        return this.jedisCluster.incr(key);
    }

    public Long append(String key, String value) {
        return this.jedisCluster.append(key, value);
    }

    public String substr(String key, int start, int end) {
        return this.jedisCluster.substr(key, start, end);
    }

    public Long hset(String key, String field, String value) {
        return this.jedisCluster.hset(key, field, value);
    }

    public Long hset(String key, Map<String, String> hash) {
        return this.jedisCluster.hset(key, hash);
    }

    public String hget(String key, String field) {
        return this.jedisCluster.hget(key, field);
    }

    public Long hsetnx(String key, String field, String value) {
        return this.jedisCluster.hsetnx(key, field, value);
    }

    public String hmset(String key, Map<String, String> hash) {
        return this.jedisCluster.hmset(key, hash);
    }

    public List<String> hmget(String key, String ... fields) {
        return this.jedisCluster.hmget(key, fields);
    }

    public Long hincrBy(String key, String field, long value) {
        return this.jedisCluster.hincrBy(key, field, value);
    }

    public Double hincrByFloat(String key, String field, double value) {
        return this.jedisCluster.hincrByFloat(key.getBytes(), field.getBytes(), value);
    }

    public Boolean hexists(String key, String field) {
        return this.jedisCluster.hexists(key, field);
    }

    public Long hdel(String key, String ... field) {
        return this.jedisCluster.hdel(key, field);
    }

    public Long hlen(String key) {
        return this.jedisCluster.hlen(key);
    }

    public Set<String> hkeys(String key) {
        return this.jedisCluster.hkeys(key);
    }

    public List<String> hvals(String key) {
        return this.jedisCluster.hvals(key);
    }

    public Map<String, String> hgetAll(String key) {
        return this.jedisCluster.hgetAll(key);
    }

    public Long rpush(String key, String ... string) {
        return this.jedisCluster.rpush(key, string);
    }

    public Long lpush(String key, String ... string) {
        return this.jedisCluster.lpush(key, string);
    }

    public Long llen(String key) {
        return this.jedisCluster.llen(key);
    }

    public List<String> lrange(String key, long start, long end) {
        return this.jedisCluster.lrange(key, start, end);
    }

    public String ltrim(String key, long start, long end) {
        return this.jedisCluster.ltrim(key, start, end);
    }

    public String lindex(String key, long index) {
        return this.jedisCluster.lindex(key, index);
    }

    public String lset(String key, long index, String value) {
        return this.jedisCluster.lset(key, index, value);
    }

    public Long lrem(String key, long count, String value) {
        return this.jedisCluster.lrem(key, count, value);
    }

    public String lpop(String key) {
        return this.jedisCluster.lpop(key);
    }

    public String rpop(String key) {
        return this.jedisCluster.rpop(key);
    }

    public Long sadd(String key, String ... member) {
        return this.jedisCluster.sadd(key, member);
    }

    public Set<String> smembers(String key) {
        return this.jedisCluster.smembers(key);
    }

    public Long srem(String key, String ... member) {
        return this.jedisCluster.srem(key, member);
    }

    public String spop(String key) {
        return this.jedisCluster.spop(key);
    }

    public Set<String> spop(String key, long count) {
        return this.jedisCluster.spop(key, count);
    }

    public Long scard(String key) {
        return this.jedisCluster.scard(key);
    }

    public Boolean sismember(String key, String member) {
        return this.jedisCluster.sismember(key, member);
    }

    public String srandmember(String key) {
        return this.jedisCluster.srandmember(key);
    }

    public List<String> srandmember(String key, int count) {
        return this.jedisCluster.srandmember(key, count);
    }

    public Long strlen(String key) {
        return this.jedisCluster.strlen(key);
    }

    public Long zadd(String key, double score, String member) {
        return this.jedisCluster.zadd(key, score, member);
    }

    public Long zadd(String key, double score, String member, ZAddParams params) {
        return this.jedisCluster.zadd(key, score, member, params);
    }

    public Long zadd(String key, Map<String, Double> scoreMembers) {
        return this.jedisCluster.zadd(key, scoreMembers);
    }

    public Long zadd(String key, Map<String, Double> scoreMembers, ZAddParams params) {
        return this.jedisCluster.zadd(key, scoreMembers, params);
    }

    public Set<String> zrange(String key, long start, long end) {
        return this.jedisCluster.zrange(key, start, end);
    }

    public Long zrem(String key, String ... member) {
        return this.jedisCluster.zrem(key, member);
    }

    public Double zincrby(String key, double score, String member) {
        return this.jedisCluster.zincrby(key, score, member);
    }

    public Double zincrby(String key, double score, String member, ZIncrByParams params) {
        return this.jedisCluster.zincrby(key, score, member, params);
    }

    public Long zrank(String key, String member) {
        return this.jedisCluster.zrank(key, member);
    }

    public Long zrevrank(String key, String member) {
        return this.jedisCluster.zrevrank(key, member);
    }

    public Set<String> zrevrange(String key, long start, long end) {
        return this.jedisCluster.zrevrange(key, start, end);
    }

    public Set<Tuple> zrangeWithScores(String key, long start, long end) {
        return this.jedisCluster.zrangeWithScores(key, start, end);
    }

    public Set<Tuple> zrevrangeWithScores(String key, long start, long end) {
        return this.jedisCluster.zrevrangeWithScores(key, start, end);
    }

    public Long zcard(String key) {
        return this.jedisCluster.zcard(key);
    }

    public Double zscore(String key, String member) {
        return this.jedisCluster.zscore(key, member);
    }

    public Tuple zpopmax(String key) {
        return this.jedisCluster.zpopmax(key);
    }

    public Set<Tuple> zpopmax(String key, int count) {
        return this.jedisCluster.zpopmax(key, count);
    }

    public Tuple zpopmin(String key) {
        return this.jedisCluster.zpopmin(key);
    }

    public Set<Tuple> zpopmin(String key, int count) {
        return this.jedisCluster.zpopmin(key, count);
    }

    public List<String> sort(String key) {
        return this.jedisCluster.sort(key);
    }

    public List<String> sort(String key, SortingParams sortingParameters) {
        return this.jedisCluster.sort(key, sortingParameters);
    }

    public Long zcount(String key, double min, double max) {
        return this.jedisCluster.zcount(key, min, max);
    }

    public Long zcount(String key, String min, String max) {
        return this.jedisCluster.zcount(key, min, max);
    }

    public Set<String> zrangeByScore(String key, double min, double max) {
        return this.jedisCluster.zrangeByScore(key, min, max);
    }

    public Set<String> zrangeByScore(String key, String min, String max) {
        return this.jedisCluster.zrangeByScore(key, min, max);
    }

    public Set<String> zrevrangeByScore(String key, double max, double min) {
        return this.jedisCluster.zrevrangeByScore(key, max, min);
    }

    public Set<String> zrangeByScore(String key, double min, double max, int offset, int count) {
        return this.jedisCluster.zrangeByScore(key, min, max, offset, count);
    }

    public Set<String> zrevrangeByScore(String key, String max, String min) {
        return this.jedisCluster.zrevrangeByScore(key, max, min);
    }

    public Set<String> zrangeByScore(String key, String min, String max, int offset, int count) {
        return this.jedisCluster.zrangeByScore(key, min, max, offset, count);
    }

    public Set<String> zrevrangeByScore(String key, double max, double min, int offset, int count) {
        return this.jedisCluster.zrevrangeByScore(key, max, min, offset, count);
    }

    public Set<Tuple> zrangeByScoreWithScores(String key, double min, double max) {
        return this.jedisCluster.zrangeByScoreWithScores(key, min, max);
    }

    public Set<Tuple> zrevrangeByScoreWithScores(String key, double max, double min) {
        return this.jedisCluster.zrevrangeByScoreWithScores(key, max, min);
    }

    public Set<Tuple> zrangeByScoreWithScores(String key, double min, double max, int offset, int count) {
        return this.jedisCluster.zrangeByScoreWithScores(key, min, max, offset, count);
    }

    public Set<String> zrevrangeByScore(String key, String max, String min, int offset, int count) {
        return this.jedisCluster.zrevrangeByScore(key, max, min, offset, count);
    }

    public Set<Tuple> zrangeByScoreWithScores(String key, String min, String max) {
        return this.jedisCluster.zrangeByScoreWithScores(key, min, max);
    }

    public Set<Tuple> zrevrangeByScoreWithScores(String key, String max, String min) {
        return this.jedisCluster.zrevrangeByScoreWithScores(key, max, min);
    }

    public Set<Tuple> zrangeByScoreWithScores(String key, String min, String max, int offset, int count) {
        return this.jedisCluster.zrangeByScoreWithScores(key, min, max, offset, count);
    }

    public Set<Tuple> zrevrangeByScoreWithScores(String key, double max, double min, int offset, int count) {
        return this.jedisCluster.zrevrangeByScoreWithScores(key, max, min, offset, count);
    }

    public Set<Tuple> zrevrangeByScoreWithScores(String key, String max, String min, int offset, int count) {
        return this.jedisCluster.zrevrangeByScoreWithScores(key, max, min, offset, count);
    }

    public Long zremrangeByRank(String key, long start, long end) {
        return this.jedisCluster.zremrangeByRank(key, start, end);
    }

    public Long zremrangeByScore(String key, double start, double end) {
        return this.jedisCluster.zremrangeByScore(key, start, end);
    }

    public Long zremrangeByScore(String key, String start, String end) {
        return this.jedisCluster.zremrangeByScore(key, start, end);
    }

    public Long zlexcount(String key, String min, String max) {
        return this.jedisCluster.zlexcount(key, min, max);
    }

    public Set<String> zrangeByLex(String key, String min, String max) {
        return this.jedisCluster.zrangeByLex(key, min, max);
    }

    public Set<String> zrangeByLex(String key, String min, String max, int offset, int count) {
        return this.jedisCluster.zrangeByLex(key, min, max, offset, count);
    }

    public Set<String> zrevrangeByLex(String key, String max, String min) {
        return this.jedisCluster.zrevrangeByLex(key, max, min);
    }

    public Set<String> zrevrangeByLex(String key, String max, String min, int offset, int count) {
        return this.jedisCluster.zrevrangeByLex(key, max, min, offset, count);
    }

    public Long zremrangeByLex(String key, String min, String max) {
        return this.jedisCluster.zremrangeByLex(key, min, max);
    }

    public Long linsert(String key, ListPosition where, String pivot, String value) {
        return this.jedisCluster.linsert(key, where, pivot, value);
    }

    public Long lpushx(String key, String ... string) {
        return this.jedisCluster.lpushx(key, string);
    }

    public Long rpushx(String key, String ... string) {
        return this.jedisCluster.rpushx(key, string);
    }

    public List<String> blpop(int timeout, String key) {
        return this.jedisCluster.blpop(timeout, key);
    }

    public List<String> brpop(int timeout, String key) {
        return this.jedisCluster.brpop(timeout, key);
    }

    public Long del(String key) {
        return this.jedisCluster.del(key);
    }

    public Long unlink(String key) {
        return this.jedisCluster.unlink(key);
    }

    public String echo(String string) {
        return this.jedisCluster.echo(string);
    }

    public Long move(String key, int dbIndex) {
        throw new UnsupportedOperationException();
    }

    public Long bitcount(String key) {
        return this.jedisCluster.bitcount(key);
    }

    public Long bitcount(String key, long start, long end) {
        return this.jedisCluster.bitcount(key, start, end);
    }

    public Long bitpos(String key, boolean value) {
        throw new UnsupportedOperationException();
    }

    public Long bitpos(String key, boolean value, BitPosParams params) {
        throw new UnsupportedOperationException();
    }

    public ScanResult<Map.Entry<String, String>> hscan(String key, String cursor) {
        return this.jedisCluster.hscan(key, cursor);
    }

    public ScanResult<Map.Entry<String, String>> hscan(String key, String cursor, ScanParams params) {
        ScanResult scanResult = this.jedisCluster.hscan(key.getBytes(), cursor.getBytes(), params);
        List results = scanResult.getResult().stream().map(entry -> new AbstractMap.SimpleEntry<String, String>(new String((byte[])entry.getKey()), new String((byte[])entry.getValue()))).collect(Collectors.toList());
        return new ScanResult(scanResult.getCursorAsBytes(), results);
    }

    public ScanResult<String> sscan(String key, String cursor) {
        return this.jedisCluster.sscan(key, cursor);
    }

    public ScanResult<String> sscan(String key, String cursor, ScanParams params) {
        ScanResult scanResult = this.jedisCluster.sscan(key.getBytes(), cursor.getBytes(), params);
        List results = scanResult.getResult().stream().map(String::new).collect(Collectors.toList());
        return new ScanResult(scanResult.getCursorAsBytes(), results);
    }

    public ScanResult<Tuple> zscan(String key, String cursor) {
        return this.jedisCluster.zscan(key, cursor);
    }

    public ScanResult<Tuple> zscan(String key, String cursor, ScanParams params) {
        return this.jedisCluster.zscan(key.getBytes(), cursor.getBytes(), params);
    }

    public Long pfadd(String key, String ... elements) {
        return this.jedisCluster.pfadd(key, elements);
    }

    public long pfcount(String key) {
        return this.jedisCluster.pfcount(key);
    }

    public Long geoadd(String key, double longitude, double latitude, String member) {
        return this.jedisCluster.geoadd(key, longitude, latitude, member);
    }

    public Long geoadd(String key, Map<String, GeoCoordinate> memberCoordinateMap) {
        return this.jedisCluster.geoadd(key, memberCoordinateMap);
    }

    public Double geodist(String key, String member1, String member2) {
        return this.jedisCluster.geodist(key, member1, member2);
    }

    public Double geodist(String key, String member1, String member2, GeoUnit unit) {
        return this.jedisCluster.geodist(key, member1, member2, unit);
    }

    public List<String> geohash(String key, String ... members) {
        return this.jedisCluster.geohash(key, members);
    }

    public List<GeoCoordinate> geopos(String key, String ... members) {
        return this.jedisCluster.geopos(key, members);
    }

    public List<GeoRadiusResponse> georadius(String key, double longitude, double latitude, double radius, GeoUnit unit) {
        return this.jedisCluster.georadius(key, longitude, latitude, radius, unit);
    }

    public List<GeoRadiusResponse> georadiusReadonly(String key, double longitude, double latitude, double radius, GeoUnit unit) {
        return this.jedisCluster.georadiusReadonly(key, longitude, latitude, radius, unit);
    }

    public List<GeoRadiusResponse> georadius(String key, double longitude, double latitude, double radius, GeoUnit unit, GeoRadiusParam param) {
        return this.jedisCluster.georadius(key, longitude, latitude, radius, unit, param);
    }

    public List<GeoRadiusResponse> georadiusReadonly(String key, double longitude, double latitude, double radius, GeoUnit unit, GeoRadiusParam param) {
        return this.jedisCluster.georadiusReadonly(key, longitude, latitude, radius, unit, param);
    }

    public List<GeoRadiusResponse> georadiusByMember(String key, String member, double radius, GeoUnit unit) {
        return this.jedisCluster.georadiusByMember(key, member, radius, unit);
    }

    public List<GeoRadiusResponse> georadiusByMemberReadonly(String key, String member, double radius, GeoUnit unit) {
        return this.jedisCluster.georadiusByMemberReadonly(key, member, radius, unit);
    }

    public List<GeoRadiusResponse> georadiusByMember(String key, String member, double radius, GeoUnit unit, GeoRadiusParam param) {
        return this.jedisCluster.georadiusByMember(key, member, radius, unit, param);
    }

    public List<GeoRadiusResponse> georadiusByMemberReadonly(String key, String member, double radius, GeoUnit unit, GeoRadiusParam param) {
        return this.jedisCluster.georadiusByMemberReadonly(key, member, radius, unit, param);
    }

    public List<Long> bitfield(String key, String ... arguments) {
        return this.jedisCluster.bitfield(key, arguments);
    }

    public List<Long> bitfieldReadonly(String key, String ... arguments) {
        return this.jedisCluster.bitfieldReadonly(key, arguments);
    }

    public Long hstrlen(String key, String field) {
        return this.jedisCluster.hstrlen(key, field);
    }

    public StreamEntryID xadd(String key, StreamEntryID id, Map<String, String> hash) {
        return this.jedisCluster.xadd(key, id, hash);
    }

    public StreamEntryID xadd(String key, StreamEntryID id, Map<String, String> hash, long maxLen, boolean approximateLength) {
        return this.jedisCluster.xadd(key, id, hash, maxLen, approximateLength);
    }

    public Long xlen(String key) {
        return this.jedisCluster.xlen(key);
    }

    public List<StreamEntry> xrange(String key, StreamEntryID start, StreamEntryID end, int count) {
        return this.jedisCluster.xrange(key, start, end, count);
    }

    public List<StreamEntry> xrevrange(String key, StreamEntryID end, StreamEntryID start, int count) {
        return this.jedisCluster.xrevrange(key, end, start, count);
    }

    public long xack(String key, String group, StreamEntryID ... ids) {
        return this.jedisCluster.xack(key, group, ids);
    }

    public String xgroupCreate(String key, String groupname, StreamEntryID id, boolean makeStream) {
        return this.jedisCluster.xgroupCreate(key, groupname, id, makeStream);
    }

    public String xgroupSetID(String key, String groupname, StreamEntryID id) {
        return this.jedisCluster.xgroupSetID(key, groupname, id);
    }

    public long xgroupDestroy(String key, String groupname) {
        return this.jedisCluster.xgroupDestroy(key, groupname);
    }

    public Long xgroupDelConsumer(String key, String groupname, String consumername) {
        return this.jedisCluster.xgroupDelConsumer(key, groupname, consumername);
    }

    public List<StreamPendingEntry> xpending(String key, String groupname, StreamEntryID start, StreamEntryID end, int count, String consumername) {
        return this.jedisCluster.xpending(key, groupname, start, end, count, consumername);
    }

    public long xdel(String key, StreamEntryID ... ids) {
        return this.jedisCluster.xdel(key, ids);
    }

    public long xtrim(String key, long maxLen, boolean approximate) {
        return this.jedisCluster.xtrim(key, maxLen, approximate);
    }

    public List<StreamEntry> xclaim(String key, String group, String consumername, long minIdleTime, long newIdleTime, int retries, boolean force, StreamEntryID ... ids) {
        return this.jedisCluster.xclaim(key, group, consumername, minIdleTime, newIdleTime, retries, force, ids);
    }

    public StreamInfo xinfoStream(String key) {
        return null;
    }

    public List<StreamGroupInfo> xinfoGroup(String key) {
        return null;
    }

    public List<StreamConsumersInfo> xinfoConsumers(String key, String group) {
        return null;
    }
}

