/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.conductor.redis.jedis;

import java.util.List;
import java.util.Map;
import java.util.Set;
import redis.clients.jedis.BitPosParams;
import redis.clients.jedis.GeoCoordinate;
import redis.clients.jedis.GeoRadiusResponse;
import redis.clients.jedis.GeoUnit;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPoolAbstract;
import redis.clients.jedis.ListPosition;
import redis.clients.jedis.ScanParams;
import redis.clients.jedis.ScanResult;
import redis.clients.jedis.SortingParams;
import redis.clients.jedis.StreamConsumersInfo;
import redis.clients.jedis.StreamEntry;
import redis.clients.jedis.StreamEntryID;
import redis.clients.jedis.StreamGroupInfo;
import redis.clients.jedis.StreamInfo;
import redis.clients.jedis.StreamPendingEntry;
import redis.clients.jedis.Tuple;
import redis.clients.jedis.commands.JedisCommands;
import redis.clients.jedis.params.GeoRadiusParam;
import redis.clients.jedis.params.SetParams;
import redis.clients.jedis.params.ZAddParams;
import redis.clients.jedis.params.ZIncrByParams;

public class JedisSentinel
implements JedisCommands {
    private final JedisPoolAbstract jedisPool;

    public JedisSentinel(JedisPoolAbstract jedisPool) {
        this.jedisPool = jedisPool;
    }

    public String set(String key, String value) {
        try (Jedis jedis = (Jedis)this.jedisPool.getResource();){
            String string = jedis.set(key, value);
            return string;
        }
    }

    public String set(String key, String value, SetParams params) {
        try (Jedis jedis = (Jedis)this.jedisPool.getResource();){
            String string = jedis.set(key, value, params);
            return string;
        }
    }

    public String get(String key) {
        try (Jedis jedis = (Jedis)this.jedisPool.getResource();){
            String string = jedis.get(key);
            return string;
        }
    }

    public Boolean exists(String key) {
        try (Jedis jedis = (Jedis)this.jedisPool.getResource();){
            Boolean bl = jedis.exists(key);
            return bl;
        }
    }

    public Long persist(String key) {
        try (Jedis jedis = (Jedis)this.jedisPool.getResource();){
            Long l = jedis.persist(key);
            return l;
        }
    }

    public String type(String key) {
        try (Jedis jedis = (Jedis)this.jedisPool.getResource();){
            String string = jedis.type(key);
            return string;
        }
    }

    public byte[] dump(String key) {
        try (Jedis jedis = (Jedis)this.jedisPool.getResource();){
            byte[] byArray = jedis.dump(key);
            return byArray;
        }
    }

    public String restore(String key, int ttl, byte[] serializedValue) {
        try (Jedis jedis = (Jedis)this.jedisPool.getResource();){
            String string = jedis.restore(key, ttl, serializedValue);
            return string;
        }
    }

    public String restoreReplace(String key, int ttl, byte[] serializedValue) {
        try (Jedis jedis = (Jedis)this.jedisPool.getResource();){
            String string = jedis.restoreReplace(key, ttl, serializedValue);
            return string;
        }
    }

    public Long expire(String key, int seconds) {
        try (Jedis jedis = (Jedis)this.jedisPool.getResource();){
            Long l = jedis.expire(key, seconds);
            return l;
        }
    }

    public Long pexpire(String key, long milliseconds) {
        try (Jedis jedis = (Jedis)this.jedisPool.getResource();){
            Long l = jedis.pexpire(key, milliseconds);
            return l;
        }
    }

    public Long expireAt(String key, long unixTime) {
        try (Jedis jedis = (Jedis)this.jedisPool.getResource();){
            Long l = jedis.expireAt(key, unixTime);
            return l;
        }
    }

    public Long pexpireAt(String key, long millisecondsTimestamp) {
        try (Jedis jedis = (Jedis)this.jedisPool.getResource();){
            Long l = jedis.pexpireAt(key, millisecondsTimestamp);
            return l;
        }
    }

    public Long ttl(String key) {
        try (Jedis jedis = (Jedis)this.jedisPool.getResource();){
            Long l = jedis.ttl(key);
            return l;
        }
    }

    public Long pttl(String key) {
        try (Jedis jedis = (Jedis)this.jedisPool.getResource();){
            Long l = jedis.pttl(key);
            return l;
        }
    }

    public Long touch(String key) {
        try (Jedis jedis = (Jedis)this.jedisPool.getResource();){
            Long l = jedis.touch(key);
            return l;
        }
    }

    public Boolean setbit(String key, long offset, boolean value) {
        try (Jedis jedis = (Jedis)this.jedisPool.getResource();){
            Boolean bl = jedis.setbit(key, offset, value);
            return bl;
        }
    }

    public Boolean setbit(String key, long offset, String value) {
        try (Jedis jedis = (Jedis)this.jedisPool.getResource();){
            Boolean bl = jedis.setbit(key, offset, value);
            return bl;
        }
    }

    public Boolean getbit(String key, long offset) {
        try (Jedis jedis = (Jedis)this.jedisPool.getResource();){
            Boolean bl = jedis.getbit(key, offset);
            return bl;
        }
    }

    public Long setrange(String key, long offset, String value) {
        try (Jedis jedis = (Jedis)this.jedisPool.getResource();){
            Long l = jedis.setrange(key, offset, value);
            return l;
        }
    }

    public String getrange(String key, long startOffset, long endOffset) {
        try (Jedis jedis = (Jedis)this.jedisPool.getResource();){
            String string = jedis.getrange(key, startOffset, endOffset);
            return string;
        }
    }

    public String getSet(String key, String value) {
        try (Jedis jedis = (Jedis)this.jedisPool.getResource();){
            String string = jedis.getSet(key, value);
            return string;
        }
    }

    public Long setnx(String key, String value) {
        try (Jedis jedis = (Jedis)this.jedisPool.getResource();){
            Long l = jedis.setnx(key, value);
            return l;
        }
    }

    public String setex(String key, int seconds, String value) {
        try (Jedis jedis = (Jedis)this.jedisPool.getResource();){
            String string = jedis.setex(key, seconds, value);
            return string;
        }
    }

    public String psetex(String key, long milliseconds, String value) {
        try (Jedis jedis = (Jedis)this.jedisPool.getResource();){
            String string = jedis.psetex(key, milliseconds, value);
            return string;
        }
    }

    public Long decrBy(String key, long integer) {
        try (Jedis jedis = (Jedis)this.jedisPool.getResource();){
            Long l = jedis.decrBy(key, integer);
            return l;
        }
    }

    public Long decr(String key) {
        try (Jedis jedis = (Jedis)this.jedisPool.getResource();){
            Long l = jedis.decr(key);
            return l;
        }
    }

    public Long incrBy(String key, long integer) {
        try (Jedis jedis = (Jedis)this.jedisPool.getResource();){
            Long l = jedis.incrBy(key, integer);
            return l;
        }
    }

    public Double incrByFloat(String key, double value) {
        try (Jedis jedis = (Jedis)this.jedisPool.getResource();){
            Double d = jedis.incrByFloat(key, value);
            return d;
        }
    }

    public Long incr(String key) {
        try (Jedis jedis = (Jedis)this.jedisPool.getResource();){
            Long l = jedis.incr(key);
            return l;
        }
    }

    public Long append(String key, String value) {
        try (Jedis jedis = (Jedis)this.jedisPool.getResource();){
            Long l = jedis.append(key, value);
            return l;
        }
    }

    public String substr(String key, int start, int end) {
        try (Jedis jedis = (Jedis)this.jedisPool.getResource();){
            String string = jedis.substr(key, start, end);
            return string;
        }
    }

    public Long hset(String key, String field, String value) {
        try (Jedis jedis = (Jedis)this.jedisPool.getResource();){
            Long l = jedis.hset(key, field, value);
            return l;
        }
    }

    public Long hset(String key, Map<String, String> hash) {
        try (Jedis jedis = (Jedis)this.jedisPool.getResource();){
            Long l = jedis.hset(key, hash);
            return l;
        }
    }

    public String hget(String key, String field) {
        try (Jedis jedis = (Jedis)this.jedisPool.getResource();){
            String string = jedis.hget(key, field);
            return string;
        }
    }

    public Long hsetnx(String key, String field, String value) {
        try (Jedis jedis = (Jedis)this.jedisPool.getResource();){
            Long l = jedis.hsetnx(key, field, value);
            return l;
        }
    }

    public String hmset(String key, Map<String, String> hash) {
        try (Jedis jedis = (Jedis)this.jedisPool.getResource();){
            String string = jedis.hmset(key, hash);
            return string;
        }
    }

    public List<String> hmget(String key, String ... fields) {
        try (Jedis jedis = (Jedis)this.jedisPool.getResource();){
            List list = jedis.hmget(key, fields);
            return list;
        }
    }

    public Long hincrBy(String key, String field, long value) {
        try (Jedis jedis = (Jedis)this.jedisPool.getResource();){
            Long l = jedis.hincrBy(key, field, value);
            return l;
        }
    }

    public Double hincrByFloat(String key, String field, double value) {
        try (Jedis jedis = (Jedis)this.jedisPool.getResource();){
            Double d = jedis.hincrByFloat(key, field, value);
            return d;
        }
    }

    public Boolean hexists(String key, String field) {
        try (Jedis jedis = (Jedis)this.jedisPool.getResource();){
            Boolean bl = jedis.hexists(key, field);
            return bl;
        }
    }

    public Long hdel(String key, String ... field) {
        try (Jedis jedis = (Jedis)this.jedisPool.getResource();){
            Long l = jedis.hdel(key, field);
            return l;
        }
    }

    public Long hlen(String key) {
        try (Jedis jedis = (Jedis)this.jedisPool.getResource();){
            Long l = jedis.hlen(key);
            return l;
        }
    }

    public Set<String> hkeys(String key) {
        try (Jedis jedis = (Jedis)this.jedisPool.getResource();){
            Set set = jedis.hkeys(key);
            return set;
        }
    }

    public List<String> hvals(String key) {
        try (Jedis jedis = (Jedis)this.jedisPool.getResource();){
            List list = jedis.hvals(key);
            return list;
        }
    }

    public Map<String, String> hgetAll(String key) {
        try (Jedis jedis = (Jedis)this.jedisPool.getResource();){
            Map map = jedis.hgetAll(key);
            return map;
        }
    }

    public Long rpush(String key, String ... string) {
        try (Jedis jedis = (Jedis)this.jedisPool.getResource();){
            Long l = jedis.rpush(key, string);
            return l;
        }
    }

    public Long lpush(String key, String ... string) {
        try (Jedis jedis = (Jedis)this.jedisPool.getResource();){
            Long l = jedis.lpush(key, string);
            return l;
        }
    }

    public Long llen(String key) {
        try (Jedis jedis = (Jedis)this.jedisPool.getResource();){
            Long l = jedis.llen(key);
            return l;
        }
    }

    public List<String> lrange(String key, long start, long end) {
        try (Jedis jedis = (Jedis)this.jedisPool.getResource();){
            List list = jedis.lrange(key, start, end);
            return list;
        }
    }

    public String ltrim(String key, long start, long end) {
        try (Jedis jedis = (Jedis)this.jedisPool.getResource();){
            String string = jedis.ltrim(key, start, end);
            return string;
        }
    }

    public String lindex(String key, long index) {
        try (Jedis jedis = (Jedis)this.jedisPool.getResource();){
            String string = jedis.lindex(key, index);
            return string;
        }
    }

    public String lset(String key, long index, String value) {
        try (Jedis jedis = (Jedis)this.jedisPool.getResource();){
            String string = jedis.lset(key, index, value);
            return string;
        }
    }

    public Long lrem(String key, long count, String value) {
        try (Jedis jedis = (Jedis)this.jedisPool.getResource();){
            Long l = jedis.lrem(key, count, value);
            return l;
        }
    }

    public String lpop(String key) {
        try (Jedis jedis = (Jedis)this.jedisPool.getResource();){
            String string = jedis.lpop(key);
            return string;
        }
    }

    public String rpop(String key) {
        try (Jedis jedis = (Jedis)this.jedisPool.getResource();){
            String string = jedis.rpop(key);
            return string;
        }
    }

    public Long sadd(String key, String ... member) {
        try (Jedis jedis = (Jedis)this.jedisPool.getResource();){
            Long l = jedis.sadd(key, member);
            return l;
        }
    }

    public Set<String> smembers(String key) {
        try (Jedis jedis = (Jedis)this.jedisPool.getResource();){
            Set set = jedis.smembers(key);
            return set;
        }
    }

    public Long srem(String key, String ... member) {
        try (Jedis jedis = (Jedis)this.jedisPool.getResource();){
            Long l = jedis.srem(key, member);
            return l;
        }
    }

    public String spop(String key) {
        try (Jedis jedis = (Jedis)this.jedisPool.getResource();){
            String string = jedis.spop(key);
            return string;
        }
    }

    public Set<String> spop(String key, long count) {
        try (Jedis jedis = (Jedis)this.jedisPool.getResource();){
            Set set = jedis.spop(key, count);
            return set;
        }
    }

    public Long scard(String key) {
        try (Jedis jedis = (Jedis)this.jedisPool.getResource();){
            Long l = jedis.scard(key);
            return l;
        }
    }

    public Boolean sismember(String key, String member) {
        try (Jedis jedis = (Jedis)this.jedisPool.getResource();){
            Boolean bl = jedis.sismember(key, member);
            return bl;
        }
    }

    public String srandmember(String key) {
        try (Jedis jedis = (Jedis)this.jedisPool.getResource();){
            String string = jedis.srandmember(key);
            return string;
        }
    }

    public List<String> srandmember(String key, int count) {
        try (Jedis jedis = (Jedis)this.jedisPool.getResource();){
            List list = jedis.srandmember(key, count);
            return list;
        }
    }

    public Long strlen(String key) {
        try (Jedis jedis = (Jedis)this.jedisPool.getResource();){
            Long l = jedis.strlen(key);
            return l;
        }
    }

    public Long zadd(String key, double score, String member) {
        try (Jedis jedis = (Jedis)this.jedisPool.getResource();){
            Long l = jedis.zadd(key, score, member);
            return l;
        }
    }

    public Long zadd(String key, double score, String member, ZAddParams params) {
        try (Jedis jedis = (Jedis)this.jedisPool.getResource();){
            Long l = jedis.zadd(key, score, member, params);
            return l;
        }
    }

    public Long zadd(String key, Map<String, Double> scoreMembers) {
        try (Jedis jedis = (Jedis)this.jedisPool.getResource();){
            Long l = jedis.zadd(key, scoreMembers);
            return l;
        }
    }

    public Long zadd(String key, Map<String, Double> scoreMembers, ZAddParams params) {
        try (Jedis jedis = (Jedis)this.jedisPool.getResource();){
            Long l = jedis.zadd(key, scoreMembers, params);
            return l;
        }
    }

    public Set<String> zrange(String key, long start, long end) {
        try (Jedis jedis = (Jedis)this.jedisPool.getResource();){
            Set set = jedis.zrange(key, start, end);
            return set;
        }
    }

    public Long zrem(String key, String ... member) {
        try (Jedis jedis = (Jedis)this.jedisPool.getResource();){
            Long l = jedis.zrem(key, member);
            return l;
        }
    }

    public Double zincrby(String key, double score, String member) {
        try (Jedis jedis = (Jedis)this.jedisPool.getResource();){
            Double d = jedis.zincrby(key, score, member);
            return d;
        }
    }

    public Double zincrby(String key, double score, String member, ZIncrByParams params) {
        try (Jedis jedis = (Jedis)this.jedisPool.getResource();){
            Double d = jedis.zincrby(key, score, member, params);
            return d;
        }
    }

    public Long zrank(String key, String member) {
        try (Jedis jedis = (Jedis)this.jedisPool.getResource();){
            Long l = jedis.zrank(key, member);
            return l;
        }
    }

    public Long zrevrank(String key, String member) {
        try (Jedis jedis = (Jedis)this.jedisPool.getResource();){
            Long l = jedis.zrevrank(key, member);
            return l;
        }
    }

    public Set<String> zrevrange(String key, long start, long end) {
        try (Jedis jedis = (Jedis)this.jedisPool.getResource();){
            Set set = jedis.zrevrange(key, start, end);
            return set;
        }
    }

    public Set<Tuple> zrangeWithScores(String key, long start, long end) {
        try (Jedis jedis = (Jedis)this.jedisPool.getResource();){
            Set set = jedis.zrangeWithScores(key, start, end);
            return set;
        }
    }

    public Set<Tuple> zrevrangeWithScores(String key, long start, long end) {
        try (Jedis jedis = (Jedis)this.jedisPool.getResource();){
            Set set = jedis.zrevrangeWithScores(key, start, end);
            return set;
        }
    }

    public Long zcard(String key) {
        try (Jedis jedis = (Jedis)this.jedisPool.getResource();){
            Long l = jedis.zcard(key);
            return l;
        }
    }

    public Double zscore(String key, String member) {
        try (Jedis jedis = (Jedis)this.jedisPool.getResource();){
            Double d = jedis.zscore(key, member);
            return d;
        }
    }

    public Tuple zpopmax(String key) {
        try (Jedis jedis = (Jedis)this.jedisPool.getResource();){
            Tuple tuple = jedis.zpopmax(key);
            return tuple;
        }
    }

    public Set<Tuple> zpopmax(String key, int count) {
        try (Jedis jedis = (Jedis)this.jedisPool.getResource();){
            Set set = jedis.zpopmax(key, count);
            return set;
        }
    }

    public Tuple zpopmin(String key) {
        try (Jedis jedis = (Jedis)this.jedisPool.getResource();){
            Tuple tuple = jedis.zpopmin(key);
            return tuple;
        }
    }

    public Set<Tuple> zpopmin(String key, int count) {
        try (Jedis jedis = (Jedis)this.jedisPool.getResource();){
            Set set = jedis.zpopmin(key, count);
            return set;
        }
    }

    public List<String> sort(String key) {
        try (Jedis jedis = (Jedis)this.jedisPool.getResource();){
            List list = jedis.sort(key);
            return list;
        }
    }

    public List<String> sort(String key, SortingParams sortingParameters) {
        try (Jedis jedis = (Jedis)this.jedisPool.getResource();){
            List list = jedis.sort(key, sortingParameters);
            return list;
        }
    }

    public Long zcount(String key, double min, double max) {
        try (Jedis jedis = (Jedis)this.jedisPool.getResource();){
            Long l = jedis.zcount(key, min, max);
            return l;
        }
    }

    public Long zcount(String key, String min, String max) {
        try (Jedis jedis = (Jedis)this.jedisPool.getResource();){
            Long l = jedis.zcount(key, min, max);
            return l;
        }
    }

    public Set<String> zrangeByScore(String key, double min, double max) {
        try (Jedis jedis = (Jedis)this.jedisPool.getResource();){
            Set set = jedis.zrangeByScore(key, min, max);
            return set;
        }
    }

    public Set<String> zrangeByScore(String key, String min, String max) {
        try (Jedis jedis = (Jedis)this.jedisPool.getResource();){
            Set set = jedis.zrangeByScore(key, min, max);
            return set;
        }
    }

    public Set<String> zrevrangeByScore(String key, double max, double min) {
        try (Jedis jedis = (Jedis)this.jedisPool.getResource();){
            Set set = jedis.zrevrangeByScore(key, max, min);
            return set;
        }
    }

    public Set<String> zrangeByScore(String key, double min, double max, int offset, int count) {
        try (Jedis jedis = (Jedis)this.jedisPool.getResource();){
            Set set = jedis.zrangeByScore(key, min, max, offset, count);
            return set;
        }
    }

    public Set<String> zrevrangeByScore(String key, String max, String min) {
        try (Jedis jedis = (Jedis)this.jedisPool.getResource();){
            Set set = jedis.zrevrangeByScore(key, max, min);
            return set;
        }
    }

    public Set<String> zrangeByScore(String key, String min, String max, int offset, int count) {
        try (Jedis jedis = (Jedis)this.jedisPool.getResource();){
            Set set = jedis.zrangeByScore(key, min, max, offset, count);
            return set;
        }
    }

    public Set<String> zrevrangeByScore(String key, double max, double min, int offset, int count) {
        try (Jedis jedis = (Jedis)this.jedisPool.getResource();){
            Set set = jedis.zrevrangeByScore(key, max, min, offset, count);
            return set;
        }
    }

    public Set<Tuple> zrangeByScoreWithScores(String key, double min, double max) {
        try (Jedis jedis = (Jedis)this.jedisPool.getResource();){
            Set set = jedis.zrangeByScoreWithScores(key, min, max);
            return set;
        }
    }

    public Set<Tuple> zrevrangeByScoreWithScores(String key, double max, double min) {
        try (Jedis jedis = (Jedis)this.jedisPool.getResource();){
            Set set = jedis.zrevrangeByScoreWithScores(key, max, min);
            return set;
        }
    }

    public Set<Tuple> zrangeByScoreWithScores(String key, double min, double max, int offset, int count) {
        try (Jedis jedis = (Jedis)this.jedisPool.getResource();){
            Set set = jedis.zrangeByScoreWithScores(key, min, max, offset, count);
            return set;
        }
    }

    public Set<String> zrevrangeByScore(String key, String max, String min, int offset, int count) {
        try (Jedis jedis = (Jedis)this.jedisPool.getResource();){
            Set set = jedis.zrevrangeByScore(key, max, min, offset, count);
            return set;
        }
    }

    public Set<Tuple> zrangeByScoreWithScores(String key, String min, String max) {
        try (Jedis jedis = (Jedis)this.jedisPool.getResource();){
            Set set = jedis.zrangeByScoreWithScores(key, min, max);
            return set;
        }
    }

    public Set<Tuple> zrevrangeByScoreWithScores(String key, String max, String min) {
        try (Jedis jedis = (Jedis)this.jedisPool.getResource();){
            Set set = jedis.zrevrangeByScoreWithScores(key, max, min);
            return set;
        }
    }

    public Set<Tuple> zrangeByScoreWithScores(String key, String min, String max, int offset, int count) {
        try (Jedis jedis = (Jedis)this.jedisPool.getResource();){
            Set set = jedis.zrangeByScoreWithScores(key, min, max, offset, count);
            return set;
        }
    }

    public Set<Tuple> zrevrangeByScoreWithScores(String key, double max, double min, int offset, int count) {
        try (Jedis jedis = (Jedis)this.jedisPool.getResource();){
            Set set = jedis.zrevrangeByScoreWithScores(key, max, min, offset, count);
            return set;
        }
    }

    public Set<Tuple> zrevrangeByScoreWithScores(String key, String max, String min, int offset, int count) {
        try (Jedis jedis = (Jedis)this.jedisPool.getResource();){
            Set set = jedis.zrevrangeByScoreWithScores(key, max, min, offset, count);
            return set;
        }
    }

    public Long zremrangeByRank(String key, long start, long end) {
        try (Jedis jedis = (Jedis)this.jedisPool.getResource();){
            Long l = jedis.zremrangeByRank(key, start, end);
            return l;
        }
    }

    public Long zremrangeByScore(String key, double start, double end) {
        try (Jedis jedis = (Jedis)this.jedisPool.getResource();){
            Long l = jedis.zremrangeByScore(key, start, end);
            return l;
        }
    }

    public Long zremrangeByScore(String key, String start, String end) {
        try (Jedis jedis = (Jedis)this.jedisPool.getResource();){
            Long l = jedis.zremrangeByScore(key, start, end);
            return l;
        }
    }

    public Long zlexcount(String key, String min, String max) {
        try (Jedis jedis = (Jedis)this.jedisPool.getResource();){
            Long l = jedis.zlexcount(key, min, max);
            return l;
        }
    }

    public Set<String> zrangeByLex(String key, String min, String max) {
        try (Jedis jedis = (Jedis)this.jedisPool.getResource();){
            Set set = jedis.zrangeByLex(key, min, max);
            return set;
        }
    }

    public Set<String> zrangeByLex(String key, String min, String max, int offset, int count) {
        try (Jedis jedis = (Jedis)this.jedisPool.getResource();){
            Set set = jedis.zrangeByLex(key, min, max, offset, count);
            return set;
        }
    }

    public Set<String> zrevrangeByLex(String key, String max, String min) {
        try (Jedis jedis = (Jedis)this.jedisPool.getResource();){
            Set set = jedis.zrevrangeByLex(key, max, min);
            return set;
        }
    }

    public Set<String> zrevrangeByLex(String key, String max, String min, int offset, int count) {
        try (Jedis jedis = (Jedis)this.jedisPool.getResource();){
            Set set = jedis.zrevrangeByLex(key, max, min, offset, count);
            return set;
        }
    }

    public Long zremrangeByLex(String key, String min, String max) {
        try (Jedis jedis = (Jedis)this.jedisPool.getResource();){
            Long l = jedis.zremrangeByLex(key, min, max);
            return l;
        }
    }

    public Long linsert(String key, ListPosition where, String pivot, String value) {
        try (Jedis jedis = (Jedis)this.jedisPool.getResource();){
            Long l = jedis.linsert(key, where, pivot, value);
            return l;
        }
    }

    public Long lpushx(String key, String ... string) {
        try (Jedis jedis = (Jedis)this.jedisPool.getResource();){
            Long l = jedis.lpushx(key, string);
            return l;
        }
    }

    public Long rpushx(String key, String ... string) {
        try (Jedis jedis = (Jedis)this.jedisPool.getResource();){
            Long l = jedis.rpushx(key, string);
            return l;
        }
    }

    public List<String> blpop(int timeout, String key) {
        try (Jedis jedis = (Jedis)this.jedisPool.getResource();){
            List list = jedis.blpop(timeout, key);
            return list;
        }
    }

    public List<String> brpop(int timeout, String key) {
        try (Jedis jedis = (Jedis)this.jedisPool.getResource();){
            List list = jedis.brpop(timeout, key);
            return list;
        }
    }

    public Long del(String key) {
        try (Jedis jedis = (Jedis)this.jedisPool.getResource();){
            Long l = jedis.del(key);
            return l;
        }
    }

    public Long unlink(String key) {
        try (Jedis jedis = (Jedis)this.jedisPool.getResource();){
            Long l = jedis.unlink(key);
            return l;
        }
    }

    public String echo(String string) {
        try (Jedis jedis = (Jedis)this.jedisPool.getResource();){
            String string2 = jedis.echo(string);
            return string2;
        }
    }

    public Long move(String key, int dbIndex) {
        try (Jedis jedis = (Jedis)this.jedisPool.getResource();){
            Long l = jedis.move(key, dbIndex);
            return l;
        }
    }

    public Long bitcount(String key) {
        try (Jedis jedis = (Jedis)this.jedisPool.getResource();){
            Long l = jedis.bitcount(key);
            return l;
        }
    }

    public Long bitcount(String key, long start, long end) {
        try (Jedis jedis = (Jedis)this.jedisPool.getResource();){
            Long l = jedis.bitcount(key, start, end);
            return l;
        }
    }

    public Long bitpos(String key, boolean value) {
        try (Jedis jedis = (Jedis)this.jedisPool.getResource();){
            Long l = jedis.bitpos(key, value);
            return l;
        }
    }

    public Long bitpos(String key, boolean value, BitPosParams params) {
        try (Jedis jedis = (Jedis)this.jedisPool.getResource();){
            Long l = jedis.bitpos(key, value, params);
            return l;
        }
    }

    public ScanResult<Map.Entry<String, String>> hscan(String key, String cursor) {
        try (Jedis jedis = (Jedis)this.jedisPool.getResource();){
            ScanResult scanResult = jedis.hscan(key, cursor);
            return scanResult;
        }
    }

    public ScanResult<Map.Entry<String, String>> hscan(String key, String cursor, ScanParams params) {
        try (Jedis jedis = (Jedis)this.jedisPool.getResource();){
            ScanResult scanResult = jedis.hscan(key, cursor, params);
            return scanResult;
        }
    }

    public ScanResult<String> sscan(String key, String cursor) {
        try (Jedis jedis = (Jedis)this.jedisPool.getResource();){
            ScanResult scanResult = jedis.sscan(key, cursor);
            return scanResult;
        }
    }

    public ScanResult<String> sscan(String key, String cursor, ScanParams params) {
        try (Jedis jedis = (Jedis)this.jedisPool.getResource();){
            ScanResult scanResult = jedis.sscan(key, cursor, params);
            return scanResult;
        }
    }

    public ScanResult<Tuple> zscan(String key, String cursor) {
        try (Jedis jedis = (Jedis)this.jedisPool.getResource();){
            ScanResult scanResult = jedis.zscan(key, cursor);
            return scanResult;
        }
    }

    public ScanResult<Tuple> zscan(String key, String cursor, ScanParams params) {
        try (Jedis jedis = (Jedis)this.jedisPool.getResource();){
            ScanResult scanResult = jedis.zscan(key, cursor, params);
            return scanResult;
        }
    }

    public Long pfadd(String key, String ... elements) {
        try (Jedis jedis = (Jedis)this.jedisPool.getResource();){
            Long l = jedis.pfadd(key, elements);
            return l;
        }
    }

    public long pfcount(String key) {
        try (Jedis jedis = (Jedis)this.jedisPool.getResource();){
            long l = jedis.pfcount(key);
            return l;
        }
    }

    public Long geoadd(String key, double longitude, double latitude, String member) {
        try (Jedis jedis = (Jedis)this.jedisPool.getResource();){
            Long l = jedis.geoadd(key, longitude, latitude, member);
            return l;
        }
    }

    public Long geoadd(String key, Map<String, GeoCoordinate> memberCoordinateMap) {
        try (Jedis jedis = (Jedis)this.jedisPool.getResource();){
            Long l = jedis.geoadd(key, memberCoordinateMap);
            return l;
        }
    }

    public Double geodist(String key, String member1, String member2) {
        try (Jedis jedis = (Jedis)this.jedisPool.getResource();){
            Double d = jedis.geodist(key, member1, member2);
            return d;
        }
    }

    public Double geodist(String key, String member1, String member2, GeoUnit unit) {
        try (Jedis jedis = (Jedis)this.jedisPool.getResource();){
            Double d = jedis.geodist(key, member1, member2, unit);
            return d;
        }
    }

    public List<String> geohash(String key, String ... members) {
        try (Jedis jedis = (Jedis)this.jedisPool.getResource();){
            List list = jedis.geohash(key, members);
            return list;
        }
    }

    public List<GeoCoordinate> geopos(String key, String ... members) {
        try (Jedis jedis = (Jedis)this.jedisPool.getResource();){
            List list = jedis.geopos(key, members);
            return list;
        }
    }

    public List<GeoRadiusResponse> georadius(String key, double longitude, double latitude, double radius, GeoUnit unit) {
        try (Jedis jedis = (Jedis)this.jedisPool.getResource();){
            List list = jedis.georadius(key, longitude, latitude, radius, unit);
            return list;
        }
    }

    public List<GeoRadiusResponse> georadiusReadonly(String key, double longitude, double latitude, double radius, GeoUnit unit) {
        try (Jedis jedis = (Jedis)this.jedisPool.getResource();){
            List list = jedis.georadiusReadonly(key, longitude, latitude, radius, unit);
            return list;
        }
    }

    public List<GeoRadiusResponse> georadius(String key, double longitude, double latitude, double radius, GeoUnit unit, GeoRadiusParam param) {
        try (Jedis jedis = (Jedis)this.jedisPool.getResource();){
            List list = jedis.georadius(key, longitude, latitude, radius, unit, param);
            return list;
        }
    }

    public List<GeoRadiusResponse> georadiusReadonly(String key, double longitude, double latitude, double radius, GeoUnit unit, GeoRadiusParam param) {
        try (Jedis jedis = (Jedis)this.jedisPool.getResource();){
            List list = jedis.georadiusReadonly(key, longitude, latitude, radius, unit, param);
            return list;
        }
    }

    public List<GeoRadiusResponse> georadiusByMember(String key, String member, double radius, GeoUnit unit) {
        try (Jedis jedis = (Jedis)this.jedisPool.getResource();){
            List list = jedis.georadiusByMember(key, member, radius, unit);
            return list;
        }
    }

    public List<GeoRadiusResponse> georadiusByMemberReadonly(String key, String member, double radius, GeoUnit unit) {
        try (Jedis jedis = (Jedis)this.jedisPool.getResource();){
            List list = jedis.georadiusByMemberReadonly(key, member, radius, unit);
            return list;
        }
    }

    public List<GeoRadiusResponse> georadiusByMember(String key, String member, double radius, GeoUnit unit, GeoRadiusParam param) {
        try (Jedis jedis = (Jedis)this.jedisPool.getResource();){
            List list = jedis.georadiusByMember(key, member, radius, unit, param);
            return list;
        }
    }

    public List<GeoRadiusResponse> georadiusByMemberReadonly(String key, String member, double radius, GeoUnit unit, GeoRadiusParam param) {
        try (Jedis jedis = (Jedis)this.jedisPool.getResource();){
            List list = jedis.georadiusByMemberReadonly(key, member, radius, unit, param);
            return list;
        }
    }

    public List<Long> bitfield(String key, String ... arguments) {
        try (Jedis jedis = (Jedis)this.jedisPool.getResource();){
            List list = jedis.bitfield(key, arguments);
            return list;
        }
    }

    public List<Long> bitfieldReadonly(String key, String ... arguments) {
        try (Jedis jedis = (Jedis)this.jedisPool.getResource();){
            List list = jedis.bitfieldReadonly(key, arguments);
            return list;
        }
    }

    public Long hstrlen(String key, String field) {
        try (Jedis jedis = (Jedis)this.jedisPool.getResource();){
            Long l = jedis.hstrlen(key, field);
            return l;
        }
    }

    public StreamEntryID xadd(String key, StreamEntryID id, Map<String, String> hash) {
        try (Jedis jedis = (Jedis)this.jedisPool.getResource();){
            StreamEntryID streamEntryID = jedis.xadd(key, id, hash);
            return streamEntryID;
        }
    }

    public StreamEntryID xadd(String key, StreamEntryID id, Map<String, String> hash, long maxLen, boolean approximateLength) {
        try (Jedis jedis = (Jedis)this.jedisPool.getResource();){
            StreamEntryID streamEntryID = jedis.xadd(key, id, hash, maxLen, approximateLength);
            return streamEntryID;
        }
    }

    public Long xlen(String key) {
        try (Jedis jedis = (Jedis)this.jedisPool.getResource();){
            Long l = jedis.xlen(key);
            return l;
        }
    }

    public List<StreamEntry> xrange(String key, StreamEntryID start, StreamEntryID end, int count) {
        try (Jedis jedis = (Jedis)this.jedisPool.getResource();){
            List list = jedis.xrange(key, start, end, count);
            return list;
        }
    }

    public List<StreamEntry> xrevrange(String key, StreamEntryID end, StreamEntryID start, int count) {
        try (Jedis jedis = (Jedis)this.jedisPool.getResource();){
            List list = jedis.xrevrange(key, end, start, count);
            return list;
        }
    }

    public long xack(String key, String group, StreamEntryID ... ids) {
        try (Jedis jedis = (Jedis)this.jedisPool.getResource();){
            long l = jedis.xack(key, group, ids);
            return l;
        }
    }

    public String xgroupCreate(String key, String groupname, StreamEntryID id, boolean makeStream) {
        try (Jedis jedis = (Jedis)this.jedisPool.getResource();){
            String string = jedis.xgroupCreate(key, groupname, id, makeStream);
            return string;
        }
    }

    public String xgroupSetID(String key, String groupname, StreamEntryID id) {
        try (Jedis jedis = (Jedis)this.jedisPool.getResource();){
            String string = jedis.xgroupSetID(key, groupname, id);
            return string;
        }
    }

    public long xgroupDestroy(String key, String groupname) {
        try (Jedis jedis = (Jedis)this.jedisPool.getResource();){
            long l = jedis.xgroupDestroy(key, groupname);
            return l;
        }
    }

    public Long xgroupDelConsumer(String key, String groupname, String consumername) {
        try (Jedis jedis = (Jedis)this.jedisPool.getResource();){
            Long l = jedis.xgroupDelConsumer(key, groupname, consumername);
            return l;
        }
    }

    public List<StreamPendingEntry> xpending(String key, String groupname, StreamEntryID start, StreamEntryID end, int count, String consumername) {
        try (Jedis jedis = (Jedis)this.jedisPool.getResource();){
            List list = jedis.xpending(key, groupname, start, end, count, consumername);
            return list;
        }
    }

    public long xdel(String key, StreamEntryID ... ids) {
        try (Jedis jedis = (Jedis)this.jedisPool.getResource();){
            long l = jedis.xdel(key, ids);
            return l;
        }
    }

    public long xtrim(String key, long maxLen, boolean approximate) {
        try (Jedis jedis = (Jedis)this.jedisPool.getResource();){
            long l = jedis.xtrim(key, maxLen, approximate);
            return l;
        }
    }

    public List<StreamEntry> xclaim(String key, String group, String consumername, long minIdleTime, long newIdleTime, int retries, boolean force, StreamEntryID ... ids) {
        try (Jedis jedis = (Jedis)this.jedisPool.getResource();){
            List list = jedis.xclaim(key, group, consumername, minIdleTime, newIdleTime, retries, force, ids);
            return list;
        }
    }

    public StreamInfo xinfoStream(String key) {
        try (Jedis jedis = (Jedis)this.jedisPool.getResource();){
            StreamInfo streamInfo = jedis.xinfoStream(key);
            return streamInfo;
        }
    }

    public List<StreamGroupInfo> xinfoGroup(String key) {
        try (Jedis jedis = (Jedis)this.jedisPool.getResource();){
            List list = jedis.xinfoGroup(key);
            return list;
        }
    }

    public List<StreamConsumersInfo> xinfoConsumers(String key, String group) {
        try (Jedis jedis = (Jedis)this.jedisPool.getResource();){
            List list = jedis.xinfoConsumers(key, group);
            return list;
        }
    }
}

