/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.conductor.rest.controllers;

import com.netflix.conductor.common.metadata.workflow.RerunWorkflowRequest;
import com.netflix.conductor.common.metadata.workflow.SkipTaskRequest;
import com.netflix.conductor.common.metadata.workflow.StartWorkflowRequest;
import com.netflix.conductor.common.run.ExternalStorageLocation;
import com.netflix.conductor.common.run.SearchResult;
import com.netflix.conductor.common.run.Workflow;
import com.netflix.conductor.common.run.WorkflowSummary;
import com.netflix.conductor.common.run.WorkflowTestRequest;
import com.netflix.conductor.service.WorkflowService;
import com.netflix.conductor.service.WorkflowTestService;
import io.swagger.v3.oas.annotations.Operation;
import java.util.List;
import java.util.Map;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/workflow"})
public class WorkflowResource {
    private final WorkflowService workflowService;
    private final WorkflowTestService workflowTestService;

    public WorkflowResource(WorkflowService workflowService, WorkflowTestService workflowTestService) {
        this.workflowService = workflowService;
        this.workflowTestService = workflowTestService;
    }

    @PostMapping(produces={"text/plain"})
    @Operation(summary="Start a new workflow with StartWorkflowRequest, which allows task to be executed in a domain")
    public String startWorkflow(@RequestBody StartWorkflowRequest request) {
        return this.workflowService.startWorkflow(request);
    }

    @PostMapping(value={"/{name}"}, produces={"text/plain"})
    @Operation(summary="Start a new workflow. Returns the ID of the workflow instance that can be later used for tracking")
    public String startWorkflow(@PathVariable(value="name") String name, @RequestParam(value="version", required=false) Integer version, @RequestParam(value="correlationId", required=false) String correlationId, @RequestParam(value="priority", defaultValue="0", required=false) int priority, @RequestBody Map<String, Object> input) {
        return this.workflowService.startWorkflow(name, version, correlationId, Integer.valueOf(priority), input);
    }

    @GetMapping(value={"/{name}/correlated/{correlationId}"})
    @Operation(summary="Lists workflows for the given correlation id")
    public List<Workflow> getWorkflows(@PathVariable(value="name") String name, @PathVariable(value="correlationId") String correlationId, @RequestParam(value="includeClosed", defaultValue="false", required=false) boolean includeClosed, @RequestParam(value="includeTasks", defaultValue="false", required=false) boolean includeTasks) {
        return this.workflowService.getWorkflows(name, correlationId, includeClosed, includeTasks);
    }

    @PostMapping(value={"/{name}/correlated"})
    @Operation(summary="Lists workflows for the given correlation id list")
    public Map<String, List<Workflow>> getWorkflows(@PathVariable(value="name") String name, @RequestParam(value="includeClosed", defaultValue="false", required=false) boolean includeClosed, @RequestParam(value="includeTasks", defaultValue="false", required=false) boolean includeTasks, @RequestBody List<String> correlationIds) {
        return this.workflowService.getWorkflows(name, includeClosed, includeTasks, correlationIds);
    }

    @GetMapping(value={"/{workflowId}"})
    @Operation(summary="Gets the workflow by workflow id")
    public Workflow getExecutionStatus(@PathVariable(value="workflowId") String workflowId, @RequestParam(value="includeTasks", defaultValue="true", required=false) boolean includeTasks) {
        return this.workflowService.getExecutionStatus(workflowId, includeTasks);
    }

    @DeleteMapping(value={"/{workflowId}/remove"})
    @Operation(summary="Removes the workflow from the system")
    public void delete(@PathVariable(value="workflowId") String workflowId, @RequestParam(value="archiveWorkflow", defaultValue="true", required=false) boolean archiveWorkflow) {
        this.workflowService.deleteWorkflow(workflowId, archiveWorkflow);
    }

    @GetMapping(value={"/running/{name}"})
    @Operation(summary="Retrieve all the running workflows")
    public List<String> getRunningWorkflow(@PathVariable(value="name") String workflowName, @RequestParam(value="version", defaultValue="1", required=false) int version, @RequestParam(value="startTime", required=false) Long startTime, @RequestParam(value="endTime", required=false) Long endTime) {
        return this.workflowService.getRunningWorkflows(workflowName, Integer.valueOf(version), startTime, endTime);
    }

    @PutMapping(value={"/decide/{workflowId}"})
    @Operation(summary="Starts the decision task for a workflow")
    public void decide(@PathVariable(value="workflowId") String workflowId) {
        this.workflowService.decideWorkflow(workflowId);
    }

    @PutMapping(value={"/{workflowId}/pause"})
    @Operation(summary="Pauses the workflow")
    public void pauseWorkflow(@PathVariable(value="workflowId") String workflowId) {
        this.workflowService.pauseWorkflow(workflowId);
    }

    @PutMapping(value={"/{workflowId}/resume"})
    @Operation(summary="Resumes the workflow")
    public void resumeWorkflow(@PathVariable(value="workflowId") String workflowId) {
        this.workflowService.resumeWorkflow(workflowId);
    }

    @PutMapping(value={"/{workflowId}/skiptask/{taskReferenceName}"})
    @Operation(summary="Skips a given task from a current running workflow")
    public void skipTaskFromWorkflow(@PathVariable(value="workflowId") String workflowId, @PathVariable(value="taskReferenceName") String taskReferenceName, SkipTaskRequest skipTaskRequest) {
        this.workflowService.skipTaskFromWorkflow(workflowId, taskReferenceName, skipTaskRequest);
    }

    @PostMapping(value={"/{workflowId}/rerun"}, produces={"text/plain"})
    @Operation(summary="Reruns the workflow from a specific task")
    public String rerun(@PathVariable(value="workflowId") String workflowId, @RequestBody RerunWorkflowRequest request) {
        return this.workflowService.rerunWorkflow(workflowId, request);
    }

    @PostMapping(value={"/{workflowId}/restart"})
    @Operation(summary="Restarts a completed workflow")
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void restart(@PathVariable(value="workflowId") String workflowId, @RequestParam(value="useLatestDefinitions", defaultValue="false", required=false) boolean useLatestDefinitions) {
        this.workflowService.restartWorkflow(workflowId, useLatestDefinitions);
    }

    @PostMapping(value={"/{workflowId}/retry"})
    @Operation(summary="Retries the last failed task")
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void retry(@PathVariable(value="workflowId") String workflowId, @RequestParam(value="resumeSubworkflowTasks", defaultValue="false", required=false) boolean resumeSubworkflowTasks) {
        this.workflowService.retryWorkflow(workflowId, resumeSubworkflowTasks);
    }

    @PostMapping(value={"/{workflowId}/resetcallbacks"})
    @Operation(summary="Resets callback times of all non-terminal SIMPLE tasks to 0")
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void resetWorkflow(@PathVariable(value="workflowId") String workflowId) {
        this.workflowService.resetWorkflow(workflowId);
    }

    @DeleteMapping(value={"/{workflowId}"})
    @Operation(summary="Terminate workflow execution")
    public void terminate(@PathVariable(value="workflowId") String workflowId, @RequestParam(value="reason", required=false) String reason) {
        this.workflowService.terminateWorkflow(workflowId, reason);
    }

    @Operation(summary="Search for workflows based on payload and other parameters", description="use sort options as sort=<field>:ASC|DESC e.g. sort=name&sort=workflowId:DESC. If order is not specified, defaults to ASC.")
    @GetMapping(value={"/search"})
    public SearchResult<WorkflowSummary> search(@RequestParam(value="start", defaultValue="0", required=false) int start, @RequestParam(value="size", defaultValue="100", required=false) int size, @RequestParam(value="sort", required=false) String sort, @RequestParam(value="freeText", defaultValue="*", required=false) String freeText, @RequestParam(value="query", required=false) String query) {
        return this.workflowService.searchWorkflows(start, size, sort, freeText, query);
    }

    @Operation(summary="Search for workflows based on payload and other parameters", description="use sort options as sort=<field>:ASC|DESC e.g. sort=name&sort=workflowId:DESC. If order is not specified, defaults to ASC.")
    @GetMapping(value={"/search-v2"})
    public SearchResult<Workflow> searchV2(@RequestParam(value="start", defaultValue="0", required=false) int start, @RequestParam(value="size", defaultValue="100", required=false) int size, @RequestParam(value="sort", required=false) String sort, @RequestParam(value="freeText", defaultValue="*", required=false) String freeText, @RequestParam(value="query", required=false) String query) {
        return this.workflowService.searchWorkflowsV2(start, size, sort, freeText, query);
    }

    @Operation(summary="Search for workflows based on task parameters", description="use sort options as sort=<field>:ASC|DESC e.g. sort=name&sort=workflowId:DESC. If order is not specified, defaults to ASC")
    @GetMapping(value={"/search-by-tasks"})
    public SearchResult<WorkflowSummary> searchWorkflowsByTasks(@RequestParam(value="start", defaultValue="0", required=false) int start, @RequestParam(value="size", defaultValue="100", required=false) int size, @RequestParam(value="sort", required=false) String sort, @RequestParam(value="freeText", defaultValue="*", required=false) String freeText, @RequestParam(value="query", required=false) String query) {
        return this.workflowService.searchWorkflowsByTasks(start, size, sort, freeText, query);
    }

    @Operation(summary="Search for workflows based on task parameters", description="use sort options as sort=<field>:ASC|DESC e.g. sort=name&sort=workflowId:DESC. If order is not specified, defaults to ASC")
    @GetMapping(value={"/search-by-tasks-v2"})
    public SearchResult<Workflow> searchWorkflowsByTasksV2(@RequestParam(value="start", defaultValue="0", required=false) int start, @RequestParam(value="size", defaultValue="100", required=false) int size, @RequestParam(value="sort", required=false) String sort, @RequestParam(value="freeText", defaultValue="*", required=false) String freeText, @RequestParam(value="query", required=false) String query) {
        return this.workflowService.searchWorkflowsByTasksV2(start, size, sort, freeText, query);
    }

    @Operation(summary="Get the uri and path of the external storage where the workflow payload is to be stored")
    @GetMapping(value={"/externalstoragelocation", "external-storage-location"})
    public ExternalStorageLocation getExternalStorageLocation(@RequestParam(value="path") String path, @RequestParam(value="operation") String operation, @RequestParam(value="payloadType") String payloadType) {
        return this.workflowService.getExternalStorageLocation(path, operation, payloadType);
    }

    @PostMapping(value={"test"}, produces={"application/json"})
    @Operation(summary="Test workflow execution using mock data")
    public Workflow testWorkflow(@RequestBody WorkflowTestRequest request) {
        return this.workflowTestService.testWorkflow(request);
    }
}

