/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.conductor.rest.controllers;

import com.netflix.conductor.common.metadata.events.EventHandler;
import com.netflix.conductor.service.EventService;
import io.swagger.v3.oas.annotations.Operation;
import java.util.List;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/event"})
public class EventResource {
    private final EventService eventService;

    public EventResource(EventService eventService) {
        this.eventService = eventService;
    }

    @PostMapping
    @Operation(summary="Add a new event handler.")
    public void addEventHandler(@RequestBody EventHandler eventHandler) {
        this.eventService.addEventHandler(eventHandler);
    }

    @PutMapping
    @Operation(summary="Update an existing event handler.")
    public void updateEventHandler(@RequestBody EventHandler eventHandler) {
        this.eventService.updateEventHandler(eventHandler);
    }

    @DeleteMapping(value={"/{name}"})
    @Operation(summary="Remove an event handler")
    public void removeEventHandlerStatus(@PathVariable(value="name") String name) {
        this.eventService.removeEventHandlerStatus(name);
    }

    @GetMapping
    @Operation(summary="Get all the event handlers")
    public List<EventHandler> getEventHandlers() {
        return this.eventService.getEventHandlers();
    }

    @GetMapping(value={"/{event}"})
    @Operation(summary="Get event handlers for a given event")
    public List<EventHandler> getEventHandlersForEvent(@PathVariable(value="event") String event, @RequestParam(value="activeOnly", defaultValue="true", required=false) boolean activeOnly) {
        return this.eventService.getEventHandlersForEvent(event, activeOnly);
    }
}

