/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.conductor.rest.controllers;

import com.netflix.conductor.common.metadata.tasks.TaskDef;
import com.netflix.conductor.common.metadata.workflow.WorkflowDef;
import com.netflix.conductor.common.metadata.workflow.WorkflowDefSummary;
import com.netflix.conductor.common.model.BulkResponse;
import com.netflix.conductor.service.MetadataService;
import io.swagger.v3.oas.annotations.Operation;
import java.util.List;
import java.util.Map;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/metadata"})
public class MetadataResource {
    private final MetadataService metadataService;

    public MetadataResource(MetadataService metadataService) {
        this.metadataService = metadataService;
    }

    @PostMapping(value={"/workflow"})
    @Operation(summary="Create a new workflow definition")
    public void create(@RequestBody WorkflowDef workflowDef) {
        this.metadataService.registerWorkflowDef(workflowDef);
    }

    @PostMapping(value={"/workflow/validate"})
    @Operation(summary="Validates a new workflow definition")
    public void validate(@RequestBody WorkflowDef workflowDef) {
        this.metadataService.validateWorkflowDef(workflowDef);
    }

    @PutMapping(value={"/workflow"})
    @Operation(summary="Create or update workflow definition")
    public BulkResponse<String> update(@RequestBody List<WorkflowDef> workflowDefs) {
        return this.metadataService.updateWorkflowDef(workflowDefs);
    }

    @Operation(summary="Retrieves workflow definition along with blueprint")
    @GetMapping(value={"/workflow/{name}"})
    public WorkflowDef get(@PathVariable(value="name") String name, @RequestParam(value="version", required=false) Integer version) {
        return this.metadataService.getWorkflowDef(name, version);
    }

    @Operation(summary="Retrieves all workflow definition along with blueprint")
    @GetMapping(value={"/workflow"})
    public List<WorkflowDef> getAll() {
        return this.metadataService.getWorkflowDefs();
    }

    @Operation(summary="Returns workflow names and versions only (no definition bodies)")
    @GetMapping(value={"/workflow/names-and-versions"})
    public Map<String, ? extends Iterable<WorkflowDefSummary>> getWorkflowNamesAndVersions() {
        return this.metadataService.getWorkflowNamesAndVersions();
    }

    @Operation(summary="Returns only the latest version of all workflow definitions")
    @GetMapping(value={"/workflow/latest-versions"})
    public List<WorkflowDef> getAllWorkflowsWithLatestVersions() {
        return this.metadataService.getWorkflowDefsLatestVersions();
    }

    @DeleteMapping(value={"/workflow/{name}/{version}"})
    @Operation(summary="Removes workflow definition. It does not remove workflows associated with the definition.")
    public void unregisterWorkflowDef(@PathVariable(value="name") String name, @PathVariable(value="version") Integer version) {
        this.metadataService.unregisterWorkflowDef(name, version);
    }

    @PostMapping(value={"/taskdefs"})
    @Operation(summary="Create new task definition(s)")
    public void registerTaskDef(@RequestBody List<TaskDef> taskDefs) {
        this.metadataService.registerTaskDef(taskDefs);
    }

    @PutMapping(value={"/taskdefs"})
    @Operation(summary="Update an existing task")
    public void registerTaskDef(@RequestBody TaskDef taskDef) {
        this.metadataService.updateTaskDef(taskDef);
    }

    @GetMapping(value={"/taskdefs"})
    @Operation(summary="Gets all task definition")
    public List<TaskDef> getTaskDefs() {
        return this.metadataService.getTaskDefs();
    }

    @GetMapping(value={"/taskdefs/{tasktype}"})
    @Operation(summary="Gets the task definition")
    public TaskDef getTaskDef(@PathVariable(value="tasktype") String taskType) {
        return this.metadataService.getTaskDef(taskType);
    }

    @DeleteMapping(value={"/taskdefs/{tasktype}"})
    @Operation(summary="Remove a task definition")
    public void unregisterTaskDef(@PathVariable(value="tasktype") String taskType) {
        this.metadataService.unregisterTaskDef(taskType);
    }
}

