/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.conductor.rest.controllers;

import com.netflix.conductor.common.metadata.tasks.PollData;
import com.netflix.conductor.common.metadata.tasks.Task;
import com.netflix.conductor.common.metadata.tasks.TaskExecLog;
import com.netflix.conductor.common.metadata.tasks.TaskResult;
import com.netflix.conductor.common.run.ExternalStorageLocation;
import com.netflix.conductor.common.run.SearchResult;
import com.netflix.conductor.common.run.TaskSummary;
import com.netflix.conductor.common.run.Workflow;
import com.netflix.conductor.core.exception.NotFoundException;
import com.netflix.conductor.model.TaskModel;
import com.netflix.conductor.service.TaskService;
import com.netflix.conductor.service.WorkflowService;
import io.swagger.v3.oas.annotations.Operation;
import jakarta.validation.Valid;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/tasks"})
public class TaskResource {
    private final TaskService taskService;
    private final WorkflowService workflowService;

    public TaskResource(TaskService taskService, WorkflowService workflowService) {
        this.taskService = taskService;
        this.workflowService = workflowService;
    }

    @GetMapping(value={"/poll/{tasktype}"})
    @Operation(summary="Poll for a task of a certain type")
    public ResponseEntity<Task> poll(@PathVariable(value="tasktype") String taskType, @RequestParam(value="workerid", required=false) String workerId, @RequestParam(value="domain", required=false) String domain) {
        return Optional.ofNullable(this.taskService.poll(taskType, workerId, domain)).map(ResponseEntity::ok).orElse(ResponseEntity.noContent().build());
    }

    @GetMapping(value={"/poll/batch/{tasktype}"})
    @Operation(summary="Batch poll for a task of a certain type")
    public ResponseEntity<List<Task>> batchPoll(@PathVariable(value="tasktype") String taskType, @RequestParam(value="workerid", required=false) String workerId, @RequestParam(value="domain", required=false) String domain, @RequestParam(value="count", defaultValue="1") int count, @RequestParam(value="timeout", defaultValue="100") int timeout) {
        return Optional.ofNullable(this.taskService.batchPoll(taskType, workerId, domain, Integer.valueOf(count), Integer.valueOf(timeout))).map(ResponseEntity::ok).orElse(ResponseEntity.noContent().build());
    }

    @PostMapping(produces={"text/plain"})
    @Operation(summary="Update a task")
    public String updateTask(@RequestBody TaskResult taskResult) {
        this.taskService.updateTask(taskResult);
        return taskResult.getTaskId();
    }

    @PostMapping(value={"/update-v2"})
    @Operation(summary="Update a task and return the next available task to be processed")
    public ResponseEntity<Task> updateTaskV2(@RequestBody @Valid TaskResult taskResult) {
        TaskModel updatedTask = this.taskService.updateTask(taskResult);
        if (updatedTask == null) {
            return ResponseEntity.noContent().build();
        }
        String taskType = updatedTask.getTaskType();
        String domain = updatedTask.getDomain();
        return this.poll(taskType, taskResult.getWorkerId(), domain);
    }

    @PostMapping(value={"/{workflowId}/{taskRefName}/{status}"}, produces={"text/plain"})
    @Operation(summary="Update a task By Ref Name")
    public String updateTask(@PathVariable(value="workflowId") String workflowId, @PathVariable(value="taskRefName") String taskRefName, @PathVariable(value="status") TaskResult.Status status, @RequestParam(value="workerid", required=false) String workerId, @RequestBody Map<String, Object> output) {
        return this.taskService.updateTask(workflowId, taskRefName, status, workerId, output);
    }

    @PostMapping(value={"/{workflowId}/{taskRefName}/{status}/sync"}, produces={"application/json"})
    @Operation(summary="Update a task By Ref Name synchronously and return the updated workflow")
    public Workflow updateTaskSync(@PathVariable(value="workflowId") String workflowId, @PathVariable(value="taskRefName") String taskRefName, @PathVariable(value="status") TaskResult.Status status, @RequestParam(value="workerid", required=false) String workerId, @RequestBody Map<String, Object> output) {
        Task pending = this.taskService.getPendingTaskForWorkflow(workflowId, taskRefName);
        if (pending == null) {
            throw new NotFoundException(String.format("Found no running task %s of workflow %s to update", taskRefName, workflowId));
        }
        TaskResult taskResult = new TaskResult(pending);
        taskResult.setStatus(status);
        taskResult.getOutputData().putAll(output);
        taskResult.setWorkerId(workerId);
        this.taskService.updateTask(taskResult);
        return this.workflowService.getExecutionStatus(pending.getWorkflowInstanceId(), true);
    }

    @PostMapping(value={"/{taskId}/log"})
    @Operation(summary="Log Task Execution Details")
    public void log(@PathVariable(value="taskId") String taskId, @RequestBody String log) {
        this.taskService.log(taskId, log);
    }

    @GetMapping(value={"/{taskId}/log"})
    @Operation(summary="Get Task Execution Logs")
    public List<TaskExecLog> getTaskLogs(@PathVariable(value="taskId") String taskId) {
        return this.taskService.getTaskLogs(taskId);
    }

    @GetMapping(value={"/{taskId}"})
    @Operation(summary="Get task by Id")
    public ResponseEntity<Task> getTask(@PathVariable(value="taskId") String taskId) {
        return Optional.ofNullable(this.taskService.getTask(taskId)).map(ResponseEntity::ok).orElse(ResponseEntity.noContent().build());
    }

    @GetMapping(value={"/queue/sizes"})
    @Operation(summary="Deprecated. Please use /tasks/queue/size endpoint")
    @Deprecated
    public Map<String, Integer> size(@RequestParam(value="taskType", required=false) List<String> taskTypes) {
        return this.taskService.getTaskQueueSizes(taskTypes);
    }

    @GetMapping(value={"/queue/size"})
    @Operation(summary="Get queue size for a task type.")
    public Integer taskDepth(@RequestParam(value="taskType") String taskType, @RequestParam(value="domain", required=false) String domain, @RequestParam(value="isolationGroupId", required=false) String isolationGroupId, @RequestParam(value="executionNamespace", required=false) String executionNamespace) {
        return this.taskService.getTaskQueueSize(taskType, domain, executionNamespace, isolationGroupId);
    }

    @GetMapping(value={"/queue/all/verbose"})
    @Operation(summary="Get the details about each queue")
    public Map<String, Map<String, Map<String, Long>>> allVerbose() {
        return this.taskService.allVerbose();
    }

    @GetMapping(value={"/queue/all"})
    @Operation(summary="Get the details about each queue")
    public Map<String, Long> all() {
        return this.taskService.getAllQueueDetails();
    }

    @GetMapping(value={"/queue/polldata"})
    @Operation(summary="Get the last poll data for a given task type")
    public List<PollData> getPollData(@RequestParam(value="taskType") String taskType) {
        return this.taskService.getPollData(taskType);
    }

    @GetMapping(value={"/queue/polldata/all"})
    @Operation(summary="Get the last poll data for all task types")
    public List<PollData> getAllPollData() {
        return this.taskService.getAllPollData();
    }

    @PostMapping(value={"/queue/requeue/{taskType}"}, produces={"text/plain"})
    @Operation(summary="Requeue pending tasks")
    public String requeuePendingTask(@PathVariable(value="taskType") String taskType) {
        return this.taskService.requeuePendingTask(taskType);
    }

    @Operation(summary="Search for tasks based in payload and other parameters", description="use sort options as sort=<field>:ASC|DESC e.g. sort=name&sort=workflowId:DESC. If order is not specified, defaults to ASC")
    @GetMapping(value={"/search"})
    public SearchResult<TaskSummary> search(@RequestParam(value="start", defaultValue="0", required=false) int start, @RequestParam(value="size", defaultValue="100", required=false) int size, @RequestParam(value="sort", required=false) String sort, @RequestParam(value="freeText", defaultValue="*", required=false) String freeText, @RequestParam(value="query", required=false) String query) {
        return this.taskService.search(start, size, sort, freeText, query);
    }

    @Operation(summary="Search for tasks based in payload and other parameters", description="use sort options as sort=<field>:ASC|DESC e.g. sort=name&sort=workflowId:DESC. If order is not specified, defaults to ASC")
    @GetMapping(value={"/search-v2"})
    public SearchResult<Task> searchV2(@RequestParam(value="start", defaultValue="0", required=false) int start, @RequestParam(value="size", defaultValue="100", required=false) int size, @RequestParam(value="sort", required=false) String sort, @RequestParam(value="freeText", defaultValue="*", required=false) String freeText, @RequestParam(value="query", required=false) String query) {
        return this.taskService.searchV2(start, size, sort, freeText, query);
    }

    @Operation(summary="Get the external uri where the task payload is to be stored")
    @GetMapping(value={"/externalstoragelocation", "external-storage-location"})
    public ExternalStorageLocation getExternalStorageLocation(@RequestParam(value="path") String path, @RequestParam(value="operation") String operation, @RequestParam(value="payloadType") String payloadType) {
        return this.taskService.getExternalStorageLocation(path, operation, payloadType);
    }
}

