/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.conductor.rest.controllers;

import com.netflix.conductor.common.validation.ErrorResponse;
import com.netflix.conductor.common.validation.ValidationError;
import com.netflix.conductor.core.utils.Utils;
import com.netflix.conductor.metrics.Monitors;
import com.netflix.conductor.rest.controllers.ApplicationExceptionMapper;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.validation.ConstraintViolation;
import jakarta.validation.ConstraintViolationException;
import jakarta.validation.ValidationException;
import java.util.ArrayList;
import java.util.Arrays;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.annotation.Order;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.RestControllerAdvice;

@RestControllerAdvice
@Order(value=-2147483648)
public class ValidationExceptionMapper {
    private static final Logger LOGGER = LoggerFactory.getLogger(ApplicationExceptionMapper.class);
    public static final int ORDER = Integer.MIN_VALUE;
    private final String host = Utils.getServerId();

    @ExceptionHandler(value={ValidationException.class})
    public ResponseEntity<ErrorResponse> toResponse(HttpServletRequest request, ValidationException exception) {
        HttpStatus httpStatus;
        this.logException(request, exception);
        if (exception instanceof ConstraintViolationException) {
            httpStatus = HttpStatus.BAD_REQUEST;
        } else {
            httpStatus = HttpStatus.INTERNAL_SERVER_ERROR;
            Monitors.error((String)"error", (String)"error");
        }
        return new ResponseEntity((Object)this.toErrorResponse(exception), (HttpStatusCode)httpStatus);
    }

    private ErrorResponse toErrorResponse(ValidationException ve) {
        if (ve instanceof ConstraintViolationException) {
            return this.constraintViolationExceptionToErrorResponse((ConstraintViolationException)ve);
        }
        ErrorResponse result = new ErrorResponse();
        result.setStatus(HttpStatus.INTERNAL_SERVER_ERROR.value());
        result.setMessage(ve.getMessage());
        result.setInstance(this.host);
        return result;
    }

    private ErrorResponse constraintViolationExceptionToErrorResponse(ConstraintViolationException exception) {
        ErrorResponse errorResponse = new ErrorResponse();
        errorResponse.setStatus(HttpStatus.BAD_REQUEST.value());
        errorResponse.setMessage("Validation failed, check below errors for detail.");
        ArrayList validationErrors = new ArrayList();
        exception.getConstraintViolations().forEach(e -> validationErrors.add(new ValidationError(this.getViolationPath((ConstraintViolation<?>)e), e.getMessage(), this.getViolationInvalidValue(e.getInvalidValue()))));
        errorResponse.setValidationErrors(validationErrors);
        return errorResponse;
    }

    private String getViolationPath(ConstraintViolation<?> violation) {
        String propertyPath = violation.getPropertyPath().toString();
        return !"".equals(propertyPath) ? propertyPath : "";
    }

    private String getViolationInvalidValue(Object invalidValue) {
        if (invalidValue == null) {
            return null;
        }
        if (invalidValue.getClass().isArray()) {
            if (invalidValue instanceof Object[]) {
                return null;
            }
            if (invalidValue instanceof boolean[]) {
                return Arrays.toString((boolean[])invalidValue);
            }
            if (invalidValue instanceof byte[]) {
                return Arrays.toString((byte[])invalidValue);
            }
            if (invalidValue instanceof char[]) {
                return Arrays.toString((char[])invalidValue);
            }
            if (invalidValue instanceof double[]) {
                return Arrays.toString((double[])invalidValue);
            }
            if (invalidValue instanceof float[]) {
                return Arrays.toString((float[])invalidValue);
            }
            if (invalidValue instanceof int[]) {
                return Arrays.toString((int[])invalidValue);
            }
            if (invalidValue instanceof long[]) {
                return Arrays.toString((long[])invalidValue);
            }
            if (invalidValue instanceof short[]) {
                return Arrays.toString((short[])invalidValue);
            }
        }
        if (invalidValue.getClass().getName().startsWith("java.lang.")) {
            return invalidValue.toString();
        }
        return null;
    }

    private void logException(HttpServletRequest request, ValidationException exception) {
        LOGGER.error("Error {} url: '{}'", new Object[]{exception.getClass().getSimpleName(), request.getRequestURI(), exception});
    }
}

