/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.conductor.rest.controllers;

import com.netflix.conductor.common.model.BulkResponse;
import com.netflix.conductor.model.WorkflowModel;
import com.netflix.conductor.service.WorkflowBulkService;
import io.swagger.v3.oas.annotations.Operation;
import java.util.List;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/workflow/bulk"})
public class WorkflowBulkResource {
    private final WorkflowBulkService workflowBulkService;

    public WorkflowBulkResource(WorkflowBulkService workflowBulkService) {
        this.workflowBulkService = workflowBulkService;
    }

    @PutMapping(value={"/pause"})
    @Operation(summary="Pause the list of workflows")
    public BulkResponse<String> pauseWorkflow(@RequestBody List<String> workflowIds) {
        return this.workflowBulkService.pauseWorkflow(workflowIds);
    }

    @PutMapping(value={"/resume"})
    @Operation(summary="Resume the list of workflows")
    public BulkResponse<String> resumeWorkflow(@RequestBody List<String> workflowIds) {
        return this.workflowBulkService.resumeWorkflow(workflowIds);
    }

    @PostMapping(value={"/restart"})
    @Operation(summary="Restart the list of completed workflow")
    public BulkResponse<String> restart(@RequestBody List<String> workflowIds, @RequestParam(value="useLatestDefinitions", defaultValue="false", required=false) boolean useLatestDefinitions) {
        return this.workflowBulkService.restart(workflowIds, useLatestDefinitions);
    }

    @PostMapping(value={"/retry"})
    @Operation(summary="Retry the last failed task for each workflow from the list")
    public BulkResponse<String> retry(@RequestBody List<String> workflowIds) {
        return this.workflowBulkService.retry(workflowIds);
    }

    @PostMapping(value={"/terminate"})
    @Operation(summary="Terminate workflows execution")
    public BulkResponse<String> terminate(@RequestBody List<String> workflowIds, @RequestParam(value="reason", required=false) String reason) {
        return this.workflowBulkService.terminate(workflowIds, reason);
    }

    @DeleteMapping(value={"/remove"})
    public BulkResponse<String> deleteWorkflow(@RequestBody List<String> workflowIds, @RequestParam(value="archiveWorkflow", defaultValue="true", required=false) boolean archiveWorkflow) {
        return this.workflowBulkService.deleteWorkflow(workflowIds, archiveWorkflow);
    }

    @DeleteMapping(value={"/terminate-remove"})
    public BulkResponse<String> terminateRemove(@RequestBody List<String> workflowIds, @RequestParam(value="archiveWorkflow", defaultValue="true", required=false) boolean archiveWorkflow, @RequestParam(value="reason", required=false) String reason) {
        return this.workflowBulkService.terminateRemove(workflowIds, reason, archiveWorkflow);
    }

    @PostMapping(value={"/search"})
    public BulkResponse<WorkflowModel> searchWorkflow(@RequestBody List<String> workflowIds, @RequestParam(value="includeTasks", defaultValue="true", required=false) boolean includeTasks) {
        return this.workflowBulkService.searchWorkflow(workflowIds, includeTasks);
    }
}

