/*
 * Decompiled with CFR 0.152.
 */
package org.identityconnectors.framework.impl.serializer.xml;

import java.io.IOException;
import java.io.StringReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.DocumentBuilderFactory;
import org.identityconnectors.framework.common.exceptions.ConnectorException;
import org.identityconnectors.framework.common.serializer.XmlObjectResultsHandler;
import org.identityconnectors.framework.impl.serializer.xml.XmlObjectDecoder;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLReaderFactory;

public class XmlObjectParser {
    public static void parse(InputSource inputSource, XmlObjectResultsHandler handler, boolean validate) {
        try {
            MySAXHandler saxHandler = new MySAXHandler(handler, validate);
            XMLReader reader = XMLReaderFactory.createXMLReader();
            reader.setFeature("http://xml.org/sax/features/validation", validate);
            reader.setEntityResolver(saxHandler);
            reader.setContentHandler(saxHandler);
            reader.setErrorHandler(saxHandler);
            reader.parse(inputSource);
        }
        catch (Exception e) {
            throw ConnectorException.wrap((Throwable)e);
        }
    }

    private static class MySAXHandler
    implements ContentHandler,
    EntityResolver,
    ErrorHandler {
        private Document _currentTopLevelElementDocument;
        private List<Element> _elementStack = new ArrayList<Element>(10);
        private final boolean _validate;
        private final XmlObjectResultsHandler _handler;
        private boolean _stillHandling = true;

        public MySAXHandler(XmlObjectResultsHandler handler, boolean validate) {
            this._handler = handler;
            this._validate = validate;
        }

        private Element getCurrentElement() {
            if (this._elementStack.size() > 0) {
                return this._elementStack.get(this._elementStack.size() - 1);
            }
            return null;
        }

        @Override
        public void characters(char[] ch, int start, int length) {
            Element currentElement = this.getCurrentElement();
            if (currentElement != null) {
                currentElement.appendChild(this._currentTopLevelElementDocument.createTextNode(new String(ch, start, length)));
            }
        }

        @Override
        public void endDocument() {
        }

        @Override
        public void endElement(String namespaceURI, String localName, String qName) {
            if (this._elementStack.size() > 0) {
                Element element = this._elementStack.remove(this._elementStack.size() - 1);
                if (this._elementStack.isEmpty()) {
                    this._currentTopLevelElementDocument = null;
                    if (this._stillHandling) {
                        XmlObjectDecoder decoder = new XmlObjectDecoder(element, null);
                        Object object = decoder.readObject();
                        this._stillHandling = this._handler.handle(object);
                    }
                }
            }
        }

        @Override
        public void endPrefixMapping(String prefix) {
        }

        @Override
        public void ignorableWhitespace(char[] ch, int start, int length) {
            Element currentElement = this.getCurrentElement();
            if (currentElement != null) {
                currentElement.appendChild(this._currentTopLevelElementDocument.createTextNode(new String(ch, start, length)));
            }
        }

        @Override
        public void processingInstruction(String target, String data) {
        }

        @Override
        public void setDocumentLocator(Locator locator) {
        }

        @Override
        public void skippedEntity(String name) {
        }

        @Override
        public void startDocument() {
        }

        @Override
        public void startElement(String namespaceURI, String localName, String qName, Attributes atts) {
            Element element = null;
            if (this._elementStack.isEmpty()) {
                if (!"MultiObject".equals(localName)) {
                    try {
                        this._currentTopLevelElementDocument = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
                    }
                    catch (Exception e) {
                        throw ConnectorException.wrap((Throwable)e);
                    }
                    element = this._currentTopLevelElementDocument.createElement(localName);
                }
            } else {
                element = this._currentTopLevelElementDocument.createElement(localName);
                this.getCurrentElement().appendChild(element);
            }
            if (element != null) {
                this._elementStack.add(element);
                for (int i = 0; i < atts.getLength(); ++i) {
                    String attrName = atts.getLocalName(i);
                    String value = atts.getValue(i);
                    element.setAttribute(attrName, value);
                }
            }
        }

        @Override
        public void startPrefixMapping(String prefix, String uri) {
        }

        @Override
        public InputSource resolveEntity(String pubid, String sysid) throws SAXException {
            if ("connectors.dtd".equals(pubid)) {
                if (!this._validate) {
                    return new InputSource(new StringReader("<?xml version='1.0' encoding='UTF-8'?>"));
                }
                try {
                    URL resoUrl = XmlObjectParser.class.getResource(pubid);
                    return new InputSource(resoUrl.openStream());
                }
                catch (IOException e) {
                    e.printStackTrace();
                    throw new SAXException(e);
                }
            }
            return null;
        }

        @Override
        public void error(SAXParseException exception) throws SAXException {
            throw exception;
        }

        @Override
        public void fatalError(SAXParseException exception) throws SAXException {
            throw exception;
        }

        @Override
        public void warning(SAXParseException exception) {
        }
    }
}

