/*
 * Decompiled with CFR 0.152.
 */
package org.conscrypt;

import java.util.Arrays;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.NoSuchElementException;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSessionContext;
import org.conscrypt.ByteArray;
import org.conscrypt.NativeCrypto;
import org.conscrypt.SslSessionWrapper;

abstract class AbstractSessionContext
implements SSLSessionContext {
    private static final int DEFAULT_SESSION_TIMEOUT_SECONDS = 28800;
    private volatile int maximumSize;
    private volatile int timeout = 28800;
    final long sslCtxNativePointer = NativeCrypto.SSL_CTX_new();
    private final Map<ByteArray, SslSessionWrapper> sessions = new LinkedHashMap<ByteArray, SslSessionWrapper>(){

        @Override
        protected boolean removeEldestEntry(Map.Entry<ByteArray, SslSessionWrapper> eldest) {
            if (AbstractSessionContext.this.maximumSize > 0 && this.size() > AbstractSessionContext.this.maximumSize) {
                AbstractSessionContext.this.onBeforeRemoveSession(eldest.getValue());
                return true;
            }
            return false;
        }
    };

    AbstractSessionContext(int maximumSize) {
        this.maximumSize = maximumSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final Enumeration<byte[]> getIds() {
        Iterator<SslSessionWrapper> iter;
        Map<ByteArray, SslSessionWrapper> map = this.sessions;
        synchronized (map) {
            iter = Arrays.asList(this.sessions.values().toArray(new SslSessionWrapper[this.sessions.size()])).iterator();
        }
        return new Enumeration<byte[]>(){
            private SslSessionWrapper next;

            @Override
            public boolean hasMoreElements() {
                if (this.next != null) {
                    return true;
                }
                while (iter.hasNext()) {
                    SslSessionWrapper session = (SslSessionWrapper)iter.next();
                    if (!session.isValid()) continue;
                    this.next = session;
                    return true;
                }
                this.next = null;
                return false;
            }

            @Override
            public byte[] nextElement() {
                if (this.hasMoreElements()) {
                    byte[] id = this.next.getId();
                    this.next = null;
                    return id;
                }
                throw new NoSuchElementException();
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final SSLSession getSession(byte[] sessionId) {
        SslSessionWrapper session;
        if (sessionId == null) {
            throw new NullPointerException("sessionId");
        }
        ByteArray key = new ByteArray(sessionId);
        Map<ByteArray, SslSessionWrapper> map = this.sessions;
        synchronized (map) {
            session = this.sessions.get(key);
        }
        if (session != null && session.isValid()) {
            return session.toSSLSession();
        }
        return null;
    }

    @Override
    public final int getSessionCacheSize() {
        return this.maximumSize;
    }

    @Override
    public final int getSessionTimeout() {
        return this.timeout;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void setSessionTimeout(int seconds) throws IllegalArgumentException {
        if (seconds < 0) {
            throw new IllegalArgumentException("seconds < 0");
        }
        Map<ByteArray, SslSessionWrapper> map = this.sessions;
        synchronized (map) {
            this.timeout = seconds;
            if (seconds > 0) {
                NativeCrypto.SSL_CTX_set_timeout(this.sslCtxNativePointer, seconds);
            } else {
                NativeCrypto.SSL_CTX_set_timeout(this.sslCtxNativePointer, Integer.MAX_VALUE);
            }
            Iterator<SslSessionWrapper> i = this.sessions.values().iterator();
            while (i.hasNext()) {
                SslSessionWrapper session = i.next();
                if (session.isValid()) continue;
                this.onBeforeRemoveSession(session);
                i.remove();
            }
        }
    }

    @Override
    public final void setSessionCacheSize(int size) throws IllegalArgumentException {
        if (size < 0) {
            throw new IllegalArgumentException("size < 0");
        }
        int oldMaximum = this.maximumSize;
        this.maximumSize = size;
        if (size < oldMaximum) {
            this.trimToSize();
        }
    }

    protected void finalize() throws Throwable {
        try {
            NativeCrypto.SSL_CTX_free(this.sslCtxNativePointer);
        }
        finally {
            super.finalize();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void cacheSession(SslSessionWrapper session) {
        byte[] id = session.getId();
        if (id == null || id.length == 0) {
            return;
        }
        this.onBeforeAddSession(session);
        ByteArray key = new ByteArray(id);
        Map<ByteArray, SslSessionWrapper> map = this.sessions;
        synchronized (map) {
            this.sessions.put(key, session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final SslSessionWrapper getSessionFromCache(byte[] sessionId) {
        SslSessionWrapper session;
        if (sessionId == null) {
            return null;
        }
        Map<ByteArray, SslSessionWrapper> map = this.sessions;
        synchronized (map) {
            session = this.sessions.get(new ByteArray(sessionId));
        }
        if (session != null && session.isValid()) {
            return session;
        }
        return this.getSessionFromPersistentCache(sessionId);
    }

    abstract void onBeforeAddSession(SslSessionWrapper var1);

    abstract void onBeforeRemoveSession(SslSessionWrapper var1);

    abstract SslSessionWrapper getSessionFromPersistentCache(byte[] var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void trimToSize() {
        Map<ByteArray, SslSessionWrapper> map = this.sessions;
        synchronized (map) {
            int size = this.sessions.size();
            if (size > this.maximumSize) {
                int removals = size - this.maximumSize;
                Iterator<SslSessionWrapper> i = this.sessions.values().iterator();
                while (removals-- > 0) {
                    SslSessionWrapper session = i.next();
                    this.onBeforeRemoveSession(session);
                    i.remove();
                }
            }
        }
    }
}

