/*
 * Decompiled with CFR 0.152.
 */
package guru.nidi.graphviz.engine;

import guru.nidi.graphviz.engine.AbstractGraphvizEngine;
import guru.nidi.graphviz.engine.BuiltInRasterizer;
import guru.nidi.graphviz.engine.EngineResult;
import guru.nidi.graphviz.engine.GraphvizException;
import guru.nidi.graphviz.engine.IoUtils;
import guru.nidi.graphviz.engine.Options;
import guru.nidi.graphviz.engine.Rasterizer;
import guru.nidi.graphviz.service.SystemUtils;
import java.io.IOException;
import java.io.InputStream;
import java.util.AbstractMap;
import java.util.Map;

public abstract class AbstractJsGraphvizEngine
extends AbstractGraphvizEngine {
    public AbstractJsGraphvizEngine(boolean sync) {
        super(sync);
    }

    @Override
    public EngineResult execute(String src, Options options, Rasterizer rasterizer) {
        if (rasterizer instanceof BuiltInRasterizer) {
            throw new GraphvizException("Built-in Rasterizer can only be used together with GraphvizCmdLineEngine.");
        }
        return EngineResult.fromString(this.jsExecute(this.jsVizExec(src, options)));
    }

    protected abstract String jsExecute(String var1);

    protected String jsVizExec(String src, Options options) {
        if (src.startsWith("totalMemory") || src.startsWith("render")) {
            return src;
        }
        String memory = options.totalMemory == null ? "" : "totalMemory=" + options.totalMemory + ";";
        Map.Entry<String, Options> srcAndOpts = this.preprocessCode(src, options);
        String render = "render('" + srcAndOpts.getKey() + "'," + srcAndOpts.getValue().toJson(false) + ");";
        return memory + render;
    }

    protected Map.Entry<String, Options> preprocessCode(String src, Options options) {
        if (src.contains("<img")) {
            throw new GraphvizException("Found <img> tag. This is not supported by JS engines. Either use the GraphvizCmdLineEngine or a node with image attribute.");
        }
        Options[] opts = new Options[]{options};
        String pathsReplaced = this.replacePaths(src, IMAGE_ATTR, path -> {
            String realPath = SystemUtils.uriPathOf(this.replacePath((String)path, options.basedir));
            opts[0] = opts[0].image(realPath);
            return realPath;
        });
        return new AbstractMap.SimpleEntry<String, Options>(this.jsEscape(pathsReplaced), opts[0]);
    }

    protected String jsEscape(String js) {
        return js.replaceAll("\\R", " ").replace("\\", "\\\\").replace("'", "\\'");
    }

    protected String jsVizCode() throws IOException {
        String path = "/META-INF/resources/webjars/viz.js/2.1.2/";
        try (InputStream api = this.getClass().getResourceAsStream("/META-INF/resources/webjars/viz.js/2.1.2/viz.js");){
            String string;
            block12: {
                InputStream engine = this.getClass().getResourceAsStream("/META-INF/resources/webjars/viz.js/2.1.2/full.render.js");
                try {
                    string = IoUtils.readStream(api) + IoUtils.readStream(engine);
                    if (engine == null) break block12;
                }
                catch (Throwable throwable) {
                    if (engine != null) {
                        try {
                            engine.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                engine.close();
            }
            return string;
        }
    }

    protected String jsInitEnv() {
        return "var viz; var totalMemory = 16777216;function initViz(force){  if (force || !viz || viz.totalMemory !== totalMemory){    viz = new Viz({      Module: function(){ return Viz.Module({TOTAL_MEMORY: totalMemory}); },      render: Viz.render    });    viz.totalMemory = totalMemory;  }  return viz;}function render(src, options){  try {    initViz().renderString(src, options)      .then(function(res) { result(res); })      .catch(function(err) { initViz(true); error(err.toString()); });  } catch(e) { error(e.toString()); }}";
    }
}

