/*
 * Decompiled with CFR 0.152.
 */
package guru.nidi.graphviz.engine;

import guru.nidi.graphviz.engine.Communicator;
import guru.nidi.graphviz.engine.Format;
import guru.nidi.graphviz.engine.Graphviz;
import guru.nidi.graphviz.engine.GraphvizEngine;
import guru.nidi.graphviz.engine.GraphvizException;
import guru.nidi.graphviz.engine.Options;
import guru.nidi.graphviz.service.SystemUtils;
import java.io.IOException;
import java.lang.invoke.LambdaMetafactory;
import java.net.ServerSocket;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class GraphvizServer {
    private static final Logger LOG = LoggerFactory.getLogger(GraphvizServer.class);
    static final int PORT = 10234;

    private GraphvizServer() {
    }

    public static void start(List<GraphvizEngine> engines) throws IOException {
        String executable = SystemUtils.executableName("java");
        ArrayList<String> cmd = new ArrayList<String>(Arrays.asList(System.getProperty("java.home") + "/bin/" + executable, "-cp", System.getProperty("java.class.path"), GraphvizServer.class.getName()));
        cmd.addAll(engines.stream().map(e -> e.getClass().getName()).collect(Collectors.toList()));
        new ProcessBuilder(cmd).inheritIO().start();
    }

    /*
     * Unable to fully structure code
     */
    public static void main(String ... args) throws IOException {
        block25: {
            GraphvizServer.LOG.info("starting graphviz server...");
            if (args.length > 0) {
                Graphviz.useEngine(Arrays.stream(args).map((Function<String, GraphvizEngine>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, engineFromString(java.lang.String ), (Ljava/lang/String;)Lguru/nidi/graphviz/engine/GraphvizEngine;)()).collect(Collectors.toList()));
            }
            GraphvizServer.LOG.info("started, using engines " + Arrays.toString(args));
            ss = new ServerSocket(10234);
            try {
                while (true) {
                    try {
                        while (true) lbl-1000:
                        // 6 sources

                        {
                            socket = ss.accept();
                            try {
                                com = new Communicator(socket, 500);
                                try {
                                    len = com.readLen();
                                    if (len == 0) ** GOTO lbl-1000
                                    if (len != -1) {
                                        s = com.readContent(len);
                                        try {
                                            svg = GraphvizServer.render(s);
                                            com.writeStatus("ok");
                                            com.writeContent(svg);
                                        }
                                        catch (GraphvizException e) {
                                            com.writeStatus("fail");
                                            com.writeContent(e.getMessage());
                                        }
                                    }
                                    break block25;
                                }
                                finally {
                                    com.close();
                                }
                            }
                            finally {
                                if (socket == null) continue;
                                socket.close();
                                continue;
                            }
                            break;
                        }
                    }
                    catch (Exception e) {
                        GraphvizServer.LOG.warn("Problem in communication", (Throwable)e);
                        continue;
                    }
                    ** GOTO lbl-1000
                    break;
                }
            }
            finally {
                ss.close();
            }
        }
        GraphvizServer.LOG.info("graphviz server stopped.");
    }

    private static GraphvizEngine engineFromString(String s) {
        try {
            Object o = Class.forName(s).getConstructor(new Class[0]).newInstance(new Object[0]);
            if (!(o instanceof GraphvizEngine)) {
                throw new IllegalArgumentException(s + " does not implement GraphvizEngine.");
            }
            return (GraphvizEngine)o;
        }
        catch (ReflectiveOperationException e) {
            throw new IllegalArgumentException("class " + s + " not found.");
        }
    }

    private static String render(String raw) {
        String src;
        Options options;
        int pos = raw.indexOf("@@@");
        if (pos < 0) {
            options = Options.create().format(Format.SVG_STANDALONE);
            src = raw;
        } else {
            options = Options.fromJson(raw.substring(0, pos));
            src = raw.substring(pos + 3);
        }
        return Graphviz.fromString(src).engine(options.engine).totalMemory(options.totalMemory).yInvert(options.yInvert).render(options.format).toString();
    }
}

