/*
 * Decompiled with CFR 0.152.
 */
package org.contextmapper.contextmap.generator;

import guru.nidi.graphviz.attribute.Attributes;
import guru.nidi.graphviz.attribute.Label;
import guru.nidi.graphviz.attribute.Shape;
import guru.nidi.graphviz.engine.Format;
import guru.nidi.graphviz.engine.Graphviz;
import guru.nidi.graphviz.engine.Renderer;
import guru.nidi.graphviz.model.Factory;
import guru.nidi.graphviz.model.Link;
import guru.nidi.graphviz.model.LinkSource;
import guru.nidi.graphviz.model.LinkTarget;
import guru.nidi.graphviz.model.MutableGraph;
import guru.nidi.graphviz.model.MutableNode;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.TreeMap;
import java.util.stream.Collectors;
import org.contextmapper.contextmap.generator.model.BoundedContext;
import org.contextmapper.contextmap.generator.model.BoundedContextType;
import org.contextmapper.contextmap.generator.model.ContextMap;
import org.contextmapper.contextmap.generator.model.DownstreamPatterns;
import org.contextmapper.contextmap.generator.model.Partnership;
import org.contextmapper.contextmap.generator.model.Relationship;
import org.contextmapper.contextmap.generator.model.SharedKernel;
import org.contextmapper.contextmap.generator.model.UpstreamDownstreamRelationship;
import org.contextmapper.contextmap.generator.model.UpstreamPatterns;

public class ContextMapGenerator {
    private static final String EDGE_SPACING_UNIT = "        ";
    private static final String TEAM_ICON_FILE_NAME = "team-icon.png";
    private Map<String, MutableNode> bcNodesMap;
    private Set<MutableNode> genericNodes;
    private Set<MutableNode> teamNodes;
    private File baseDir = new File(System.getProperty("java.io.tmpdir") + File.separator + "GraphvizJava");
    protected int labelSpacingFactor = 1;
    protected int height = 1000;
    protected int width = 2000;
    protected boolean useHeight = false;
    protected boolean useWidth = true;
    protected boolean clusterTeams = true;

    public ContextMapGenerator setBaseDir(File baseDir) {
        this.baseDir = baseDir;
        return this;
    }

    public ContextMapGenerator setLabelSpacingFactor(int spacingFactor) {
        this.labelSpacingFactor = spacingFactor < 1 ? 1 : (spacingFactor > 20 ? 20 : spacingFactor);
        return this;
    }

    public ContextMapGenerator setHeight(int height) {
        this.useHeight = true;
        this.useWidth = false;
        this.height = height;
        return this;
    }

    public ContextMapGenerator setWidth(int width) {
        this.useWidth = true;
        this.useHeight = false;
        this.width = width;
        return this;
    }

    public ContextMapGenerator clusterTeams(boolean clusterTeams) {
        this.clusterTeams = clusterTeams;
        return this;
    }

    public void generateContextMapGraphic(ContextMap contextMap, Format format, String fileName) throws IOException {
        this.generateContextMapGraphic(contextMap, format).toFile(new File(fileName));
    }

    public void generateContextMapGraphic(ContextMap contextMap, Format format, OutputStream outputStream) throws IOException {
        this.generateContextMapGraphic(contextMap, format).toOutputStream(outputStream);
    }

    private Renderer generateContextMapGraphic(ContextMap contextMap, Format format) throws IOException {
        this.exportImages();
        MutableGraph graph = this.createGraph(contextMap, format == Format.DOT);
        if (this.useWidth) {
            return Graphviz.fromGraph(graph).basedir(this.baseDir).width(this.width).render(format);
        }
        return Graphviz.fromGraph(graph).basedir(this.baseDir).height(this.height).render(format);
    }

    private MutableGraph createGraph(ContextMap contextMap, boolean withImagePath) {
        this.bcNodesMap = new TreeMap<String, MutableNode>();
        this.genericNodes = new HashSet<MutableNode>();
        this.teamNodes = new HashSet<MutableNode>();
        MutableGraph rootGraph = this.createGraph("ContextMapGraph", withImagePath);
        this.createNodes(contextMap.getBoundedContexts());
        if (!this.needsSubGraphs(contextMap)) {
            this.addNodesToGraph(rootGraph, this.bcNodesMap.values());
            this.createRelationshipLinks4ExistingNodes(contextMap.getRelationships());
        } else {
            MutableGraph genericGraph = this.createGraph(this.getSubgraphName("GenericSubgraph"), withImagePath).graphAttrs().add("color", "white");
            this.addNodesToGraph(genericGraph, this.genericNodes);
            MutableGraph teamGraph = this.createGraph(this.getSubgraphName("Teams_Subgraph"), withImagePath).graphAttrs().add("color", "white");
            this.addNodesToGraph(teamGraph, this.teamNodes);
            genericGraph.addTo(rootGraph);
            teamGraph.addTo(rootGraph);
            this.createRelationshipLinks4ExistingNodes(contextMap.getRelationships().stream().filter(rel -> rel.getFirstParticipant().getType() == rel.getSecondParticipant().getType()).collect(Collectors.toSet()));
            this.createRelationshipLinks(rootGraph, contextMap.getRelationships().stream().filter(rel -> rel.getFirstParticipant().getType() != rel.getSecondParticipant().getType()).collect(Collectors.toSet()));
            this.createTeamImplementationLinks(rootGraph, contextMap.getBoundedContexts().stream().filter(bc -> bc.getType() == BoundedContextType.TEAM && !bc.getRealizedBoundedContexts().isEmpty()).collect(Collectors.toList()));
        }
        return rootGraph;
    }

    private String getSubgraphName(String baseName) {
        return this.clusterTeams ? "cluster_" + baseName : baseName;
    }

    private boolean needsSubGraphs(ContextMap contextMap) {
        boolean hasTeams = contextMap.getBoundedContexts().stream().anyMatch(bc -> bc.getType() == BoundedContextType.TEAM);
        boolean hasGenericContexts = contextMap.getBoundedContexts().stream().anyMatch(bc -> bc.getType() == BoundedContextType.GENERIC);
        return hasGenericContexts && hasTeams;
    }

    private MutableGraph createGraph(String name, boolean withImagePath) {
        MutableGraph rootGraph = Factory.mutGraph(name);
        rootGraph.setDirected(true);
        if (withImagePath) {
            rootGraph.graphAttrs().add(Attributes.attr("imagepath", this.baseDir.getAbsolutePath()));
        }
        return rootGraph;
    }

    private void addNodesToGraph(MutableGraph graph, Collection<MutableNode> nodes) {
        for (MutableNode node : nodes) {
            graph.add((LinkSource)node);
        }
    }

    private void createNodes(Set<BoundedContext> boundedContexts) {
        boundedContexts.forEach(bc -> {
            MutableNode node = this.createNode((BoundedContext)bc);
            this.bcNodesMap.put(bc.getName(), node);
            if (bc.getType() == BoundedContextType.TEAM) {
                this.teamNodes.add(node);
            } else {
                this.genericNodes.add(node);
            }
        });
    }

    private MutableNode createNode(BoundedContext bc) {
        MutableNode node = Factory.mutNode(bc.getName());
        node.add((Attributes)this.createNodeLabel(bc));
        node.add((Attributes)Shape.EGG);
        node.add(Attributes.attr("margin", "0.3"));
        node.add(Attributes.attr("orientation", this.orientationDegree()));
        node.add(Attributes.attr("fontname", "sans-serif"));
        node.add(Attributes.attr("fontsize", "16"));
        node.add(Attributes.attr("style", "bold"));
        return node;
    }

    private void createRelationshipLinks4ExistingNodes(Set<Relationship> relationships) {
        relationships.forEach(rel -> this.createRelationshipLink(this.bcNodesMap.get(rel.getFirstParticipant().getName()), this.bcNodesMap.get(rel.getSecondParticipant().getName()), (Relationship)rel));
    }

    private void createRelationshipLinks(MutableGraph graph, Set<Relationship> relationships) {
        relationships.forEach(rel -> {
            MutableNode node1 = this.createNode(rel.getFirstParticipant());
            MutableNode node2 = this.createNode(rel.getSecondParticipant());
            this.createRelationshipLink(node1, node2, (Relationship)rel);
            graph.add((LinkSource)node1);
            graph.add((LinkSource)node2);
        });
    }

    private void createRelationshipLink(MutableNode node1, MutableNode node2, Relationship rel) {
        if (rel instanceof Partnership) {
            node1.addLink((LinkTarget)((Link)Factory.to(node2).with((Attributes)this.createRelationshipLabel("Partnership", rel.getName(), rel.getImplementationTechnology()))).add(Attributes.attr("dir", "none")).add(Attributes.attr("fontname", "sans-serif")).add(Attributes.attr("style", "bold")).add(Attributes.attr("fontsize", "12")));
        } else if (rel instanceof SharedKernel) {
            node1.addLink((LinkTarget)((Link)Factory.to(node2).with((Attributes)this.createRelationshipLabel("Shared Kernel", rel.getName(), rel.getImplementationTechnology()))).add(Attributes.attr("dir", "none")).add(Attributes.attr("fontname", "sans-serif")).add(Attributes.attr("style", "bold")).add(Attributes.attr("fontsize", "12")));
        } else {
            UpstreamDownstreamRelationship upDownRel = (UpstreamDownstreamRelationship)rel;
            node1.addLink((LinkTarget)Factory.to(node2).with(this.createRelationshipLabel(upDownRel.isCustomerSupplier() ? "Customer/Supplier" : "", rel.getName(), rel.getImplementationTechnology()), Attributes.attr("dir", "none"), Attributes.attr("labeldistance", "0"), Attributes.attr("fontname", "sans-serif"), Attributes.attr("fontsize", "12"), Attributes.attr("style", "bold"), Attributes.attr("headlabel", this.getEdgeHTMLLabel("D", this.downstreamPatternsToStrings(upDownRel.getDownstreamPatterns()))), Attributes.attr("taillabel", this.getEdgeHTMLLabel("U", this.upstreamPatternsToStrings(upDownRel.getUpstreamPatterns())))));
        }
    }

    private void createTeamImplementationLinks(MutableGraph graph, List<BoundedContext> teams) {
        for (BoundedContext team : teams) {
            team.getRealizedBoundedContexts().forEach(system -> {
                if (this.bcNodesMap.containsKey(team.getName()) && this.bcNodesMap.containsKey(system.getName())) {
                    MutableNode node1 = this.createNode(team);
                    MutableNode node2 = this.createNode((BoundedContext)system);
                    node1.addLink((LinkTarget)Factory.to(node2).with(Label.lines(this.getRealizesLabel()), Attributes.attr("color", "#686868"), Attributes.attr("fontname", "sans-serif"), Attributes.attr("fontsize", "12"), Attributes.attr("fontcolor", "#686868"), Attributes.attr("style", "dashed")));
                    graph.add((LinkSource)node1);
                    graph.add((LinkSource)node2);
                }
            });
        }
    }

    private String getRealizesLabel() {
        return System.getProperty("os.name").toLowerCase().indexOf("win") >= 0 ? "  \"realizes\"" : "  \u00abrealizes\u00bb";
    }

    private Label createNodeLabel(BoundedContext boundedContext) {
        if (boundedContext.getType() == BoundedContextType.TEAM) {
            return Label.html("<table cellspacing=\"0\" cellborder=\"0\" border=\"0\"><tr><td rowspan=\"2\"><img src='team-icon.png' /></td><td width=\"10px\"></td><td><b>Team</b></td></tr><tr><td width=\"10px\"></td><td>" + boundedContext.getName() + "</td></tr></table>");
        }
        return Label.lines(boundedContext.getName());
    }

    private Label createRelationshipLabel(String relationshipType, String relationshipName, String implementationTechnology) {
        boolean relationshipTypeDefined = relationshipType != null && !"".equals(relationshipType);
        boolean nameDefined = relationshipName != null && !"".equals(relationshipName);
        boolean implementationTechnologyDefined = implementationTechnology != null && !"".equals(implementationTechnology);
        String label = relationshipType;
        if (relationshipTypeDefined && nameDefined && implementationTechnologyDefined) {
            label = relationshipName + " (" + relationshipType + " implemented with " + implementationTechnology + ")";
        } else if (nameDefined && implementationTechnologyDefined) {
            label = relationshipName + " (" + implementationTechnology + ")";
        } else if (relationshipTypeDefined && implementationTechnologyDefined) {
            label = relationshipType + " (" + implementationTechnology + ")";
        } else if (relationshipTypeDefined && nameDefined) {
            label = relationshipName + " (" + relationshipType + ")";
        } else if (nameDefined) {
            label = relationshipName;
        } else if (implementationTechnologyDefined) {
            label = implementationTechnology;
        }
        if (!"".equals(label)) {
            return Label.of(label);
        }
        String spacing = "";
        for (int i = 1; i <= this.labelSpacingFactor; ++i) {
            spacing = spacing + EDGE_SPACING_UNIT;
        }
        return Label.of(spacing);
    }

    private int orientationDegree() {
        return new Random().nextInt(350);
    }

    private Set<String> downstreamPatternsToStrings(Set<DownstreamPatterns> patterns) {
        return patterns.stream().map(p -> p.toString()).collect(Collectors.toSet());
    }

    private Set<String> upstreamPatternsToStrings(Set<UpstreamPatterns> patterns) {
        return patterns.stream().map(p -> p.toString()).collect(Collectors.toSet());
    }

    private Label getEdgeHTMLLabel(String upstreamDownstreamLabel, Set<String> patterns) {
        String upstreamDownstreamCell = "<td bgcolor=\"white\">" + upstreamDownstreamLabel + "</td>";
        String patternCell = "";
        String border = "0";
        if (patterns.size() > 0) {
            upstreamDownstreamCell = "<td bgcolor=\"white\" sides=\"r\">" + upstreamDownstreamLabel + "</td>";
            patternCell = "<td sides=\"trbl\" bgcolor=\"white\"><font>" + String.join((CharSequence)", ", patterns) + "</font></td>";
            border = "1";
        }
        return Label.html("<table cellspacing=\"0\" cellborder=\"" + border + "\" border=\"0\">\n<tr>" + upstreamDownstreamCell + patternCell + "</tr>\n</table>");
    }

    private void exportImages() throws IOException {
        if (!this.baseDir.exists()) {
            this.baseDir.mkdir();
        }
        if (!new File(this.baseDir, TEAM_ICON_FILE_NAME).exists()) {
            InputStream teamIconInputStream = ContextMapGenerator.class.getClassLoader().getResourceAsStream(TEAM_ICON_FILE_NAME);
            Files.copy(teamIconInputStream, Paths.get(this.baseDir.getAbsolutePath(), TEAM_ICON_FILE_NAME), StandardCopyOption.REPLACE_EXISTING);
        }
    }
}

