/*
 * Decompiled with CFR 0.152.
 */
package org.contextmapper.archunit.conditions;

import com.tngtech.archunit.core.domain.JavaClass;
import com.tngtech.archunit.core.domain.JavaField;
import com.tngtech.archunit.core.domain.JavaModifier;
import com.tngtech.archunit.lang.ArchCondition;
import com.tngtech.archunit.lang.ConditionEvent;
import com.tngtech.archunit.lang.ConditionEvents;
import com.tngtech.archunit.lang.SimpleConditionEvent;
import java.util.Optional;
import java.util.stream.Collectors;
import org.contextmapper.dsl.contextMappingDSL.BoundedContext;
import org.contextmapper.tactic.dsl.tacticdsl.Attribute;
import org.contextmapper.tactic.dsl.tacticdsl.DomainObject;
import org.contextmapper.tactic.dsl.tacticdsl.Reference;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtext.EcoreUtil2;

public abstract class AdhereToCmlDomainObjectStructure
extends ArchCondition<JavaClass> {
    private final BoundedContext cmlContext;

    protected AdhereToCmlDomainObjectStructure(String description, BoundedContext cmlContext) {
        super(description, new Object[0]);
        this.cmlContext = cmlContext;
    }

    public void check(JavaClass javaClass, ConditionEvents events) {
        Optional<? extends DomainObject> optionalObject = this.findDomainObject(javaClass, events);
        if (!optionalObject.isPresent()) {
            return;
        }
        DomainObject cmlObject = optionalObject.get();
        for (JavaField field : javaClass.getFields().stream().filter(f -> !f.getModifiers().contains(JavaModifier.STATIC)).collect(Collectors.toSet())) {
            Optional<Attribute> cmlField = cmlObject.getAttributes().stream().filter(f -> f.getName().equals(field.getName())).findAny();
            Optional<Reference> cmlReference = cmlObject.getReferences().stream().filter(r -> r.getName().equals(field.getName())).findAny();
            events.add((ConditionEvent)new SimpleConditionEvent((Object)javaClass, cmlField.isPresent() || cmlReference.isPresent(), String.format("The %s '%s' does not have a field or reference called '%s' in CML.", this.getDomainObjectType().getSimpleName(), javaClass.getSimpleName(), field.getName())));
        }
    }

    protected abstract Class<? extends DomainObject> getDomainObjectType();

    private Optional<? extends DomainObject> findDomainObject(JavaClass javaClass, ConditionEvents events) {
        Optional<DomainObject> object = EcoreUtil2.eAllOfType((EObject)this.cmlContext, this.getDomainObjectType()).stream().filter(o -> o.getName().equals(javaClass.getSimpleName())).findAny();
        events.add((ConditionEvent)new SimpleConditionEvent((Object)javaClass, object.isPresent(), String.format("The %s '%s' is not modeled in CML.", this.getDomainObjectType().getSimpleName(), javaClass.getSimpleName())));
        return object;
    }
}

